/*
 * Decompiled with CFR 0.152.
 */
package sk.alloy_smelter.integration.jei;

import java.util.ArrayList;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import sk.alloy_smelter.integration.jei.JEICategorySmeltingT1;
import sk.alloy_smelter.integration.jei.JEICategorySmeltingT2;
import sk.alloy_smelter.integration.jei.JEICategorySmeltingT3;
import sk.alloy_smelter.recipe.SmeltingRecipe;
import sk.alloy_smelter.registry.Blocks;
import sk.alloy_smelter.screen.ForgeControllerScreen;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("alloy_smelter", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new JEICategorySmeltingT1(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new JEICategorySmeltingT2(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new JEICategorySmeltingT3(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        Stream allRecipes = recipeManager.m_44051_().stream();
        ArrayList smeltingRecipes = new ArrayList();
        allRecipes.filter(recipe -> recipe.m_6671_() == SmeltingRecipe.Type.INSTANCE).forEach(r -> smeltingRecipes.add((SmeltingRecipe)r));
        registration.addRecipes(JEICategorySmeltingT1.SMELTING_RECIPE_TYPE, smeltingRecipes.stream().filter(recipe -> recipe.getRequiredTier() == 1).toList());
        registration.addRecipes(JEICategorySmeltingT2.SMELTING_RECIPE_TYPE, smeltingRecipes.stream().filter(recipe -> recipe.getRequiredTier() == 2).toList());
        registration.addRecipes(JEICategorySmeltingT3.SMELTING_RECIPE_TYPE, smeltingRecipes.stream().filter(recipe -> recipe.getRequiredTier() == 3).toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.FORGE_CONTROLLER_TIER1.get()), new RecipeType[]{JEICategorySmeltingT1.SMELTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.FORGE_CONTROLLER_TIER2.get()), new RecipeType[]{JEICategorySmeltingT1.SMELTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.FORGE_CONTROLLER_TIER3.get()), new RecipeType[]{JEICategorySmeltingT1.SMELTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.FORGE_CONTROLLER_TIER2.get()), new RecipeType[]{JEICategorySmeltingT2.SMELTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.FORGE_CONTROLLER_TIER3.get()), new RecipeType[]{JEICategorySmeltingT2.SMELTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.FORGE_CONTROLLER_TIER3.get()), new RecipeType[]{JEICategorySmeltingT3.SMELTING_RECIPE_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ForgeControllerScreen.class, 131, 47, 22, 20, new RecipeType[]{JEICategorySmeltingT1.SMELTING_RECIPE_TYPE, JEICategorySmeltingT2.SMELTING_RECIPE_TYPE, JEICategorySmeltingT3.SMELTING_RECIPE_TYPE});
    }
}

