/*
 * Decompiled with CFR 0.152.
 */
package sk.alloy_smelter.integration.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import sk.alloy_smelter.recipe.SmeltingRecipe;
import sk.alloy_smelter.registry.Blocks;

public class JEICategorySmeltingT2
implements IRecipeCategory<SmeltingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"alloy_smelter", (String)"smelting_tier2");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"alloy_smelter", (String)"textures/gui/jei_alloy_smelter.png");
    public static final RecipeType<SmeltingRecipe> SMELTING_RECIPE_TYPE = new RecipeType(UID, SmeltingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated flame;
    private final IDrawableAnimated arrow;

    public JEICategorySmeltingT2(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.FORGE_CONTROLLER_TIER2.get()));
        this.flame = helper.drawableBuilder(TEXTURE, 177, 0, 14, 14).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = helper.drawableBuilder(TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<SmeltingRecipe> getRecipeType() {
        return SMELTING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"rei.alloy_smelter.forge_controller_tier2");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SmeltingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 20, 45).addItemStack(new ItemStack((ItemLike)Items.f_42413_));
        builder.addSlot(RecipeIngredientRole.INPUT, 20, 25).addIngredients((Ingredient)recipe.m_7527_().get(0));
        if (recipe.m_7527_().size() > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 41, 25).addIngredients((Ingredient)recipe.m_7527_().get(1));
        }
        if (recipe.m_7527_().size() > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 62, 25).addIngredients((Ingredient)recipe.m_7527_().get(2));
        }
        if (recipe.m_7527_().size() > 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 83, 25).addIngredients((Ingredient)recipe.m_7527_().get(3));
        }
        if (recipe.m_7527_().size() > 4) {
            builder.addSlot(RecipeIngredientRole.INPUT, 104, 25).addIngredients((Ingredient)recipe.m_7527_().get(4));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 135, 25).addItemStack(recipe.getOutput());
    }

    public void draw(SmeltingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.flame.draw(guiGraphics, 42, 46);
        this.arrow.draw(guiGraphics, 131, 47);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, recipe.getSmeltingTime() / 20 + " \u231a/s", 286, 130, 0xFFFFFF);
        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, recipe.fuelPerTick() + " \ud83d\udd25/tick", 56, 130, 0xFFFFFF);
        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, Component.m_237115_((String)"gui.alloy_smelter.forge_tier").getString() + " " + recipe.getRequiredTier(), 16, 12, 0xFFFFFF);
        guiGraphics.m_280168_().m_85849_();
    }
}

