/*
 * Decompiled with CFR 0.152.
 */
package sk.alloy_smelter.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sk.alloy_smelter.Config;
import sk.alloy_smelter.block.ForgeControllerBlock;
import sk.alloy_smelter.block.SyncedBlockEntity;
import sk.alloy_smelter.recipe.CustomRecipeWrapper;
import sk.alloy_smelter.recipe.SmeltingRecipe;
import sk.alloy_smelter.registry.BlockEntities;
import sk.alloy_smelter.registry.Tags;
import sk.alloy_smelter.screen.ForgeControllerMenu;

public class ForgeControllerBlockEntity
extends SyncedBlockEntity
implements MenuProvider {
    private final ItemStackHandler inventory = new ItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            ForgeControllerBlockEntity.this.inventoryChanged();
        }
    };
    private static final int FUEL_SLOT = 0;
    private static final int[] INPUT_SLOTS = new int[]{1, 2, 3, 4, 5};
    private static final int OUTPUT_SLOT = 6;
    private static final int FORGE_TIERS = 3;
    private final int tier;
    private final List<BlockPos> multiblockPositions;
    private final Direction facing;
    private LazyOptional<IItemHandler> playerItemHandler;
    private LazyOptional<IItemHandler> inputHandler;
    private LazyOptional<IItemHandler> outputHandler;
    private LazyOptional<IItemHandler> fullHandler;
    protected final ContainerData data;
    private int smeltProgress;
    private int fuelTime;
    private int burnedFuelTime;

    public ForgeControllerBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)BlockEntities.FORGE_CONTROLLER_BLOCK_ENTITY.get(), position, state);
        this.facing = (Direction)state.m_61143_((Property)ForgeControllerBlock.FACING);
        this.multiblockPositions = ForgeControllerBlockEntity.generateMultiblock(position, (Direction)state.m_61143_((Property)ForgeControllerBlock.FACING));
        this.tier = ((ForgeControllerBlock)state.m_60734_()).tier;
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> ForgeControllerBlockEntity.this.smeltProgress;
                    case 1 -> ForgeControllerBlockEntity.this.fuelTime;
                    case 2 -> ForgeControllerBlockEntity.this.burnedFuelTime;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        ForgeControllerBlockEntity.this.smeltProgress = value;
                        break;
                    }
                    case 1: {
                        ForgeControllerBlockEntity.this.fuelTime = value;
                        break;
                    }
                    case 2: {
                        ForgeControllerBlockEntity.this.burnedFuelTime = value;
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
    }

    private IItemHandler insertItemCapability(final ItemStackHandler inventory) {
        return new IItemHandler(){

            public int getSlots() {
                return inventory.getSlots();
            }

            public ItemStack getStackInSlot(int slot) {
                return inventory.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack remaining;
                    if (i == 0 || (remaining = inventory.insertItem(i, stack, simulate)).m_41613_() == stack.m_41613_()) continue;
                    return remaining;
                }
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                return inventory.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return true;
            }
        };
    }

    private IItemHandler extractItemCapability(final ItemStackHandler inventory) {
        return new IItemHandler(){

            public int getSlots() {
                return 1;
            }

            public ItemStack getStackInSlot(int slot) {
                return inventory.getStackInSlot(6);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return inventory.extractItem(6, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return inventory.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        };
    }

    public IItemHandler fullItemCapability() {
        return new IItemHandler(){

            public int getSlots() {
                return ForgeControllerBlockEntity.this.inventory.getSlots();
            }

            public ItemStack getStackInSlot(int slot) {
                return ForgeControllerBlockEntity.this.inventory.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return ForgeControllerBlockEntity.this.inventory.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ForgeControllerBlockEntity.this.inventory.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return ForgeControllerBlockEntity.this.inventory.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return ForgeControllerBlockEntity.this.inventory.isItemValid(slot, stack);
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.DOWN) {
                return this.outputHandler.cast();
            }
            if (side == Direction.UP) {
                return this.inputHandler.cast();
            }
            if (side == null) {
                return this.playerItemHandler.cast();
            }
            return this.fullHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.playerItemHandler.invalidate();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
        this.fullHandler.invalidate();
    }

    public void onLoad() {
        super.onLoad();
        this.playerItemHandler = LazyOptional.of(() -> this.inventory);
        this.inputHandler = LazyOptional.of(() -> this.insertItemCapability(this.inventory));
        this.outputHandler = LazyOptional.of(() -> this.extractItemCapability(this.inventory));
        this.fullHandler = LazyOptional.of(() -> this.fullItemCapability());
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inventory.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.alloy_smelter.alloy_smelter_controller");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new ForgeControllerMenu(i, inventory, this, this.data);
    }

    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        compoundTag.m_128405_("smeltProgress", this.smeltProgress);
        compoundTag.m_128405_("fuelTime", this.fuelTime);
        compoundTag.m_128405_("burnedFuelTime", this.burnedFuelTime);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.smeltProgress = compoundTag.m_128451_("smeltProgress");
        this.fuelTime = compoundTag.m_128451_("fuelTime");
        this.burnedFuelTime = compoundTag.m_128451_("burnedFuelTime");
        this.inventory.deserializeNBT(compoundTag.m_128469_("inventory"));
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, ForgeControllerBlockEntity forgeController) {
        if (!forgeController.verifyMultiblock()) {
            return;
        }
        if (!((Boolean)blockState.m_61143_((Property)ForgeControllerBlock.LIT)).booleanValue()) {
            return;
        }
        if (level.f_46441_.m_188503_(10) == 0) {
            level.m_7785_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, SoundEvents.f_11715_, SoundSource.BLOCKS, 0.3f + level.f_46441_.m_188501_(), level.f_46441_.m_188501_() * 0.7f + 0.5f, false);
        }
        if (level.f_46441_.m_188500_() > 0.8) {
            double randH = -0.1 + 0.2 * level.f_46441_.m_188500_();
            double randW = -0.25 + 0.5 * level.f_46441_.m_188500_();
            switch (forgeController.facing) {
                case EAST: {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)blockPos.m_123341_() + 1.05, (double)blockPos.m_123342_() + 0.7 + randH, (double)blockPos.m_123343_() + 0.5 + randW, 0.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)blockPos.m_123341_() - 0.5 + randW, (double)blockPos.m_123342_() + 0.5 + randW, (double)blockPos.m_123343_() + 0.5 + randW, 0.0, 0.05, 0.0);
                    break;
                }
                case WEST: {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)blockPos.m_123341_() - 0.05, (double)blockPos.m_123342_() + 0.7 + randH, (double)blockPos.m_123343_() + 0.5 + randW, 0.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)blockPos.m_123341_() + 1.5 + randW, (double)blockPos.m_123342_() + 0.5 + randW, (double)blockPos.m_123343_() + 0.5 + randW, 0.0, 0.05, 0.0);
                    break;
                }
                case NORTH: {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)blockPos.m_123341_() + 0.5 + randW, (double)blockPos.m_123342_() + 0.7 + randH, (double)blockPos.m_123343_() - 0.05, 0.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)blockPos.m_123341_() + 0.5 + randW, (double)blockPos.m_123342_() + 0.5 + randW, (double)blockPos.m_123343_() + 1.5 + randW, 0.0, 0.05, 0.0);
                    break;
                }
                case SOUTH: {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)blockPos.m_123341_() + 0.5 + randW, (double)blockPos.m_123342_() + 0.7 + randH, (double)blockPos.m_123343_() + 1.05, 0.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)blockPos.m_123341_() + 0.5 + randW, (double)blockPos.m_123342_() + 0.5 + randW, (double)blockPos.m_123343_() - 0.5 + randW, 0.0, 0.05, 0.0);
                }
            }
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, ForgeControllerBlockEntity forgeController) {
        Optional<SmeltingRecipe> recipe;
        if (forgeController.inventory.getStackInSlot(0).m_204117_(Tags.ALLOY_SMELTER_FUEL) && forgeController.fuelTime < 1) {
            forgeController.burnedFuelTime = ForgeHooks.getBurnTime((ItemStack)forgeController.inventory.getStackInSlot(0), (RecipeType)RecipeType.f_44108_);
            forgeController.fuelTime += ForgeHooks.getBurnTime((ItemStack)forgeController.inventory.getStackInSlot(0), (RecipeType)RecipeType.f_44108_);
            forgeController.inventory.getStackInSlot(0).m_41774_(1);
        }
        if (forgeController.fuelTime > 0 && forgeController.verifyMultiblock()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (!forgeController.verifyMultiblock()) {
            return;
        }
        if (forgeController.fuelTime > 0 && ((Boolean)Config.ENABLE_PASSIVE_FUEL_CONSUMPTION.get()).booleanValue()) {
            --forgeController.fuelTime;
        }
        if ((recipe = forgeController.getMatchingRecipe()).isPresent() && forgeController.canSmelt(recipe.get())) {
            ++forgeController.smeltProgress;
            if (forgeController.smeltProgress > recipe.get().getSmeltingTime()) {
                forgeController.smeltProgress = 0;
                NonNullList<Ingredient> materials = recipe.get().m_7527_();
                if (materials.size() > 1) {
                    for (int i = 0; i < materials.size(); ++i) {
                        forgeController.inventory.getStackInSlot(INPUT_SLOTS[i]).m_41774_(((Ingredient)materials.get(i)).m_43908_()[0].m_41613_());
                    }
                } else {
                    for (int slot : INPUT_SLOTS) {
                        forgeController.inventory.getStackInSlot(slot).m_41774_(((Ingredient)materials.get(0)).m_43908_()[0].m_41613_());
                    }
                }
                if (forgeController.inventory.getStackInSlot(6) == ItemStack.f_41583_) {
                    forgeController.inventory.setStackInSlot(6, recipe.get().getOutput());
                } else if (forgeController.inventory.getStackInSlot(6).m_41720_() == recipe.get().getOutput().m_41720_()) {
                    forgeController.inventory.getStackInSlot(6).m_41769_(recipe.get().getOutput().m_41613_());
                }
            }
            forgeController.fuelTime = forgeController.fuelTime - recipe.get().fuelPerTick() + ((Boolean)Config.ENABLE_PASSIVE_FUEL_CONSUMPTION.get() != false ? 1 : 0);
        } else {
            forgeController.smeltProgress = 0;
        }
    }

    public Optional<SmeltingRecipe> getMatchingRecipe() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        ItemStackHandler container = new ItemStackHandler(this.inventory.getSlots());
        for (int i = 0; i < INPUT_SLOTS.length; ++i) {
            container.setStackInSlot(i, this.inventory.getStackInSlot(INPUT_SLOTS[i]));
        }
        for (int recipeTier = 3; recipeTier >= 1; --recipeTier) {
            Optional recipe;
            if (recipeTier > this.tier || !(recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)SmeltingRecipe.Type.INSTANCE, (Container)new CustomRecipeWrapper((IItemHandlerModifiable)container, recipeTier), this.f_58857_)).isPresent()) continue;
            return recipe;
        }
        return Optional.empty();
    }

    protected boolean canSmelt(SmeltingRecipe recipe) {
        ItemStack output = recipe.m_8043_(this.f_58857_.m_9598_());
        output.m_41619_();
        if (this.fuelTime <= 0) {
            return false;
        }
        if (this.tier < recipe.getRequiredTier()) {
            return false;
        }
        if (this.inventory.getStackInSlot(6).m_41613_() + recipe.getOutput().m_41613_() > recipe.getOutput().m_41741_()) {
            return false;
        }
        if (recipe.getOutput().m_41720_() != this.inventory.getStackInSlot(6).m_41720_() && this.inventory.getStackInSlot(6) != ItemStack.f_41583_) {
            return false;
        }
        NonNullList<Ingredient> materials = recipe.m_7527_();
        if (materials.size() > 1) {
            for (int i = 0; i < materials.size(); ++i) {
                if (((Ingredient)materials.get(i)).test(this.inventory.getStackInSlot(INPUT_SLOTS[i])) || this.inventory.getStackInSlot(INPUT_SLOTS[i]).m_41613_() >= ((Ingredient)materials.get(i)).m_43908_()[0].m_41613_()) continue;
                return false;
            }
            return true;
        }
        for (int slot : INPUT_SLOTS) {
            if (this.inventory.getStackInSlot(slot).m_41613_() < ((Ingredient)materials.get(0)).m_43908_()[0].m_41613_()) continue;
            return true;
        }
        return false;
    }

    public ItemStackHandler getItemHandler() {
        return this.inventory;
    }

    public boolean verifyMultiblock() {
        BlockState blockBelowController = this.f_58857_.m_8055_(this.multiblockPositions.get(0));
        BlockState blockAboveController = this.f_58857_.m_8055_(this.multiblockPositions.get(1));
        TagKey ALLOY_SMELTER_BLOCKS = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alloy_smelter", (String)("alloy_smelter_blocks_tier" + this.tier)));
        TagKey ALLOY_SMELTER_HOPPER = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alloy_smelter", (String)"alloy_smelter_hopper"));
        if (!blockBelowController.m_204336_(ALLOY_SMELTER_BLOCKS) && !blockBelowController.m_204336_(ALLOY_SMELTER_HOPPER)) {
            return false;
        }
        if (!blockAboveController.m_204336_(ALLOY_SMELTER_BLOCKS) && !blockAboveController.m_204336_(ALLOY_SMELTER_HOPPER)) {
            return false;
        }
        for (int i = 2; i < this.multiblockPositions.size(); ++i) {
            if (this.f_58857_.m_8055_(this.multiblockPositions.get(i)).m_204336_(ALLOY_SMELTER_BLOCKS)) continue;
            return false;
        }
        return true;
    }

    private static List<BlockPos> generateMultiblock(BlockPos controllerPos, Direction facing) {
        BlockPos[] offsets;
        ArrayList<BlockPos> posses = new ArrayList<BlockPos>();
        BlockPos center = controllerPos.m_121955_(facing.m_122424_().m_122436_());
        for (BlockPos i : offsets = new BlockPos[]{center.m_7918_(-1, -1, -1), center.m_7918_(0, -1, -1), center.m_7918_(1, -1, -1), center.m_7918_(-1, -1, 0), center.m_7918_(0, -1, 0), center.m_7918_(1, -1, 0), center.m_7918_(-1, -1, 1), center.m_7918_(0, -1, 1), center.m_7918_(1, -1, 1)}) {
            posses.add(i);
        }
        for (int i = 0; i < 2; ++i) {
            BlockPos newCenter = center.m_7918_(0, i, 0);
            posses.add(newCenter.m_122029_());
            posses.add(newCenter.m_122024_());
            posses.add(newCenter.m_122012_());
            posses.add(newCenter.m_122019_());
        }
        posses.remove(controllerPos.m_7494_());
        posses.remove(controllerPos.m_7495_());
        posses.remove(controllerPos);
        posses.add(0, controllerPos.m_7495_());
        posses.add(1, controllerPos.m_7494_());
        return List.copyOf(posses);
    }
}

