/*
 * Decompiled with CFR 0.152.
 */
package sk.alloy_smelter.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import sk.alloy_smelter.block.ForgeControllerBlockEntity;
import sk.alloy_smelter.registry.BlockEntities;

public class ForgeControllerBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public final int tier;

    public int getTier() {
        return this.tier;
    }

    public ForgeControllerBlock(BlockBehaviour.Properties properties, int tier) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.tier = tier;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, LIT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof ForgeControllerBlockEntity) {
            ((ForgeControllerBlockEntity)blockEntity).drops();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ForgeControllerBlockEntity)) {
            return InteractionResult.PASS;
        }
        ForgeControllerBlockEntity controller = (ForgeControllerBlockEntity)blockEntity;
        if (!controller.verifyMultiblock()) {
            return InteractionResult.SUCCESS;
        }
        if (!level.f_46443_) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof ForgeControllerBlockEntity) {
                ForgeControllerBlockEntity cookingPotEntity = (ForgeControllerBlockEntity)tileEntity;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)cookingPotEntity, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ForgeControllerBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return level.f_46443_ ? ForgeControllerBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)BlockEntities.FORGE_CONTROLLER_BLOCK_ENTITY.get()), ForgeControllerBlockEntity::clientTick) : ForgeControllerBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)BlockEntities.FORGE_CONTROLLER_BLOCK_ENTITY.get()), ForgeControllerBlockEntity::tick);
    }
}

