/*
 * Decompiled with CFR 0.152.
 */
package com.httpedro.attributesetter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.httpedro.attributesetter.AttributeSetterAPI;
import com.httpedro.attributesetter.Attributesetter;
import com.httpedro.attributesetter.compat.CuriosCompat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DataReloader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    public Map<ResourceLocation, JsonElement> entries = new HashMap<ResourceLocation, JsonElement>();

    public DataReloader() {
        super(GSON, "attributesetter");
    }

    public void addEntry(ResourceLocation res, JsonElement jsonElement) {
        this.entries.put(res, jsonElement);
        String path = res.m_135815_();
        if (!path.contains("/")) {
            return;
        }
        String[] splitted = path.split("/");
        String mode = splitted[0];
        String fName = splitted[1];
        JsonObject obj = jsonElement.getAsJsonObject();
        try {
            switch (mode) {
                case "entity": {
                    for (Map.Entry entry : obj.entrySet()) {
                        JsonArray mods = ((JsonElement)entry.getValue()).getAsJsonArray();
                        boolean isTag = ((String)entry.getKey()).startsWith("#");
                        for (JsonElement modElement : mods) {
                            JsonObject modObj = modElement.getAsJsonObject();
                            String opStr = !modObj.has("operation") ? "BASE" : modObj.get("operation").getAsString();
                            boolean isBase = opStr.equalsIgnoreCase("base");
                            String idStr = (String)entry.getKey();
                            if (isTag) {
                                idStr = idStr.substring(1);
                            }
                            ResourceLocation id = idStr.contains(":") ? new ResourceLocation(idStr) : new ResourceLocation(fName, idStr);
                            Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(modObj.get("attribute").getAsString()));
                            double value = modObj.get("value").getAsDouble();
                            if (attr == null) {
                                Attributesetter.LOGGER.error("Failed to find attribute {}", (Object)modObj.get("attribute").getAsString());
                                continue;
                            }
                            if (isBase) {
                                if (isTag) {
                                    AttributeSetterAPI.registerTagBaseAttribute(id, attr, modObj.get("value").getAsDouble());
                                    continue;
                                }
                                AttributeSetterAPI.registerEntityBaseAttribute(id, attr, modObj.get("value").getAsDouble());
                                continue;
                            }
                            AttributeModifier.Operation op = AttributeModifier.Operation.valueOf((String)opStr.toUpperCase());
                            AttributeModifier mod = modObj.has("uuid") ? new AttributeModifier(UUID.fromString(modObj.get("uuid").getAsString()), "ASMod", value, op) : new AttributeModifier(UUID.randomUUID(), "ASMod", value, op);
                            if (isTag) {
                                AttributeSetterAPI.registerTagAttributeModifier(id, attr, mod);
                                continue;
                            }
                            AttributeSetterAPI.registerEntityAttributeModifier(id, attr, mod);
                        }
                    }
                    break;
                }
                case "item": {
                    for (Map.Entry entry : obj.entrySet()) {
                        JsonArray mods = ((JsonElement)entry.getValue()).getAsJsonArray();
                        boolean isTag = ((String)entry.getKey()).startsWith("#");
                        for (JsonElement modElement : mods) {
                            EquipmentSlot slot;
                            JsonObject modObj = modElement.getAsJsonObject();
                            if (ModList.get().isLoaded("curios") && CuriosCompat.shouldCurioHandle((String)entry.getKey(), modObj)) continue;
                            String opStr = modObj.has("operation") ? modObj.get("operation").getAsString() : "ADDITION";
                            String slotStr = null;
                            if (modObj.has("slot")) {
                                slotStr = modObj.get("slot").getAsString();
                            }
                            String idStr = (String)entry.getKey();
                            if (isTag) {
                                idStr = idStr.substring(1);
                            }
                            ResourceLocation id = idStr.contains(":") ? new ResourceLocation(idStr) : new ResourceLocation(fName, idStr);
                            double value = modObj.get("value").getAsDouble();
                            try {
                                if (slotStr == null) {
                                    Item itemEntry = (Item)ForgeRegistries.ITEMS.getValue(id);
                                    if (itemEntry instanceof ArmorItem) {
                                        ArmorItem ai = (ArmorItem)itemEntry;
                                        slot = ai.m_40402_();
                                    } else {
                                        slot = EquipmentSlot.MAINHAND;
                                    }
                                } else {
                                    slot = EquipmentSlot.valueOf((String)slotStr.toUpperCase());
                                }
                            }
                            catch (IllegalArgumentException e) {
                                Attributesetter.LOGGER.error("Invalid slot: {}", (Object)slotStr);
                                continue;
                            }
                            Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(modObj.get("attribute").getAsString()));
                            if (attr == null) {
                                Attributesetter.LOGGER.error("Failed to find attribute {}", (Object)modObj.get("attribute").getAsString());
                                continue;
                            }
                            if (opStr.equalsIgnoreCase("base")) {
                                UUID uuid = null;
                                if (modObj.has("uuid")) {
                                    uuid = UUID.fromString(modObj.get("uuid").getAsString());
                                }
                                if (isTag) {
                                    AttributeSetterAPI.registerTagItemBaseAttribute(id, attr, value, slot, uuid);
                                    continue;
                                }
                                AttributeSetterAPI.registerItemBaseAttribute(id, attr, value, slot, uuid);
                                continue;
                            }
                            AttributeModifier.Operation op = AttributeModifier.Operation.valueOf((String)opStr.toUpperCase());
                            AttributeModifier mod = modObj.has("uuid") ? new AttributeModifier(UUID.fromString(modObj.get("uuid").getAsString()), "ASMod", value, op) : new AttributeModifier(UUID.randomUUID(), "ASMod", value, op);
                            if (isTag) {
                                AttributeSetterAPI.registerTagItemAttributeModifier(id, attr, mod, slot);
                                continue;
                            }
                            AttributeSetterAPI.registerItemAttributeModifier(id, attr, mod, slot);
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.entries.clear();
        AttributeSetterAPI.ENTITY_MODIFIERS.clear();
        AttributeSetterAPI.BASE_MODIFIERS.clear();
        AttributeSetterAPI.TAG_MODIFIERS.clear();
        AttributeSetterAPI.BASE_TAG_MODIFIERS.clear();
        AttributeSetterAPI.ITEM_MODIFIERS.clear();
        AttributeSetterAPI.TAG_ITEM_MODIFIERS.clear();
        AttributeSetterAPI.BASE_ITEM_MODIFIERS.clear();
        AttributeSetterAPI.BASE_TAG_ITEM_MODIFIERS.clear();
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.clearMaps();
        }
        Attributesetter.LOGGER.info("Reloading attributesetter, found {} files", (Object)resourceLocationJsonElementMap.size());
        for (Map.Entry<ResourceLocation, JsonElement> fileEntry : resourceLocationJsonElementMap.entrySet()) {
            this.addEntry(fileEntry.getKey(), fileEntry.getValue());
        }
    }
}

