/*
 * Decompiled with CFR 0.152.
 */
package com.httpedro.attributesetter;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import oshi.util.tuples.Pair;

public class AttributeSetterAPI {
    static final Map<ResourceLocation, Map<Attribute, AttributeModifier>> ENTITY_MODIFIERS = new HashMap<ResourceLocation, Map<Attribute, AttributeModifier>>();
    static final Map<ResourceLocation, Map<Attribute, Double>> BASE_MODIFIERS = new HashMap<ResourceLocation, Map<Attribute, Double>>();
    static final Map<ResourceLocation, Map<Attribute, AttributeModifier>> TAG_MODIFIERS = new HashMap<ResourceLocation, Map<Attribute, AttributeModifier>>();
    static final Map<ResourceLocation, Map<Attribute, Double>> BASE_TAG_MODIFIERS = new HashMap<ResourceLocation, Map<Attribute, Double>>();
    static final Map<ResourceLocation, Map<EquipmentSlot, Map<Attribute, AttributeModifier>>> ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<EquipmentSlot, Map<Attribute, AttributeModifier>>>();
    static final Map<ResourceLocation, Map<EquipmentSlot, Map<Attribute, AttributeModifier>>> TAG_ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<EquipmentSlot, Map<Attribute, AttributeModifier>>>();
    static final Map<ResourceLocation, Map<EquipmentSlot, Map<Attribute, Pair<Double, UUID>>>> BASE_ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<EquipmentSlot, Map<Attribute, Pair<Double, UUID>>>>();
    static final Map<ResourceLocation, Map<EquipmentSlot, Map<Attribute, Pair<Double, UUID>>>> BASE_TAG_ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<EquipmentSlot, Map<Attribute, Pair<Double, UUID>>>>();

    public static void registerEntityAttributeModifier(ResourceLocation entity, Attribute attr, AttributeModifier modifier) {
        if (!ENTITY_MODIFIERS.containsKey(entity)) {
            ENTITY_MODIFIERS.put(entity, new HashMap());
        }
        ENTITY_MODIFIERS.get(entity).put(attr, modifier);
    }

    public static void registerEntityBaseAttribute(ResourceLocation entity, Attribute attr, double baseValue) {
        if (!BASE_MODIFIERS.containsKey(entity)) {
            BASE_MODIFIERS.put(entity, new HashMap());
        }
        BASE_MODIFIERS.get(entity).put(attr, baseValue);
    }

    public static void registerTagAttributeModifier(ResourceLocation tag, Attribute attr, AttributeModifier modifier) {
        if (!TAG_MODIFIERS.containsKey(tag)) {
            TAG_MODIFIERS.put(tag, new HashMap());
        }
        TAG_MODIFIERS.get(tag).put(attr, modifier);
    }

    public static void registerTagBaseAttribute(ResourceLocation tag, Attribute attr, double baseValue) {
        if (!BASE_TAG_MODIFIERS.containsKey(tag)) {
            BASE_TAG_MODIFIERS.put(tag, new HashMap());
        }
        BASE_TAG_MODIFIERS.get(tag).put(attr, baseValue);
    }

    public static void registerItemAttributeModifier(ResourceLocation item, Attribute attr, AttributeModifier modifier, EquipmentSlot slot) {
        if (!ITEM_MODIFIERS.containsKey(item)) {
            ITEM_MODIFIERS.put(item, new HashMap());
        }
        if (!ITEM_MODIFIERS.get(item).containsKey(slot)) {
            ITEM_MODIFIERS.get(item).put(slot, new HashMap());
        }
        ITEM_MODIFIERS.get(item).get(slot).put(attr, modifier);
    }

    public static void registerTagItemAttributeModifier(ResourceLocation tag, Attribute attr, AttributeModifier modifier, EquipmentSlot slot) {
        if (!TAG_ITEM_MODIFIERS.containsKey(tag)) {
            TAG_ITEM_MODIFIERS.put(tag, new HashMap());
        }
        if (!TAG_ITEM_MODIFIERS.get(tag).containsKey(slot)) {
            TAG_ITEM_MODIFIERS.get(tag).put(slot, new HashMap());
        }
        TAG_ITEM_MODIFIERS.get(tag).get(slot).put(attr, modifier);
    }

    public static void registerItemBaseAttribute(ResourceLocation item, Attribute attr, double baseValue, EquipmentSlot slot) {
        AttributeSetterAPI.registerItemBaseAttribute(item, attr, baseValue, slot, null);
    }

    public static void registerItemBaseAttribute(ResourceLocation item, Attribute attr, double baseValue, EquipmentSlot slot, UUID uuid) {
        if (!BASE_ITEM_MODIFIERS.containsKey(item)) {
            BASE_ITEM_MODIFIERS.put(item, new HashMap());
        }
        if (!BASE_ITEM_MODIFIERS.get(item).containsKey(slot)) {
            BASE_ITEM_MODIFIERS.get(item).put(slot, new HashMap());
        }
        UUID deterministicUuid = uuid != null ? uuid : AttributeSetterAPI.generateDeterministicUUID(item.toString(), attr.m_22087_(), slot.m_20751_());
        BASE_ITEM_MODIFIERS.get(item).get(slot).put(attr, (Pair<Double, UUID>)new Pair((Object)baseValue, (Object)deterministicUuid));
    }

    public static void registerTagItemBaseAttribute(ResourceLocation tag, Attribute attr, double baseValue, EquipmentSlot slot) {
        AttributeSetterAPI.registerTagItemBaseAttribute(tag, attr, baseValue, slot, null);
    }

    public static void registerTagItemBaseAttribute(ResourceLocation tag, Attribute attr, double baseValue, EquipmentSlot slot, UUID uuid) {
        if (!BASE_TAG_ITEM_MODIFIERS.containsKey(tag)) {
            BASE_TAG_ITEM_MODIFIERS.put(tag, new HashMap());
        }
        if (!BASE_TAG_ITEM_MODIFIERS.get(tag).containsKey(slot)) {
            BASE_TAG_ITEM_MODIFIERS.get(tag).put(slot, new HashMap());
        }
        UUID deterministicUuid = uuid != null ? uuid : AttributeSetterAPI.generateDeterministicUUID("#" + tag.toString(), attr.m_22087_(), slot.m_20751_());
        BASE_TAG_ITEM_MODIFIERS.get(tag).get(slot).put(attr, (Pair<Double, UUID>)new Pair((Object)baseValue, (Object)deterministicUuid));
    }

    private static UUID generateDeterministicUUID(String identifier, String attribute, String slot) {
        String combined = "AttributeSetter:" + identifier + ":" + attribute + ":" + slot;
        return UUID.nameUUIDFromBytes(combined.getBytes(StandardCharsets.UTF_8));
    }
}

