/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.server;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import team.creative.creativecore.common.config.premade.MobEffectConfig;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.cap.Bleeding;
import team.creative.playerrevive.packet.HelperPacket;
import team.creative.playerrevive.server.PlayerReviveServer;

public class ReviveEventServer {
    public static boolean isReviveActive(Entity player) {
        Player p;
        if (player instanceof Player && (p = (Player)player).m_7500_() && !PlayerRevive.CONFIG.bleeding.triggerForCreative) {
            return false;
        }
        return PlayerRevive.CONFIG.bleedInSingleplayer || player.m_20194_().m_6992_();
    }

    @SubscribeEvent
    public void executeCommand(CommandEvent event) {
        CommandSourceStack source = (CommandSourceStack)event.getParseResults().getContext().getSource();
        if (PlayerRevive.CONFIG.bleeding.disableServerCommands && source.m_230897_() && PlayerReviveServer.getBleeding((Player)source.m_230896_()).isBleeding()) {
            source.m_230896_().m_213846_((Component)Component.m_237115_((String)"playerrevive.chat.no_commands"));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER && ReviveEventServer.isReviveActive((Entity)event.player)) {
            Player player = event.player;
            if (!player.m_6084_()) {
                return;
            }
            IBleeding revive = PlayerReviveServer.getBleeding(player);
            if (revive.isBleeding()) {
                revive.tick(player);
                if (revive.downedTime() % 5 == 0) {
                    PlayerReviveServer.sendUpdatePacket(player);
                }
                if (PlayerRevive.CONFIG.bleeding.affectHunger) {
                    player.m_36324_().m_38705_(PlayerRevive.CONFIG.bleeding.remainingHunger);
                }
                for (MobEffectConfig effect : PlayerRevive.CONFIG.bleeding.bleedingEffects) {
                    player.m_7292_(effect.create());
                }
                if (PlayerRevive.CONFIG.bleeding.shouldGlow) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 10));
                }
                if (revive.revived()) {
                    PlayerReviveServer.revive(player);
                } else if (revive.bledOut()) {
                    PlayerReviveServer.kill(player);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        IBleeding revive = PlayerReviveServer.getBleeding(event.getEntity());
        if (revive.isBleeding()) {
            PlayerReviveServer.kill(event.getEntity());
        }
        if (!event.getEntity().m_9236_().f_46443_) {
            PlayerReviveServer.removePlayerAsHelper(event.getEntity());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void playerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof Player && !event.getEntity().m_9236_().f_46443_) {
            Player target = (Player)event.getTarget();
            Player helper = event.getEntity();
            IBleeding revive = PlayerReviveServer.getBleeding(target);
            if (revive.isBleeding()) {
                block9: {
                    event.setCanceled(true);
                    if (PlayerRevive.CONFIG.revive.needReviveItem) {
                        if (PlayerRevive.CONFIG.revive.consumeReviveItem && !revive.isItemConsumed()) {
                            if (PlayerRevive.CONFIG.revive.reviveItem.is(helper.m_21205_())) {
                                if (!helper.m_7500_()) {
                                    helper.m_21205_().m_41774_(1);
                                    helper.m_150109_().m_6596_();
                                }
                                revive.setItemConsumed();
                                break block9;
                            } else {
                                if (!helper.m_9236_().f_46443_) {
                                    helper.m_213846_((Component)Component.m_237110_((String)"playerrevive.revive.item", (Object[])new Object[]{PlayerRevive.CONFIG.revive.reviveItem.description()}));
                                }
                                return;
                            }
                        }
                        if (!PlayerRevive.CONFIG.revive.reviveItem.is(helper.m_21205_())) {
                            return;
                        }
                    }
                }
                PlayerReviveServer.removePlayerAsHelper(helper);
                revive.revivingPlayers().add(helper);
                PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(target.m_20148_(), true), (ServerPlayer)helper);
            }
        }
    }

    private boolean doesByPass(Player player, DamageSource source) {
        Registry registry = player.m_9236_().m_9598_().m_175515_(Registries.f_268580_);
        if (source.m_269415_() == registry.m_123013_(PlayerRevive.BLED_TO_DEATH)) {
            return true;
        }
        if (PlayerRevive.CONFIG.bypassDamageSources.contains(source.m_19385_())) {
            return true;
        }
        return PlayerRevive.CONFIG.bypassDamageSources.contains(((ResourceKey)source.m_269150_().m_203543_().get()).m_135782_().toString());
    }

    @SubscribeEvent
    public void playerDamage(LivingHurtEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            IBleeding revive = PlayerReviveServer.getBleeding(player);
            if (revive.isBleeding()) {
                if (this.doesByPass(player, event.getSource())) {
                    return;
                }
                if (revive.bledOut()) {
                    event.setCanceled(true);
                }
                if (revive.downedTime() <= PlayerRevive.CONFIG.bleeding.initialDamageCooldown) {
                    event.setCanceled(true);
                }
                if (event.getSource().m_7639_() instanceof Player) {
                    if (PlayerRevive.CONFIG.bleeding.disablePlayerDamage) {
                        event.setCanceled(true);
                    }
                } else if (event.getSource().m_7639_() instanceof LivingEntity) {
                    if (PlayerRevive.CONFIG.bleeding.disableMobDamage) {
                        event.setCanceled(true);
                    }
                } else if (PlayerRevive.CONFIG.bleeding.disableOtherDamage) {
                    event.setCanceled(true);
                }
            } else if (PlayerRevive.CONFIG.revive.abortOnDamage) {
                PlayerReviveServer.removePlayerAsHelper(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerDied(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (ReviveEventServer.isReviveActive((Entity)event.getEntity()) && !event.getEntity().m_9236_().f_46443_ && !this.doesByPass(player, event.getSource())) {
                IBleeding revive = PlayerReviveServer.getBleeding(player);
                if (revive.bledOut() || revive.isBleeding()) {
                    if (revive.isBleeding()) {
                        PlayerRevive.CONFIG.sounds.death.play((Entity)player, SoundSource.PLAYERS);
                    }
                    for (Player helper : revive.revivingPlayers()) {
                        PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayer)helper);
                    }
                    revive.revivingPlayers().clear();
                    return;
                }
                PlayerReviveServer.removePlayerAsHelper(player);
                PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayer)player);
                PlayerReviveServer.startBleeding(player, event.getSource());
                if (player.m_20159_()) {
                    player.m_8127_();
                }
                event.setCanceled(true);
                if (PlayerRevive.CONFIG.bleeding.affectHunger) {
                    player.m_36324_().m_38705_(PlayerRevive.CONFIG.bleeding.remainingHunger);
                }
                player.m_21153_((float)PlayerRevive.CONFIG.bleeding.bleedingHealth);
                if (PlayerRevive.CONFIG.bleeding.bleedingMessage) {
                    if (PlayerRevive.CONFIG.bleeding.bleedingMessageTrackingOnly) {
                        ChunkSource chunkSource = player.m_9236_().m_7726_();
                        if (chunkSource instanceof ServerChunkCache) {
                            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
                            chunkCache.m_8394_((Entity)player, (Packet)new ClientboundSystemChatPacket((Component)Component.m_237110_((String)"playerrevive.chat.bleeding", (Object[])new Object[]{player.m_5446_()}), false));
                        }
                    } else {
                        player.m_20194_().m_6846_().m_240416_((Component)Component.m_237110_((String)"playerrevive.chat.bleeding", (Object[])new Object[]{player.m_5446_()}), false);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(PlayerRevive.BLEEDING_NAME, new ICapabilityProvider(){
                private LazyOptional<IBleeding> bleed = LazyOptional.of(Bleeding::new);

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                    return PlayerRevive.BLEEDING.orEmpty(cap, this.bleed);
                }
            });
        }
    }
}

