/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.registry;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dpanvil")
public class RegistryListener {
    private final List<Consumer<RegistryAccess>> listeners = new ArrayList<Consumer<RegistryAccess>>();
    private final Map<DynamicOps<?>, RegistryOps<?>> registryOps = new Reference2ObjectOpenHashMap();
    private RegistryAccess registry;
    private static final RegistryListener INSTANCE = new RegistryListener();

    private RegistryListener() {
    }

    public static RegistryListener getInstance() {
        return INSTANCE;
    }

    public void listen(Consumer<RegistryAccess> listener) {
        if (this.registry != null) {
            listener.accept(this.registry);
        } else {
            this.listeners.add(listener);
        }
    }

    public synchronized <T> RegistryOps<T> getRegistryOps(DynamicOps<T> ops) {
        if (this.registry == null) {
            throw new IllegalStateException("Registry not initialized yet!");
        }
        return this.registryOps.computeIfAbsent(ops, o -> RegistryOps.m_255058_((DynamicOps)o, (HolderLookup.Provider)this.registry));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void addReloadListeners(AddReloadListenerEvent event) {
        RegistryListener.INSTANCE.registry = null;
        RegistryListener.INSTANCE.registryOps.clear();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        RegistryListener.INSTANCE.registry = event.getRegistryAccess().m_203557_();
        RegistryListener.INSTANCE.registryOps.clear();
        RegistryListener.INSTANCE.listeners.forEach(l -> l.accept(RegistryListener.INSTANCE.registry));
        RegistryListener.INSTANCE.listeners.clear();
    }
}

