/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.codec;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import sirttas.dpanvil.api.codec.CodecHelper;

public class Codecs {
    public static final Codec<Block> BLOCK = BuiltInRegistries.f_256975_.m_194605_();
    public static final Codec<Item> ITEM = BuiltInRegistries.f_257033_.m_194605_();
    public static final Codec<Enchantment> ENCHANTMENT = BuiltInRegistries.f_256876_.m_194605_();
    public static final Codec<Attribute> ATTRIBUTE = BuiltInRegistries.f_256951_.m_194605_();
    public static final Codec<UUID> UUID_CODEC = Codec.STRING.xmap(UUID::fromString, UUID::toString);
    public static final Codec<Pattern> PATTERN = Codec.STRING.xmap(Pattern::compile, Pattern::pattern);
    public static final Codec<EquipmentSlot> EQUIPMENT_SLOT_TYPE = Codec.STRING.xmap(EquipmentSlot::m_20747_, EquipmentSlot::m_20751_);
    public static final Codec<Integer> HEX_COLOR = Codec.STRING.comapFlatMap(s -> {
        if (s.startsWith("#")) {
            return DataResult.success((Object)Integer.parseInt(s.substring(1), 16));
        }
        return DataResult.error(() -> "Couldn't parse color: '" + s + "'");
    }, i -> String.format("#%06X", i));
    public static final Codec<Integer> RGB_COLOR = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("r").forGetter(i -> i >> 16 & 0xFF), (App)Codec.INT.fieldOf("g").forGetter(i -> i >> 8 & 0xFF), (App)Codec.INT.fieldOf("b").forGetter(i -> i & 0xFF)).apply((Applicative)builder, (r, g, b) -> (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF));
    public static final Codec<Integer> COLOR = Codec.either((Codec)Codec.INT, (Codec)Codec.either(HEX_COLOR, RGB_COLOR).xmap(e -> (Integer)e.map(Function.identity(), Function.identity()), Either::left)).xmap(e -> (Integer)e.map(Function.identity(), Function.identity()), Either::left);
    private static final Codec<AttributeModifier.Operation> ATTRIBUTE_MODIFIER_OPERATION = Codec.STRING.comapFlatMap(s -> switch (s) {
        case "addition" -> DataResult.success((Object)AttributeModifier.Operation.ADDITION);
        case "multiply_base" -> DataResult.success((Object)AttributeModifier.Operation.MULTIPLY_BASE);
        case "multiply_total" -> DataResult.success((Object)AttributeModifier.Operation.MULTIPLY_TOTAL);
        default -> DataResult.error(() -> "Couldn't parse AttributeModifier Operation: '" + s + "'");
    }, o -> switch (o) {
        case AttributeModifier.Operation.MULTIPLY_BASE -> "multiply_base";
        case AttributeModifier.Operation.MULTIPLY_TOTAL -> "multiply_total";
        default -> "addition";
    });
    public static final Codec<AttributeModifier> ATTRIBUTE_MODIFIER = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(AttributeModifier::m_22214_), (App)Codec.DOUBLE.fieldOf("amount").forGetter(AttributeModifier::m_22218_), (App)ATTRIBUTE_MODIFIER_OPERATION.fieldOf("operation").forGetter(AttributeModifier::m_22217_)).apply((Applicative)builder, AttributeModifier::new));
    public static final Codec<Multimap<Attribute, AttributeModifier>> ATTRIBUTE_MULTIMAP = CodecHelper.multiMapCodec(ATTRIBUTE, ATTRIBUTE_MODIFIER);
    public static final Codec<AABB> AABB = Codec.DOUBLE.listOf().comapFlatMap(list -> Util.m_143795_((List)list, (int)6).map(doubles -> new AABB(((Double)doubles.get(0)).doubleValue(), ((Double)doubles.get(1)).doubleValue(), ((Double)doubles.get(2)).doubleValue(), ((Double)doubles.get(3)).doubleValue(), ((Double)doubles.get(4)).doubleValue(), ((Double)doubles.get(5)).doubleValue())), aabb -> List.of(Double.valueOf(aabb.f_82288_), Double.valueOf(aabb.f_82289_), Double.valueOf(aabb.f_82290_), Double.valueOf(aabb.f_82291_), Double.valueOf(aabb.f_82292_), Double.valueOf(aabb.f_82293_)));

    public static <T> Codec<ResourceKey<T>> keyCodec(ResourceKey<Registry<T>> registryKey) {
        return ResourceLocation.f_135803_.xmap(l -> ResourceKey.m_135785_((ResourceKey)registryKey, (ResourceLocation)l), ResourceKey::m_135782_);
    }

    private Codecs() {
    }
}

