/*
 * Decompiled with CFR 0.152.
 */
package toni.chunkactivitytracker.data;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import toni.chunkactivitytracker.foundation.config.AllConfigs;
import toni.lib.networking.codecs.StreamCodec;

public class ChunkActivityInfo
implements Serializable {
    public static int CODEC_VERSION = 1;
    static StreamCodec<ByteBuf, ChunkActivityInfo> CODEC = new StreamCodec<ByteBuf, ChunkActivityInfo>(){

        public ChunkActivityInfo decode(ByteBuf buffer) {
            FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
            int verson = buf.readInt();
            Map time = buf.m_236847_(key -> key.m_130259_(), FriendlyByteBuf::readLong);
            Map blocks = buf.m_236847_(key -> key.m_130259_(), FriendlyByteBuf::readInt);
            boolean hasHeightMap = buf.readBoolean();
            if (hasHeightMap) {
                long[] height = buf.m_178381_();
                return new ChunkActivityInfo(time, blocks, height);
            }
            return new ChunkActivityInfo(time, blocks, null);
        }

        public void encode(ByteBuf buffer, ChunkActivityInfo info) {
            FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
            buf.writeInt(CODEC_VERSION);
            buf.m_236831_(info.playerTimeMap, (a, b) -> a.m_130077_(b), FriendlyByteBuf::writeLong);
            buf.m_236831_(info.blocksPlacedMap, (a, b) -> a.m_130077_(b), FriendlyByteBuf::writeInt);
            if (info.initialHeightmap != null) {
                buf.writeBoolean(true);
                buf.m_130091_(info.initialHeightmap);
            } else {
                buf.writeBoolean(false);
            }
        }
    };
    private final ConcurrentHashMap<UUID, Long> playerTimeMap;
    private final ConcurrentHashMap<UUID, Integer> blocksPlacedMap;
    private long[] initialHeightmap;

    public ChunkActivityInfo(Map<UUID, Long> playerTimeInSeconds, Map<UUID, Integer> blocksPlacedByPlayer, long[] initialHeightmap) {
        this.playerTimeMap = new ConcurrentHashMap<UUID, Long>(playerTimeInSeconds);
        this.blocksPlacedMap = new ConcurrentHashMap<UUID, Integer>(blocksPlacedByPlayer);
        this.initialHeightmap = initialHeightmap;
    }

    public ChunkActivityInfo(LevelChunk chunk) {
        this.playerTimeMap = new ConcurrentHashMap();
        this.blocksPlacedMap = new ConcurrentHashMap();
        if (((Boolean)AllConfigs.server().storeHeightmaps.get()).booleanValue()) {
            Heightmap heightmap = chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
            this.initialHeightmap = heightmap.m_64239_();
        }
    }

    public void updatePlayerTime(UUID player) {
        this.playerTimeMap.merge(player, 1L, Long::sum);
    }

    public Long getPlayerTime(UUID player) {
        return this.playerTimeMap.getOrDefault(player, 0L);
    }

    public void incrementBlocksPlaced(UUID player) {
        this.blocksPlacedMap.merge(player, 1, Integer::sum);
    }

    @Generated
    public ConcurrentHashMap<UUID, Long> getPlayerTimeMap() {
        return this.playerTimeMap;
    }

    @Generated
    public ConcurrentHashMap<UUID, Integer> getBlocksPlacedMap() {
        return this.blocksPlacedMap;
    }

    @Generated
    public long[] getInitialHeightmap() {
        return this.initialHeightmap;
    }
}

