/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.forge.cobalt.network;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandlerImpl
extends NetworkHandler.Impl {
    private static final String PROTOCOL_VERSION = "1";
    private final Map<String, ChannelHolder> holders = new HashMap<String, ChannelHolder>();
    private final Map<Class<?>, SimpleChannel> channels = new HashMap();

    @Override
    public synchronized <T extends Message> void registerMessage(String namespace, Class<T> msg, Function<FriendlyByteBuf, T> constructor) {
        this.holders.computeIfAbsent(namespace, n -> new ChannelHolder(NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(namespace, "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals), new AtomicInteger(0)));
        ChannelHolder holder = this.holders.get(namespace);
        this.channels.put(msg, holder.channel());
        holder.channel().registerMessage(holder.id().getAndIncrement(), msg, Message::encode, constructor, (m, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> NetworkHandlerImpl.lambda$registerMessage$2((Supplier)ctx, m));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    @Override
    public void sendToServer(Message m) {
        this.channels.get(m.getClass()).sendToServer((Object)m);
    }

    @Override
    public void sendToPlayer(Message m, ServerPlayer e) {
        this.channels.get(m.getClass()).send(PacketDistributor.PLAYER.with(() -> e), (Object)m);
    }

    @Override
    public void sendToTrackingPlayers(Message m, Entity origin) {
        this.channels.get(m.getClass()).send(PacketDistributor.TRACKING_ENTITY.with(() -> origin), (Object)m);
    }

    private static /* synthetic */ void lambda$registerMessage$2(Supplier ctx, Message m) {
        ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
        m.receive((Player)sender);
    }

    record ChannelHolder(SimpleChannel channel, AtomicInteger id) {
    }
}

