/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.trades;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import uk.co.dotcode.customvillagertrades.ModLogger;
import uk.co.dotcode.customvillagertrades.TradeUtil;
import uk.co.dotcode.customvillagertrades.trades.MyTradeItem;

public class MyTrade {
    public MyTradeItem offer;
    public MyTradeItem[] multiOffer;
    public MyTradeItem request;
    public MyTradeItem[] multiRequest;
    public MyTradeItem additionalRequest;
    public MyTradeItem[] additionalMultiRequest;
    public int tradeExp;
    public int maxUses;
    public float priceMultiplier = 0.05f;
    public Integer demand = 0;
    public int tradeLevel;
    public String UTID;

    public MerchantOffer createTrade(Entity entity) {
        if (this.demand == null) {
            this.demand = 0;
        }
        if (this.multiOffer != null && this.multiOffer.length > 0) {
            this.offer = this.multiOffer[TradeUtil.random.nextInt(this.multiOffer.length)];
        }
        if (this.multiRequest != null && this.multiRequest.length > 0) {
            this.request = this.multiRequest[TradeUtil.random.nextInt(this.multiRequest.length)];
        }
        if (this.additionalMultiRequest != null && this.additionalMultiRequest.length > 0) {
            this.additionalRequest = this.additionalMultiRequest[TradeUtil.random.nextInt(this.additionalMultiRequest.length)];
        }
        if (this.request == null) {
            LogManager.getLogger((String)"customvillagertrades").log(Level.ERROR, "Failed to add trade, the request was null!");
        }
        if (this.offer == null) {
            LogManager.getLogger((String)"customvillagertrades").log(Level.ERROR, "Failed to add trade, the offer was null!");
        }
        MerchantOffer theTrade = this.additionalRequest != null ? new MerchantOffer(this.request.createItemStack(this.offer.getPriceModifier(), entity), this.additionalRequest.createItemStack(this.offer.getPriceModifierAdditional(), entity), this.offer.createItemStack(0, entity), 0, this.maxUses, this.tradeExp, this.priceMultiplier, this.demand.intValue()) : new MerchantOffer(this.request.createItemStack(this.offer.getPriceModifier(), entity), ItemStack.f_41583_, this.offer.createItemStack(0, entity), 0, this.maxUses, this.tradeExp, this.priceMultiplier, this.demand.intValue());
        return theTrade;
    }

    public boolean validate(String profession, int tradeEntry) {
        int i;
        boolean isValid = true;
        if (this.offer == null && this.multiOffer == null) {
            ModLogger.warn("Unable to add a custom trade! Reason: no offer or multiOffer defined - " + profession + ", entry number = " + tradeEntry);
            isValid = false;
        } else {
            if (this.offer != null && !this.offer.validate(profession, tradeEntry)) {
                isValid = false;
            }
            if (this.multiOffer != null) {
                for (i = 0; i < this.multiOffer.length; ++i) {
                    if (this.multiOffer[i].validate(profession, i)) continue;
                    isValid = false;
                }
            }
        }
        if (this.request == null && this.multiRequest == null) {
            ModLogger.warn("Unable to add a custom trade! Reason: no request or multiRequest defined - " + profession + ", entry number = " + tradeEntry);
            isValid = false;
        } else {
            if (this.request != null && !this.request.validate(profession, tradeEntry)) {
                isValid = false;
            }
            if (this.multiRequest != null) {
                for (i = 0; i < this.multiRequest.length; ++i) {
                    if (this.multiRequest[i].validate(profession, i)) continue;
                    isValid = false;
                }
            }
        }
        if (this.additionalRequest != null && !this.additionalRequest.validate(profession, tradeEntry)) {
            isValid = false;
        }
        if (this.additionalMultiRequest != null) {
            for (i = 0; i < this.additionalMultiRequest.length; ++i) {
                if (this.additionalMultiRequest[i].validate(profession, i)) continue;
                isValid = false;
            }
        }
        if (this.tradeExp < 0) {
            ModLogger.warn("Unable to add a custom trade! Reason: tradeExp cannot be less than 0 - " + profession + ", entry number = " + tradeEntry);
            isValid = false;
        }
        if (this.maxUses < 1) {
            ModLogger.warn("Unable to add a custom trade! Reason: maxUses cannot be less than 1 - " + profession + ", entry number = " + tradeEntry);
            isValid = false;
        }
        if (this.priceMultiplier < 0.0f) {
            ModLogger.warn("Unable to add a custom trade! Reason: priceMultiplier cannot be less than 0 - " + profession + ", entry number = " + tradeEntry);
            isValid = false;
        }
        if (this.demand < 0) {
            ModLogger.warn("Unable to add a custom trade! Reason: demand cannot be less than 0 - " + profession + ", entry number = " + tradeEntry);
            isValid = false;
        }
        if (this.tradeLevel < 0) {
            ModLogger.warn("Unable to add a custom trade! Reason: tradeLevel cannot be less than 0 - " + profession + ", entry number = " + tradeEntry);
            isValid = false;
        } else if (this.tradeLevel > 5) {
            ModLogger.info("You have added a trade with a tradeLevel of " + this.tradeLevel + " you can ignore this message if you have a way of overwriting the vanilla trade levels - " + profession + ", entry number = " + tradeEntry);
        }
        return isValid;
    }
}

