/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades;

import com.google.common.collect.Sets;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import uk.co.dotcode.customvillagertrades.events.TradeRegistry;
import uk.co.dotcode.customvillagertrades.forge.TradeUtilImpl;
import uk.co.dotcode.customvillagertrades.trades.MyTrade;

public class TradeUtil {
    public static Random random = new Random();
    public static RandomSource randomSource = RandomSource.m_216327_();

    public static boolean isJsonFile(File f) {
        String extension = f.getPath().substring(f.getPath().lastIndexOf("."));
        return extension.equalsIgnoreCase(".json");
    }

    public static boolean checkItemKey(String itemKey) {
        String[] splitLocation = itemKey.split(":");
        if (splitLocation.length == 2) {
            Item item = TradeUtil.getItemFromKey(itemKey);
            return item != null && item != Items.f_41852_;
        }
        return false;
    }

    public static boolean checkEnchantmentKey(String enchantmentKey) {
        if (enchantmentKey.equalsIgnoreCase("random")) {
            return true;
        }
        if (enchantmentKey.contains("#")) {
            String[] splitEnchantments = enchantmentKey.split("#");
            boolean problem = false;
            for (String s : splitEnchantments) {
                if (!TradeUtil.checkSpecificEnchantmentKey(s)) continue;
                problem = true;
            }
            return !problem;
        }
        return TradeUtil.checkSpecificEnchantmentKey(enchantmentKey);
    }

    private static boolean checkSpecificEnchantmentKey(String enchantmentKey) {
        String[] splitLocation = enchantmentKey.split(":");
        if (splitLocation.length == 2) {
            Enchantment enchantment = TradeUtil.getEnchantmentFromKey(enchantmentKey);
            return enchantment != null;
        }
        return false;
    }

    public static boolean checkEffectKey(String effectKey) {
        if (effectKey.equalsIgnoreCase("random")) {
            return true;
        }
        String[] splitLocation = effectKey.split(":");
        if (splitLocation.length == 2) {
            MobEffect effect = TradeUtil.getEffectFromKey(effectKey);
            return effect != null;
        }
        return false;
    }

    public static boolean checkPotionKey(String potionKey) {
        if (potionKey.equalsIgnoreCase("random")) {
            return true;
        }
        String[] splitLocation = potionKey.split(":");
        if (splitLocation.length == 2) {
            Potion potion = TradeUtil.getPotionFromKey(potionKey);
            return !TradeUtil.getPotionKey(potion).toString().equalsIgnoreCase("minecraft:empty");
        }
        return false;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<VillagerProfession> getAllProfessions() {
        return TradeUtilImpl.getAllProfessions();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static VillagerProfession getProfessionFromKey(String professionKey) {
        return TradeUtilImpl.getProfessionFromKey(professionKey);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getKeyFromProfession(VillagerProfession profession) {
        return TradeUtilImpl.getKeyFromProfession(profession);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Item getItemFromKey(String itemKey) {
        return TradeUtilImpl.getItemFromKey(itemKey);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Enchantment getEnchantmentFromKey(String enchantmentKey) {
        return TradeUtilImpl.getEnchantmentFromKey(enchantmentKey);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Potion getPotionFromKey(String potionKey) {
        return TradeUtilImpl.getPotionFromKey(potionKey);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MobEffect getEffectFromKey(String effectKey) {
        return TradeUtilImpl.getEffectFromKey(effectKey);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<Potion> getRegisteredPotions() {
        return TradeUtilImpl.getRegisteredPotions();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<MobEffect> getRegisteredMobEffects() {
        return TradeUtilImpl.getRegisteredMobEffects();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<Enchantment> getRegisteredEnchantments() {
        return TradeUtilImpl.getRegisteredEnchantments();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getRegistryNameItem(Item item) {
        return TradeUtilImpl.getRegistryNameItem(item);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getPotionKey(Potion potion) {
        return TradeUtilImpl.getPotionKey(potion);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getRegistryNameEffect(MobEffect effect) {
        return TradeUtilImpl.getRegistryNameEffect(effect);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getRegistryNameEnchantment(Enchantment enchantment) {
        return TradeUtilImpl.getRegistryNameEnchantment(enchantment);
    }

    public static ResourceLocation getResourceLocation(String key) {
        String[] splitLocation = key.split(":");
        return new ResourceLocation(splitLocation[0], splitLocation[1]);
    }

    public static int getIntFromColor(int r, int g, int b) {
        int rgb = r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }

    public static MyTrade generateUTID(String profession, MyTrade trade) {
        String utid = profession + "_" + TradeUtil.assembleUTIDString(trade);
        for (int loopCounter = 0; TradeRegistry.usedUTIDs.containsKey(utid) && loopCounter <= 5; ++loopCounter) {
            utid = profession + "_" + TradeUtil.assembleUTIDString(trade) + "_" + loopCounter;
        }
        trade.UTID = utid;
        return trade;
    }

    private static String assembleUTIDString(MyTrade trade) {
        Object offer = "";
        Object request = "";
        Object additionalRequest = "";
        offer = trade.multiOffer != null ? "multioffer_" + trade.multiOffer[0].itemKey.toString().split(":")[1] : trade.offer.itemKey.toString().split(":")[1];
        request = trade.multiRequest != null ? "multirequest_" + trade.multiRequest[0].itemKey.toString().split(":")[1] : trade.request.itemKey.toString().split(":")[1];
        if (trade.additionalMultiRequest != null) {
            additionalRequest = "_and_additionalmultirequest_" + trade.additionalMultiRequest[0].itemKey.toString().split(":")[1];
        } else if (trade.additionalRequest != null) {
            additionalRequest = "_and_" + trade.additionalRequest.itemKey.toString().split(":")[1];
        }
        return (String)offer + "_for_" + (String)request + (String)additionalRequest;
    }

    public static void addOffersFromItemListings(AbstractVillager villager, VillagerTrades.ItemListing[] itemListings, int i) {
        MerchantOffers merchantOffers = villager.m_6616_();
        HashSet set = Sets.newHashSet();
        if (itemListings.length > i) {
            while (set.size() < i) {
                set.add(villager.m_217043_().m_188503_(itemListings.length));
            }
        } else {
            for (int j = 0; j < itemListings.length; ++j) {
                set.add(j);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ItemListing itemListing = itemListings[integer];
            MerchantOffer merchantOffer = itemListing.m_213663_((Entity)villager, villager.m_217043_());
            if (merchantOffer == null) continue;
            merchantOffers.add((Object)merchantOffer);
        }
    }
}

