/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslator;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.evaluate.translation.translator.OperatorProxyExecutable;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.PolyglotException;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class ValueTranslatorOperator
implements IValueTranslator<ValueTypeOperator.ValueOperator> {
    @Override
    public IValueType<?> getValueType() {
        return ValueTypes.OPERATOR;
    }

    @Override
    public boolean canHandleGraalValue(Value value) {
        return value.canExecute();
    }

    @Override
    public boolean canTranslateNbt() {
        return false;
    }

    @Override
    public Value translateToGraal(Context context, ValueTypeOperator.ValueOperator value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        return context.asValue(new OperatorProxyExecutable(context, value, exceptionFactory));
    }

    @Override
    public ValueTypeOperator.ValueOperator translateFromGraal(Context context, Value value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        if (value.isProxyObject()) {
            try {
                OperatorProxyExecutable cast = (OperatorProxyExecutable)value.asProxyObject();
                return cast.getValue();
            }
            catch (ClassCastException cast) {
                // empty catch block
            }
        }
        int argCount = value.getMember("length").asInt();
        IValueType[] inputValueTypes = new IValueType[argCount];
        for (int i2 = 0; i2 < argCount; ++i2) {
            inputValueTypes[i2] = ValueTypes.CATEGORY_ANY;
        }
        return ValueTypeOperator.ValueOperator.of((IOperator)new GraalOperator(inputValueTypes, args -> {
            Value returnValue;
            IVariable[] variables = args.getVariables();
            Value[] values = new Value[variables.length];
            context.resetLimits();
            for (int i2 = 0; i2 < variables.length; ++i2) {
                try {
                    values[i2] = ValueTranslators.REGISTRY.translateToGraal(context, variables[i2].getValue(), exceptionFactory);
                    continue;
                }
                catch (PolyglotException e2) {
                    throw exceptionFactory.createError(e2.getMessage());
                }
            }
            try {
                returnValue = value.execute(values);
            }
            catch (PolyglotException e3) {
                throw exceptionFactory.createError(e3.getMessage());
            }
            return ValueTranslators.REGISTRY.translateFromGraal(context, returnValue, exceptionFactory);
        }));
    }

    @Override
    public Tag translateToNbt(Context context, ValueTypeOperator.ValueOperator value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        throw exceptionFactory.createError(Component.m_237110_((String)"valuetype.integratedscripting.error.translation.unsupported_translateToNbt", (Object[])new Object[]{Component.m_237115_((String)value.getType().getTranslationKey()), value.getType().toCompactString((IValue)value)}));
    }

    static {
        Operators.REGISTRY.registerSerializer((IOperatorSerializer)new GraalOperator.Serializer());
    }

    public static class GraalOperator
    extends OperatorBase {
        protected GraalOperator(IValueType[] inputTypes, OperatorBase.IFunction function) {
            super("graal", "graal", "graal", null, false, inputTypes, (IValueType)ValueTypes.CATEGORY_ANY, function, null);
        }

        protected String getUnlocalizedType() {
            return "integratedscript";
        }

        protected String getModId() {
            return "integratedscripting";
        }

        public static class Serializer
        implements IOperatorSerializer<GraalOperator> {
            public boolean canHandle(IOperator operator) {
                return operator instanceof GraalOperator;
            }

            public ResourceLocation getUniqueName() {
                return new ResourceLocation("integratedscripting", "graal");
            }

            public Tag serialize(GraalOperator operator) {
                ListTag list = new ListTag();
                for (int i2 = 0; i2 < operator.getInputTypes().length; ++i2) {
                    list.add((Object)StringTag.m_129297_((String)operator.getInputTypes()[i2].getUniqueName().toString()));
                }
                return list;
            }

            public GraalOperator deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) throws EvaluationException {
                ListTag listTag = (ListTag)value;
                IValueType[] inputTypes = new IValueType[listTag.size()];
                for (int i2 = 0; i2 < listTag.size(); ++i2) {
                    inputTypes[i2] = ValueTypes.REGISTRY.getValueType(new ResourceLocation(listTag.m_128778_(i2)));
                }
                return new GraalOperator(inputTypes, variables -> {
                    throw new EvaluationException(Component.m_237115_((String)"operator.integratedscripting.error.no_graal_serialization"));
                });
            }
        }
    }
}

