/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslator;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.evaluate.translation.translator.NbtCompoundTagProxyObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class ValueTranslatorNbt
implements IValueTranslator<ValueTypeNbt.ValueNbt> {
    @Override
    public IValueType<?> getValueType() {
        return ValueTypes.NBT;
    }

    @Override
    public boolean canHandleGraalValue(Value value) {
        return value.hasMembers();
    }

    @Override
    public boolean canTranslateNbt() {
        return true;
    }

    @Override
    public Value translateToGraal(Context context, ValueTypeNbt.ValueNbt value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        Tag tag = value.getRawValue().orElse(null);
        if (tag == null) {
            return context.asValue(null);
        }
        return this.translateTag(context, tag, exceptionFactory);
    }

    public Value translateTag(Context context, Tag tag, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        switch (tag.m_7060_()) {
            case 0: {
                return context.eval("js", "exports = { 'nbt_end': true }");
            }
            case 1: {
                return context.asValue(((ByteTag)tag).m_7063_());
            }
            case 2: {
                return context.asValue(((ShortTag)tag).m_7053_());
            }
            case 3: {
                return context.asValue(((IntTag)tag).m_7047_());
            }
            case 4: {
                return context.asValue(((LongTag)tag).m_7046_());
            }
            case 5: {
                return context.asValue(Float.valueOf(((FloatTag)tag).m_7057_()));
            }
            case 6: {
                return context.asValue(((DoubleTag)tag).m_7061_());
            }
            case 7: {
                return context.asValue(((ByteArrayTag)tag).m_128227_());
            }
            case 8: {
                return context.asValue(tag.m_7916_());
            }
            case 9: {
                ArrayList<Value> list = new ArrayList<Value>();
                ListTag listTag = (ListTag)tag;
                for (Tag innerValue : listTag) {
                    list.add(this.translateTag(context, innerValue, exceptionFactory));
                }
                return context.asValue(list);
            }
            case 10: {
                return this.translateCompoundTag(context, (CompoundTag)tag, exceptionFactory, null, null);
            }
            case 11: {
                return context.asValue(((IntArrayTag)tag).m_128648_());
            }
            case 12: {
                return context.asValue(((LongArrayTag)tag).m_128851_());
            }
        }
        throw exceptionFactory.createError(Component.m_237110_((String)"valuetype.integratedscripting.error.translation.nbt_unknown", (Object[])new Object[]{tag.m_6458_().m_5986_()}));
    }

    public Value translateCompoundTag(Context context, CompoundTag tag, IEvaluationExceptionFactory exceptionFactory, @Nullable Map<String, IOperator> methods, @Nullable IValue value) {
        return context.asValue(new NbtCompoundTagProxyObject(context, exceptionFactory, tag, methods, value));
    }

    @Override
    public ValueTypeNbt.ValueNbt translateFromGraal(Context context, Value value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        if (value.isProxyObject()) {
            try {
                NbtCompoundTagProxyObject proxy = (NbtCompoundTagProxyObject)value.asProxyObject();
                return ValueTypeNbt.ValueNbt.of((Tag)proxy.getTag());
            }
            catch (ClassCastException proxy) {
                // empty catch block
            }
        }
        if (value.getMemberKeys().equals(Sets.newHashSet((Object[])new String[]{"nbt_end"}))) {
            return ValueTypeNbt.ValueNbt.of((Tag)EndTag.f_128534_);
        }
        CompoundTag tag = new CompoundTag();
        for (String memberKey : value.getMemberKeys()) {
            Value memberValue = value.getMember(memberKey);
            if (memberValue.isNull()) continue;
            Object subValue = ValueTranslators.REGISTRY.translateFromGraal(context, memberValue, exceptionFactory);
            tag.m_128365_(memberKey, ValueTranslators.REGISTRY.translateToNbt(context, subValue, exceptionFactory));
        }
        return ValueTypeNbt.ValueNbt.of((Tag)tag);
    }

    @Override
    public Tag translateToNbt(Context context, ValueTypeNbt.ValueNbt value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        return (Tag)value.getRawValue().orElseThrow();
    }
}

