/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslator;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class ValueTranslatorBoolean
implements IValueTranslator<ValueTypeBoolean.ValueBoolean> {
    private boolean valuesInitialized = false;
    private Value valueTrue;
    private Value valueFalse;

    @Override
    public IValueType<?> getValueType() {
        return ValueTypes.BOOLEAN;
    }

    @Override
    public boolean canHandleGraalValue(Value value) {
        return value.isBoolean();
    }

    @Override
    public boolean canTranslateNbt() {
        return true;
    }

    @Override
    public Value translateToGraal(Context context, ValueTypeBoolean.ValueBoolean value, IEvaluationExceptionFactory exceptionFactory) {
        if (!this.valuesInitialized) {
            this.valuesInitialized = true;
            this.valueTrue = context.asValue(true);
            this.valueFalse = context.asValue(false);
        }
        return value.getRawValue() ? this.valueTrue : this.valueFalse;
    }

    @Override
    public ValueTypeBoolean.ValueBoolean translateFromGraal(Context context, Value value, IEvaluationExceptionFactory exceptionFactory) {
        return ValueTypeBoolean.ValueBoolean.of((boolean)value.asBoolean());
    }

    @Override
    public Tag translateToNbt(Context context, ValueTypeBoolean.ValueBoolean value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        return ByteTag.m_128273_((boolean)value.getRawValue());
    }
}

