/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.network;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integratedscripting.api.language.ILanguageHandler;
import org.cyclops.integratedscripting.api.network.IScript;
import org.cyclops.integratedscripting.api.network.IScriptFactory;
import org.cyclops.integratedscripting.api.network.IScriptingNetwork;
import org.cyclops.integratedscripting.core.evaluate.ScriptVariable;
import org.cyclops.integratedscripting.core.language.LanguageHandlers;
import org.jetbrains.annotations.Nullable;

public class ScriptingNetwork
implements IScriptingNetwork {
    private final Set<Integer> disks = Sets.newHashSet();
    private final Map<Pair<Integer, Path>, IScript> scriptCache = Maps.newHashMap();
    private final Map<Triple<Integer, Path, String>, ScriptVariable> variableCache = Maps.newHashMap();

    @Override
    public void addDisk(int disk) {
        this.disks.add(disk);
    }

    @Override
    public void removeDisk(int disk) {
        this.disks.remove(disk);
    }

    @Override
    public Set<Integer> getDisks() {
        return Collections.unmodifiableSet(this.disks);
    }

    @Override
    @Nullable
    public IScript getScript(int disk, Path path) throws EvaluationException {
        Pair cacheKey = Pair.of((Object)disk, (Object)path);
        IScript script = this.scriptCache.get(cacheKey);
        if (script == null) {
            ILanguageHandler languageHandler = LanguageHandlers.REGISTRY.getProvider(path);
            if (languageHandler == null) {
                throw new EvaluationException(Component.m_237110_((String)"script.integratedscripting.error.unsupported_language", (Object[])new Object[]{path.toString()}));
            }
            IScriptFactory scriptFactory = languageHandler.getScriptFactory();
            script = scriptFactory.getScript(disk, path);
            if (script != null) {
                script.addInvalidationListener(() -> this.scriptCache.remove(cacheKey));
                this.scriptCache.put((Pair<Integer, Path>)cacheKey, script);
            }
        }
        return script;
    }

    @Override
    public <V extends IValue> IVariable<V> getVariable(int disk, Path path, String member) {
        Triple cacheKey = Triple.of((Object)disk, (Object)path, (Object)member);
        ScriptVariable variable = this.variableCache.get(cacheKey);
        if (variable == null) {
            variable = new ScriptVariable(disk, path, member, this);
            variable.addInvalidationListener(() -> this.variableCache.remove(cacheKey));
            this.variableCache.put((Triple<Integer, Path, String>)cacheKey, variable);
        }
        return variable;
    }
}

