/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integratedscripting.GeneralConfig;
import org.cyclops.integratedscripting.api.network.IScriptingData;
import org.cyclops.integratedscripting.core.network.LazyOutputStream;

public class ScriptingData
implements IScriptingData {
    public static final LevelResource LEVEL_RESOURCE = new LevelResource("integratedscripting");
    private final Int2ObjectMap<Map<Path, String>> diskScripts = new Int2ObjectAVLTreeMap();
    private final Path rootPath;
    private final Set<Pair<Integer, Path>> dirtyPaths = Sets.newHashSet();
    private final Int2ObjectMap<List<IScriptingData.IDiskScriptsChangeListener>> scriptChangeListeners = new Int2ObjectAVLTreeMap();
    private final Map<Path, WatchKey> pathWatchers = Maps.newHashMap();
    private final Map<WatchKey, Path> pathWatchersReverse = Maps.newHashMap();
    private boolean initialized = false;
    private WatchService watchService;

    public ScriptingData(Path rootDirectory) {
        this.rootPath = rootDirectory;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public void tick() {
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        if (!this.dirtyPaths.isEmpty()) {
            for (Pair<Integer, Path> entry : this.dirtyPaths) {
                this.flushScript((Integer)entry.getLeft(), (Path)entry.getRight());
            }
            this.dirtyPaths.clear();
        }
    }

    public void close() {
        try {
            if (this.watchService != null) {
                this.watchService.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    protected Path getDisksPath() {
        return this.rootPath.resolve("scripting-disks");
    }

    protected Path getDiskPath(int id) {
        return this.getDisksPath().resolve(String.valueOf(id));
    }

    public void initialize() {
        Path disksPath = this.getDisksPath();
        disksPath.toFile().mkdirs();
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        ArrayList diskIds = Lists.newArrayList();
        try {
            Files.walk(disksPath, 1, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> {
                String name = path.getFileName().toString();
                try {
                    diskIds.add(Integer.parseInt(name));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        for (Integer diskId : diskIds) {
            this.initializeDiskScripts(diskId);
        }
        Thread watchThread = new Thread(this::watchFiles);
        watchThread.start();
    }

    protected void initializeDiskScripts(int diskId) {
        HashMap scripts = Maps.newHashMap();
        Path diskDir = this.getDiskPath(diskId);
        Iterator filesIt = FileUtils.iterateFilesAndDirs((File)diskDir.toFile(), (IOFileFilter)FileFilterUtils.trueFileFilter(), (IOFileFilter)FileFilterUtils.trueFileFilter());
        while (filesIt.hasNext()) {
            File file = (File)filesIt.next();
            if (!file.isFile()) continue;
            Path filePathRelative = diskDir.relativize(file.toPath());
            try {
                scripts.put(filePathRelative, FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        this.setScripts(diskId, scripts, IScriptingData.ChangeLocation.DISK);
    }

    protected void watchFiles() {
        while (true) {
            try {
                block6: while (true) {
                    boolean poll = true;
                    while (true) {
                        if (!poll) continue block6;
                        WatchKey key = this.watchService.take();
                        for (WatchEvent<?> event : key.pollEvents()) {
                            Path disksPath;
                            Path changedPathAbsolute;
                            Path changedPathRelative = (Path)event.context();
                            Path pathDirectory = this.pathWatchersReverse.get(key);
                            if (pathDirectory == null || !(changedPathAbsolute = pathDirectory.resolve(changedPathRelative)).startsWith(disksPath = this.getDisksPath())) continue;
                            try {
                                int diskId = Integer.parseInt(changedPathAbsolute.getName(disksPath.getNameCount()).toString());
                                this.initializeDiskScripts(diskId);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        poll = key.reset();
                        Thread.yield();
                    }
                    break;
                }
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                continue;
            }
            catch (ClosedWatchServiceException e3) {
                return;
            }
            break;
        }
    }

    @Override
    public Collection<Integer> getDisks() {
        return this.diskScripts.keySet();
    }

    @Override
    public Map<Path, String> getScripts(int disk) {
        return (Map)this.diskScripts.getOrDefault(disk, (Object)Maps.newHashMap());
    }

    @Override
    public void setScripts(int disk, Map<Path, String> scripts, IScriptingData.ChangeLocation changeLocation) {
        List listeners;
        Map oldScripts = (Map)this.diskScripts.put(disk, scripts);
        LinkedList modifiedScripts = Lists.newLinkedList();
        HashSet keys = Sets.newHashSet();
        keys.addAll(scripts.keySet());
        if (oldScripts != null) {
            keys.addAll(oldScripts.keySet());
        }
        for (Path path : keys) {
            if (oldScripts != null && Objects.equals(oldScripts.get(path), scripts.get(path))) continue;
            modifiedScripts.add(path);
        }
        if (changeLocation == IScriptingData.ChangeLocation.MEMORY) {
            for (Path path : modifiedScripts) {
                this.markDirty(disk, path);
            }
        }
        if (changeLocation == IScriptingData.ChangeLocation.DISK) {
            if (GeneralConfig.maxLogLines != -1) {
                for (Path modifiedScript : modifiedScripts) {
                    String data;
                    String[] lines;
                    String modifiedScriptStr = modifiedScript.toString();
                    if (!modifiedScriptStr.endsWith(".stdout") && !modifiedScriptStr.endsWith(".stderr") || (lines = (data = scripts.get(modifiedScript)).split("\n")).length <= GeneralConfig.maxLogLines + 100) continue;
                    String dataNew = Arrays.stream(lines).skip(lines.length - GeneralConfig.maxLogLines).collect(Collectors.joining("\n")) + "\n";
                    scripts.put(modifiedScript, dataNew);
                    this.flushScript(disk, modifiedScript);
                }
            }
            if (oldScripts != null) {
                for (Path path : oldScripts.keySet()) {
                    this.unregisterPathWatcher(disk, path.getParent());
                }
            }
            for (Path path : scripts.keySet()) {
                this.registerPathWatcher(disk, path.getParent());
            }
        }
        if ((listeners = (List)this.scriptChangeListeners.get(disk)) != null) {
            for (IScriptingData.IDiskScriptsChangeListener listener : Lists.newArrayList(listeners.listIterator())) {
                for (Path scriptPathRelative : modifiedScripts) {
                    listener.onChange(scriptPathRelative);
                }
            }
        }
    }

    @Override
    public void setScript(int disk, Path scriptPathRelative, @Nullable String script, IScriptingData.ChangeLocation changeLocation) {
        List listeners;
        Map scripts = (Map)this.diskScripts.get(disk);
        if (scripts == null) {
            scripts = Maps.newHashMap();
            this.diskScripts.put(disk, (Object)scripts);
        }
        if (script == null) {
            scripts.remove(scriptPathRelative);
        } else {
            scripts.put(scriptPathRelative, script);
        }
        if (changeLocation == IScriptingData.ChangeLocation.MEMORY) {
            this.markDirty(disk, scriptPathRelative);
        }
        if (changeLocation == IScriptingData.ChangeLocation.DISK) {
            this.registerPathWatcher(disk, scriptPathRelative.getParent());
        }
        if ((listeners = (List)this.scriptChangeListeners.get(disk)) != null) {
            for (IScriptingData.IDiskScriptsChangeListener listener : listeners) {
                listener.onChange(scriptPathRelative);
            }
        }
    }

    protected void registerPathWatcher(int diskId, @Nullable Path pathRelative) {
        Path pathAbsolute;
        Path diskPath = this.getDiskPath(diskId);
        Path path = pathAbsolute = pathRelative == null ? diskPath : diskPath.resolve(pathRelative);
        if (!this.pathWatchers.containsKey(pathAbsolute)) {
            try {
                WatchKey watchKey = pathAbsolute.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                this.pathWatchers.put(pathAbsolute, watchKey);
                this.pathWatchersReverse.put(watchKey, pathAbsolute);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    protected void unregisterPathWatcher(int diskId, @Nullable Path pathRelative) {
        Path diskPath = this.getDiskPath(diskId);
        Path pathAbsolute = pathRelative == null ? diskPath : diskPath.resolve(pathRelative);
        WatchKey watchKey = this.pathWatchers.get(pathAbsolute);
        if (watchKey != null) {
            this.pathWatchers.remove(pathAbsolute);
            this.pathWatchersReverse.remove(watchKey);
            watchKey.cancel();
        }
    }

    @Override
    public void markDirty(int disk, Path scriptPathRelative) {
        this.dirtyPaths.add((Pair<Integer, Path>)Pair.of((Object)disk, (Object)scriptPathRelative));
    }

    @Override
    public void addListener(int disk, IScriptingData.IDiskScriptsChangeListener listener) {
        List listeners = (List)this.scriptChangeListeners.get(disk);
        if (listeners == null) {
            listeners = Lists.newArrayList();
            this.scriptChangeListeners.put(disk, (Object)listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void removeListener(int disk, IScriptingData.IDiskScriptsChangeListener listener) {
        List listeners = (List)this.scriptChangeListeners.get(disk);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.scriptChangeListeners.remove(disk);
            }
        }
    }

    @Override
    public Pair<OutputStream, OutputStream> getOutputStreams(int disk, Path scriptPathRelative) {
        Path scriptPathAbsolute = this.getDiskPath(disk).resolve(scriptPathRelative);
        return Pair.of((Object)new LazyOutputStream(() -> new FileOutputStream(String.valueOf(scriptPathAbsolute) + ".stdout", true)), (Object)new LazyOutputStream(() -> new FileOutputStream(String.valueOf(scriptPathAbsolute) + ".stderr", true)));
    }

    protected void flushScript(int disk, Path scriptPathRelative) {
        Map<Path, String> scripts = this.getScripts(disk);
        String script = scripts.get(scriptPathRelative);
        Path scriptPathAbsolute = this.getDiskPath(disk).resolve(scriptPathRelative);
        try {
            if (script == null) {
                FileUtils.delete((File)scriptPathAbsolute.toFile());
            } else {
                scriptPathAbsolute.getParent().toFile().mkdirs();
                FileUtils.write((File)scriptPathAbsolute.toFile(), (CharSequence)script, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

