/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.evaluate.ScriptHelpers;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Engine;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Source;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class CommandTestScript
implements Command<CommandSourceStack> {
    private static Engine ENGINE = null;

    public int run(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        if (ENGINE == null) {
            ENGINE = Engine.newBuilder().option("engine.WarnInterpreterOnly", "false").build();
        }
        try {
            Source source = Source.newBuilder("js", "function testFunction(a, b, c, d, e, f) {\n    console.log('Args: ' + JSON.stringify(a) + JSON.stringify(b) + JSON.stringify(c) + JSON.stringify(d));\n    console.log(typeof d);\n    console.log(JSON.stringify(e));\n    console.log(Object.keys(idContext.ops));\n    console.log(idContext.ops.itemstackStackable(e));\n    console.log(f.block().isPlantable());\n    console.log(f.block().stepSound());\n    return 10;\n}", "src.js").build();
            IEvaluationExceptionFactory EF = ScriptHelpers.getDummyEvaluationExceptionFactory();
            try (Context context = ScriptHelpers.createPopulatedContext(null);){
                context.eval(source);
                Value primesMain = context.getBindings("js").getMember("testFunction");
                Value ret = primesMain.execute(ValueTranslators.REGISTRY.translateToGraal(context, ValueTypeInteger.ValueInteger.of((int)10), EF), ValueTranslators.REGISTRY.translateToGraal(context, ValueTypeBoolean.ValueBoolean.of((boolean)true), EF), ValueTranslators.REGISTRY.translateToGraal(context, ValueTypeList.ValueList.ofAll((IValue[])new ValueBase[]{ValueTypeInteger.ValueInteger.of((int)10), ValueTypeBoolean.ValueBoolean.of((boolean)true)}), EF), ValueTranslators.REGISTRY.translateToGraal(context, ValueTypeNbt.ValueNbt.of((Tag)new ByteArrayTag(new byte[]{1, 2, 3})), EF), ValueTranslators.REGISTRY.translateToGraal(context, ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.f_41905_)), EF), ValueTranslators.REGISTRY.translateToGraal(context, ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.f_41827_)), EF));
                System.out.println(ValueTranslators.REGISTRY.translateFromGraal(context, ret, EF).toString());
            }
        }
        catch (IOException | RuntimeException | EvaluationException e2) {
            e2.printStackTrace();
        }
        return 0;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"testscript").requires(commandSource -> commandSource.m_6761_(2))).executes((Command)new CommandTestScript());
    }
}

