/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.client.gui.container;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.core.client.gui.container.DisplayErrorsComponent;
import org.cyclops.integratedscripting.GeneralConfig;
import org.cyclops.integratedscripting.IntegratedScripting;
import org.cyclops.integratedscripting.api.language.ILanguageHandler;
import org.cyclops.integratedscripting.client.gui.component.input.WidgetDialog;
import org.cyclops.integratedscripting.client.gui.component.input.WidgetTextArea;
import org.cyclops.integratedscripting.client.gui.image.ScriptImages;
import org.cyclops.integratedscripting.core.language.LanguageHandlers;
import org.cyclops.integratedscripting.inventory.container.ContainerTerminalScripting;
import org.cyclops.integratedscripting.network.packet.TerminalScriptingDeleteScriptPacket;
import org.cyclops.integratedscripting.network.packet.TerminalScriptingModifiedScriptPacket;

public class ContainerScreenTerminalScripting
extends ContainerScreenExtended<ContainerTerminalScripting> {
    public static int PATHS_X = 19;
    public static int PATHS_Y = 18;
    public static int PATHS_WIDTH = 56;
    public static int PATHS_HEIGHT = 214;
    public static int PATHS_ROW_HEIGHT = 8;
    public static int PATHS_MAX_ROWS = PATHS_HEIGHT / PATHS_ROW_HEIGHT;
    public static int SCRIPT_X = 80;
    public static int SCRIPT_X_INNER = 94;
    public static int SCRIPT_Y = 18;
    public static int SCRIPT_WIDTH = 168;
    public static int SCRIPT_HEIGHT = 115;
    private final Player player;
    private WidgetArrowedListField<Integer> fieldDisk;
    private WidgetScrollBar scrollBar;
    private int firstRow;
    private WidgetTextArea textArea;
    private ButtonText buttonCreateFile;
    private WidgetDialog pendingScriptRemovalDialog;
    private int lastClientSyncTick;
    private final DisplayErrorsComponent displayErrors = new DisplayErrorsComponent();
    private final Map<Path, Integer> lastScriptCursorPos = Maps.newHashMap();
    private final Map<Path, Integer> lastScriptSelectionPos = Maps.newHashMap();
    private final Int2ObjectMap<Path> lastDiskScript = new Int2ObjectAVLTreeMap();

    public ContainerScreenTerminalScripting(ContainerTerminalScripting container, Inventory inventory, Component title) {
        super((ContainerExtended)container, inventory, title);
        this.player = inventory.f_35978_;
        this.f_97727_ = 240;
        this.f_97728_ = 88;
        this.f_97729_ = 6;
        this.f_97730_ = 88;
        this.f_97731_ = this.f_97727_ - 94;
        this.firstRow = 0;
        this.lastClientSyncTick = 0;
    }

    public void m_7856_() {
        super.m_7856_();
        this.fieldDisk = new WidgetArrowedListField(Minecraft.m_91087_().f_91062_, this.f_97735_ + 30, this.f_97736_ + 4, 42, 15, true, (Component)Component.m_237115_((String)"gui.integratedscripting.disk"), true, (List)((ContainerTerminalScripting)this.m_6262_()).getAvailableDisks());
        this.fieldDisk.m_94199_(5);
        this.fieldDisk.m_94194_(true);
        this.fieldDisk.m_94202_(0xFFFFFF);
        this.fieldDisk.m_94190_(true);
        this.fieldDisk.m_94186_(true);
        this.fieldDisk.m_94144_(String.valueOf(((ContainerTerminalScripting)this.m_6262_()).getActiveDisk()));
        this.scrollBar = new WidgetScrollBar(this.f_97735_ + 5, this.f_97736_ + 18, 162, (Component)Component.m_237115_((String)"gui.cyclopscore.scrollbar"), this::setFirstRow, PATHS_MAX_ROWS){

            public int getTotalRows() {
                Map<Path, String> scripts = ContainerScreenTerminalScripting.this.getActiveScripts();
                return scripts == null ? 0 : scripts.keySet().size();
            }
        };
        this.textArea = new WidgetTextArea(Minecraft.m_91087_().f_91062_, this.f_97735_ + SCRIPT_X + 1, this.f_97736_ + SCRIPT_Y + 1, SCRIPT_WIDTH, SCRIPT_HEIGHT, (Component)Component.m_237115_((String)"gui.integratedscripting.script"), true, true);
        this.textArea.setListener(this::onActiveScriptModified);
        this.textArea.setListenerSelection(this::onSelectionModified);
        this.textArea.setListenerCursor(this::onSelectionModified);
        this.textArea.setMarkupProvider((style, line) -> {
            Path path = ((ContainerTerminalScripting)this.m_6262_()).getActiveScriptPath();
            ILanguageHandler languageHandler = path != null ? LanguageHandlers.REGISTRY.getProvider(path) : null;
            return languageHandler != null ? languageHandler.markupLine(line) : Stream.of(Pair.of((Object)style, (Object)line)).collect(Collectors.toList());
        });
        this.m_142416_(this.textArea);
        this.buttonCreateFile = new ButtonText(this.f_97735_ + 19, this.f_97736_ + 222, 56, 10, (Component)Component.m_237115_((String)"gui.integratedscripting.create_file"), (Component)Component.m_237113_((String)"+"), button -> ((ContainerTerminalScripting)this.m_6262_()).createNewFile(), true);
        this.m_142416_((GuiEventListener)this.buttonCreateFile);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.textArea.m_94120_();
        if (this.lastClientSyncTick == 0) {
            this.syncDirtyScripts();
        }
        this.lastClientSyncTick = (this.lastClientSyncTick + 1) % GeneralConfig.terminalScriptingClientSyncTickInterval;
    }

    protected void syncDirtyScripts() {
        for (Pair<Integer, Path> entry : ((ContainerTerminalScripting)this.m_6262_()).getClientScriptsDirty()) {
            String script;
            Map diskScripts = (Map)((ContainerTerminalScripting)this.m_6262_()).getLastScripts().get(entry.getLeft());
            if (diskScripts == null || (script = (String)diskScripts.get(entry.getRight())) == null) continue;
            IntegratedScripting._instance.getPacketHandler().sendToServer((PacketBase)new TerminalScriptingModifiedScriptPacket((Integer)entry.getLeft(), (Path)entry.getRight(), script));
        }
        ((ContainerTerminalScripting)this.m_6262_()).getClientScriptsDirty().clear();
    }

    public void m_7379_() {
        this.syncDirtyScripts();
        super.m_7379_();
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedscripting", "textures/gui/scripting_terminal.png");
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 240;
    }

    protected int getErrorX() {
        return 212;
    }

    protected int getErrorY() {
        return 139;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        this.fieldDisk.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.scrollBar.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (!((ContainerTerminalScripting)this.m_6262_()).getAvailableDisks().isEmpty()) {
            this.renderScriptPaths(guiGraphics, mouseX, mouseY, partialTicks);
        } else {
            RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)0.3f);
            guiGraphics.m_280509_(this.f_97735_ + PATHS_X, this.f_97736_ + PATHS_Y, this.f_97735_ + PATHS_X + PATHS_WIDTH, this.f_97736_ + PATHS_Y + PATHS_HEIGHT, Helpers.RGBAToInt((int)50, (int)50, (int)50, (int)100));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (((ContainerTerminalScripting)this.m_6262_()).getActiveScript() == null) {
            RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)0.3f);
            guiGraphics.m_280509_(this.f_97735_ + SCRIPT_X_INNER, this.f_97736_ + SCRIPT_Y, this.f_97735_ + SCRIPT_X_INNER + SCRIPT_WIDTH, this.f_97736_ + SCRIPT_Y + SCRIPT_HEIGHT, Helpers.RGBAToInt((int)50, (int)50, (int)50, (int)100));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.displayErrors.drawBackground(guiGraphics, ((ContainerTerminalScripting)this.m_6262_()).getReadErrors(), this.getErrorX(), this.getErrorY(), this.getErrorX(), this.getErrorY(), (ContainerScreenExtended)this, this.f_97735_, this.f_97736_, ((ContainerTerminalScripting)this.m_6262_()).canWriteScriptToVariable());
    }

    @Nullable
    protected Map<Path, String> getActiveScripts() {
        return (Map)((ContainerTerminalScripting)this.container).getLastScripts().get(((ContainerTerminalScripting)this.container).getActiveDisk());
    }

    protected List<Path> getVisibleScriptPaths() {
        List paths;
        Map<Path, String> scripts = this.getActiveScripts();
        if (scripts != null && !(paths = scripts.keySet().stream().sorted().collect(Collectors.toList())).isEmpty()) {
            return paths.subList(Math.max(0, this.firstRow), Math.max(0, this.firstRow) + Math.min(paths.size(), this.scrollBar.getVisibleRows()));
        }
        return Collections.emptyList();
    }

    protected void renderScriptPaths(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        List<Path> paths = this.getVisibleScriptPaths();
        int i2 = 0;
        for (Path path : paths) {
            boolean hovering = this.m_6774_(PATHS_X, PATHS_Y + i2 * PATHS_ROW_HEIGHT, PATHS_WIDTH, PATHS_ROW_HEIGHT, mouseX, mouseY);
            boolean active = path.equals(((ContainerTerminalScripting)this.m_6262_()).getActiveScriptPath());
            if (active) {
                guiGraphics.m_280509_(this.f_97735_ + PATHS_X, this.f_97736_ + PATHS_Y + i2 * PATHS_ROW_HEIGHT, this.f_97735_ + PATHS_X + PATHS_WIDTH, this.f_97736_ + PATHS_Y + (i2 + 1) * PATHS_ROW_HEIGHT, Helpers.RGBAToInt((int)110, (int)130, (int)240, (int)255));
            }
            ILanguageHandler languageHandler = LanguageHandlers.REGISTRY.getProvider(path);
            Image icon = ScriptImages.FILE_OTHER;
            if (languageHandler != null) {
                icon = languageHandler.getIcon();
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(this.f_97735_ + PATHS_X + 1), (float)(this.f_97736_ + PATHS_Y + i2 * PATHS_ROW_HEIGHT + 1), 0.0f);
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            icon.draw(guiGraphics, 0, 0);
            guiGraphics.m_280168_().m_85849_();
            RenderHelpers.drawScaledString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)StringUtil.m_144998_((String)path.toString(), (int)20, (boolean)true), (int)(this.f_97735_ + PATHS_X + 1 + 7), (int)(this.f_97736_ + PATHS_Y + i2 * PATHS_ROW_HEIGHT + 1 + 1), (float)0.5f, (int)(hovering && !active ? Helpers.RGBToInt((int)50, (int)50, (int)250) : Helpers.RGBToInt((int)0, (int)0, (int)0)), (boolean)false, (Font.DisplayMode)Font.DisplayMode.NORMAL);
            if (hovering) {
                guiGraphics.m_280168_().m_85836_();
                float scale = 0.4f;
                int size = (int)((float)Images.ERROR.getWidth() * scale);
                guiGraphics.m_280168_().m_252880_((float)(this.f_97735_ + PATHS_X + PATHS_WIDTH - size - 1), (float)(this.f_97736_ + PATHS_Y + i2 * PATHS_ROW_HEIGHT + 1), 0.0f);
                guiGraphics.m_280168_().m_85841_(scale, scale, 4.0f);
                if (this.m_6774_(PATHS_X + PATHS_WIDTH - size - 1, PATHS_Y + i2 * PATHS_ROW_HEIGHT, PATHS_X + PATHS_WIDTH - size + size - 1, PATHS_Y + i2 * PATHS_ROW_HEIGHT + size, mouseX, mouseY)) {
                    Images.ERROR.draw(guiGraphics, 0, 0);
                } else {
                    Images.ERROR.drawWithColor(guiGraphics, 0, 0, 0.7f, 0.7f, 0.7f, 1.0f);
                }
                guiGraphics.m_280168_().m_85849_();
            }
            ++i2;
        }
    }

    @Nullable
    protected Path getHoveredScriptPath(double mouseX, double mouseY) {
        List<Path> paths = this.getVisibleScriptPaths();
        int i2 = 0;
        for (Path path : paths) {
            if (this.m_6774_(PATHS_X, PATHS_Y + i2 * PATHS_ROW_HEIGHT, PATHS_WIDTH, PATHS_ROW_HEIGHT, mouseX, mouseY)) {
                return path;
            }
            ++i2;
        }
        return null;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280488_(this.f_96547_, L10NHelpers.localize((String)"gui.integratedscripting.disk", (Object[])new Object[0]) + ":", 8, 6, 0xFFFFFF);
        this.displayErrors.drawForeground(guiGraphics.m_280168_(), ((ContainerTerminalScripting)this.m_6262_()).getReadErrors(), this.getErrorX(), this.getErrorY(), mouseX, mouseY, (ContainerScreenExtended)this, this.f_97735_, this.f_97736_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.pendingScriptRemovalDialog != null) {
            return this.pendingScriptRemovalDialog.m_6375_(mouseX, mouseY, mouseButton);
        }
        Path hoveredScriptPath = this.getHoveredScriptPath(mouseX, mouseY);
        if (hoveredScriptPath != null) {
            if (mouseX >= (double)(this.f_97735_ + PATHS_X + PATHS_WIDTH - (int)((float)Images.ERROR.getWidth() * 0.4f) - 1)) {
                this.fieldDisk.m_7435_(Minecraft.m_91087_().m_91106_());
                this.pendingScriptRemovalDialog = new WidgetDialog(this.f_96547_, this.f_97735_ + this.getBaseXSize() / 2 - 108, this.f_97736_ + 50, (Screen)this, (Component)Component.m_237115_((String)"gui.integratedscripting.removal_dialog.title"), (Component)Component.m_237110_((String)"gui.integratedscripting.removal_dialog.message", (Object[])new Object[]{hoveredScriptPath.toString()}), (Component)Component.m_237115_((String)"gui.integratedscripting.removal_dialog.delete"), (Component)Component.m_237115_((String)"gui.integratedscripting.removal_dialog.keep"), b2 -> {
                    this.m_169411_(this.pendingScriptRemovalDialog);
                    this.pendingScriptRemovalDialog = null;
                    this.removeScript(hoveredScriptPath);
                }, b2 -> {
                    this.m_169411_(this.pendingScriptRemovalDialog);
                    this.pendingScriptRemovalDialog = null;
                });
                this.m_142416_(this.pendingScriptRemovalDialog);
                return true;
            }
            this.saveCursorPos();
            ((ContainerTerminalScripting)this.m_6262_()).setActiveScriptPath(hoveredScriptPath);
            this.onActiveScriptSelected();
            this.restoreCursorPos();
            this.fieldDisk.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        int previousDisk = this.getActiveDisk();
        if (this.fieldDisk.m_6375_(mouseX, mouseY, mouseButton)) {
            this.saveCursorPos();
            this.saveDiskScript(previousDisk);
            ((ContainerTerminalScripting)this.m_6262_()).setActiveDisk(this.getActiveDisk());
            this.scrollBar.scrollTo(0.0f);
            this.restoreDiskScript();
            this.restoreCursorPos();
            this.playButtonClickSound();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public int getActiveDisk() {
        try {
            Integer element = (Integer)this.fieldDisk.getActiveElement();
            return element == null ? -1 : element;
        }
        catch (NumberFormatException e2) {
            return -1;
        }
    }

    private void saveCursorPos() {
        Path currentScriptPath = ((ContainerTerminalScripting)this.m_6262_()).getActiveScriptPath();
        if (currentScriptPath != null) {
            this.lastScriptCursorPos.put(currentScriptPath, this.textArea.getCursorPos());
            this.lastScriptSelectionPos.put(currentScriptPath, this.textArea.getSelectionPos());
        }
    }

    private void restoreCursorPos() {
        Path currentScriptPath = ((ContainerTerminalScripting)this.m_6262_()).getActiveScriptPath();
        Integer scriptCursorPos = this.lastScriptCursorPos.get(currentScriptPath);
        if (scriptCursorPos != null) {
            this.textArea.setCursorPos(scriptCursorPos);
        } else {
            this.textArea.setCursorPos(0);
            if (this.textArea.m_93696_()) {
                this.textArea.m_93692_(false);
            }
        }
        Integer scriptSelectionPos = this.lastScriptSelectionPos.get(currentScriptPath);
        if (scriptSelectionPos != null) {
            this.textArea.setSelectionPos(scriptSelectionPos);
        } else {
            this.textArea.setSelectionPos(0);
        }
    }

    private void saveDiskScript(int disk) {
        Path currentScriptPath = ((ContainerTerminalScripting)this.m_6262_()).getActiveScriptPath();
        if (disk >= 0 && currentScriptPath != null) {
            this.lastDiskScript.put(disk, (Object)currentScriptPath);
        }
    }

    private void restoreDiskScript() {
        int disk = this.getActiveDisk();
        if (disk >= 0) {
            Path scriptPath = (Path)this.lastDiskScript.get(disk);
            ((ContainerTerminalScripting)this.m_6262_()).setActiveScriptPath(scriptPath);
            this.onActiveScriptSelected();
        }
    }

    protected void playButtonClickSound() {
        this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    private void onActiveScriptSelected() {
        String script = ((ContainerTerminalScripting)this.m_6262_()).getActiveScript();
        this.textArea.m_94144_(script == null ? "" : script);
    }

    private void onActiveScriptModified() {
        ((ContainerTerminalScripting)this.m_6262_()).setActiveScript(this.textArea.m_94155_());
    }

    private void onSelectionModified() {
        int cursorPos;
        String selected = this.textArea.getSelected();
        if (Strings.isNullOrEmpty((String)selected) && (cursorPos = this.textArea.getCursorPos()) >= 0) {
            String value = this.textArea.m_94155_();
            Matcher matcherToEnd = ContainerTerminalScripting.INVALID_MEMBER_NAME.matcher(value);
            int endPos = value.length();
            if (matcherToEnd.find(cursorPos)) {
                endPos = matcherToEnd.end() - 1;
            }
            Matcher matcherToStart = ContainerTerminalScripting.INVALID_MEMBER_NAME.matcher(new StringBuilder(value).reverse().toString());
            int startPos = 0;
            if (matcherToStart.find(value.length() - cursorPos)) {
                startPos = value.length() - matcherToStart.end() + 1;
            }
            selected = value.substring(startPos, endPos);
        }
        ((ContainerTerminalScripting)this.m_6262_()).setSelection(selected);
    }

    private void removeScript(Path path) {
        IntegratedScripting._instance.getPacketHandler().sendToServer((PacketBase)new TerminalScriptingDeleteScriptPacket(((ContainerTerminalScripting)this.m_6262_()).getActiveDisk(), path));
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.textArea.m_6050_(mouseX, mouseY, scroll)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        if (this.pendingScriptRemovalDialog != null) {
            return false;
        }
        if (this.textArea.m_7979_(mouseX, mouseY, mouseButton, offsetX, offsetY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, offsetX, offsetY);
    }

    public boolean m_7933_(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256 && this.pendingScriptRemovalDialog != null) {
            return false;
        }
        if (this.textArea.m_93696_()) {
            boolean ret = this.textArea.m_7933_(typedChar, keyCode, modifiers);
            if (typedChar != 256) {
                return ret;
            }
        }
        return super.m_7933_(typedChar, keyCode, modifiers);
    }

    public boolean m_5534_(char p_94683_, int p_94684_) {
        if (this.pendingScriptRemovalDialog != null) {
            return false;
        }
        return super.m_5534_(p_94683_, p_94684_);
    }
}

