/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.ModBaseVersionable;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.infobook.OnTheDynamicsOfIntegrationBook;
import org.cyclops.integratedscripting.GeneralConfig;
import org.cyclops.integratedscripting.RegistryEntries;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslatorRegistry;
import org.cyclops.integratedscripting.api.language.ILanguageHandlerRegistry;
import org.cyclops.integratedscripting.block.BlockMendesiteConfig;
import org.cyclops.integratedscripting.block.BlockScriptingDriveConfig;
import org.cyclops.integratedscripting.blockentity.BlockEntityScriptingDriveConfig;
import org.cyclops.integratedscripting.capability.ScriptingNetworkCapabilityConstructors;
import org.cyclops.integratedscripting.capability.network.ScriptingNetworkConfig;
import org.cyclops.integratedscripting.command.CommandTestScript;
import org.cyclops.integratedscripting.core.client.model.ScriptingVariableModelProviders;
import org.cyclops.integratedscripting.core.evaluate.ScriptVariableFacadeHandler;
import org.cyclops.integratedscripting.core.language.LanguageHandlerRegistry;
import org.cyclops.integratedscripting.core.language.LanguageHandlers;
import org.cyclops.integratedscripting.core.network.ScriptingData;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslatorRegistry;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.inventory.container.ContainerScriptingDriveConfig;
import org.cyclops.integratedscripting.inventory.container.ContainerTerminalScriptingConfig;
import org.cyclops.integratedscripting.item.ItemScriptingDiskConfig;
import org.cyclops.integratedscripting.part.PartTypes;
import org.cyclops.integratedscripting.proxy.ClientProxy;
import org.cyclops.integratedscripting.proxy.CommonProxy;

@Mod(value="integratedscripting")
public class IntegratedScripting
extends ModBaseVersionable<IntegratedScripting> {
    public static IntegratedScripting _instance;
    public ScriptingData scriptingData;

    public IntegratedScripting() {
        super("integratedscripting", instance -> {
            _instance = instance;
        });
        this.getRegistryManager().addRegistry(IValueTranslatorRegistry.class, (IRegistry)ValueTranslatorRegistry.getInstance());
        this.getRegistryManager().addRegistry(ILanguageHandlerRegistry.class, (IRegistry)LanguageHandlerRegistry.getInstance());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegistriesCreate);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::afterSetup);
        MinecraftForge.EVENT_BUS.addListener(x$0 -> this.onServerStarting((ServerStartingEvent)x$0));
        MinecraftForge.EVENT_BUS.addListener(this::onServerTick);
    }

    public void onRegistriesCreate(NewRegistryEvent event) {
        ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).registerHandler((IVariableFacadeHandler)ScriptVariableFacadeHandler.getInstance());
        if (MinecraftHelpers.isClientSide()) {
            ScriptingVariableModelProviders.load();
        }
        PartTypes.load();
    }

    protected LiteralArgumentBuilder<CommandSourceStack> constructBaseCommand() {
        LiteralArgumentBuilder root = super.constructBaseCommand();
        root.then(CommandTestScript.make());
        return root;
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        MinecraftForge.EVENT_BUS.register((Object)new ScriptingNetworkCapabilityConstructors());
        ValueTranslators.load();
        LanguageHandlers.load();
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        this.scriptingData = new ScriptingData(event.getServer().m_129843_(ScriptingData.LEVEL_RESOURCE));
        MinecraftForge.EVENT_BUS.register((Object)this.scriptingData);
    }

    protected void onServerStopping(ServerStoppingEvent event) {
        if (this.scriptingData != null) {
            this.scriptingData.close();
        }
        this.scriptingData = null;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.scriptingData != null) {
            this.scriptingData.tick();
        }
    }

    protected void afterSetup(FMLLoadCompleteEvent event) {
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBase)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.manual", "/data/integratedscripting/info/scripting_info.xml");
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBase)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.tutorials", "/data/integratedscripting/info/scripting_tutorials.xml");
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).m_257737_(() -> new ItemStack((ItemLike)RegistryEntries.ITEM_SCRIPTING_DISK));
    }

    protected void onConfigsRegister(ConfigHandler configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfig)new GeneralConfig());
        configHandler.addConfigurable((ExtendedConfig)new ScriptingNetworkConfig());
        configHandler.addConfigurable((ExtendedConfig)new ItemScriptingDiskConfig());
        configHandler.addConfigurable((ExtendedConfig)new BlockScriptingDriveConfig());
        configHandler.addConfigurable((ExtendedConfig)new BlockMendesiteConfig());
        configHandler.addConfigurable((ExtendedConfig)new BlockEntityScriptingDriveConfig());
        configHandler.addConfigurable((ExtendedConfig)new ContainerScriptingDriveConfig());
        configHandler.addConfigurable((ExtendedConfig)new ContainerTerminalScriptingConfig());
    }

    @OnlyIn(value=Dist.CLIENT)
    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    public static void clog(String message) {
        IntegratedScripting.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

