/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.polyglot.enterprise.BinaryProtocol;
import com.oracle.truffle.polyglot.enterprise.NativeContext;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import com.oracle.truffle.polyglot.enterprise.ReferenceUnavailableException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;

final class NativeObjectReferences {
    private static final Message[] MESSAGES_BY_ID = InteropLibrary.getFactory().getMessages().toArray(new Message[0]);
    private static final Message MESSAGE_READ_BUFFER = Message.resolve(InteropLibrary.class, "readBuffer");
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final BinaryMarshaller<Throwable> THROWABLE_MARSHALLER = PolyglotJNIConfig.getInstance().lookupMarshaller(Throwable.class, new Class[0]);
    private final Map<Long, TruffleObject> exportReferences = new ConcurrentHashMap<Long, TruffleObject>();
    private final AtomicLong currentReferenceId = new AtomicLong(1L);
    @CompilerDirectives.CompilationFinal
    private NativeContext context;

    private NativeObjectReferences() {
    }

    void setAPI(NativeContext nativeContext) {
        assert (this.context == null) : "Context is already set.";
        this.context = nativeContext;
    }

    public static NativeObjectReferences create() {
        return new NativeObjectReferences();
    }

    long registerHostObject(TruffleObject truffleObject) {
        long l2 = this.currentReferenceId.getAndIncrement();
        this.exportReferences.put(l2, truffleObject);
        return l2;
    }

    Object getHostObject(long l2) {
        return this.exportReferences.get(l2);
    }

    @JNIEntryPoint
    void releaseReference(long l2) {
        try {
            this.exportReferences.remove(l2);
        }
        catch (Throwable throwable) {
            throw ForeignException.forThrowable(throwable, THROWABLE_MARSHALLER);
        }
    }

    @JNIEntryPoint
    byte[] messageDispatch(long l2, int n2, byte[] byArray) {
        try {
            Object object;
            Object object2;
            Object[] objectArray;
            if (byArray != null) {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                objectArray = (Object[])BinaryProtocol.readHostTypedValue(binaryInput, this.context);
                if (n2 == MESSAGE_READ_BUFFER.getId()) {
                    int n3 = (Integer)objectArray[3];
                    objectArray[1] = new byte[Math.max(n3, 0)];
                    objectArray[2] = 0;
                }
            } else {
                objectArray = null;
            }
            boolean bl = false;
            try {
                Object[] objectArray2;
                object2 = MESSAGES_BY_ID[n2];
                TruffleObject truffleObject = this.exportReferences.get(l2);
                if (truffleObject == null) {
                    throw new ReferenceUnavailableException(ReferenceUnavailableException.Kind.HOST, l2);
                }
                ReflectionLibrary reflectionLibrary = ReflectionLibrary.getFactory().getUncached(truffleObject);
                Object object3 = reflectionLibrary.send(truffleObject, (Message)object2, objectArray2 = objectArray != null ? objectArray : EMPTY_OBJECT_ARRAY);
                if (object3 instanceof TruffleObject && InteropLibrary.getUncached().isNull(object3)) {
                    object3 = null;
                }
                object = object3;
                bl = true;
            }
            catch (Throwable throwable) {
                if (BinaryProtocol.isSupportedException(throwable)) {
                    object = throwable;
                }
                throw throwable;
            }
            if (object == null && n2 != MESSAGE_READ_BUFFER.getId()) {
                return null;
            }
            object2 = byArray != null ? BinaryOutput.create(byArray) : BinaryOutput.create();
            ((BinaryOutput)object2).writeBoolean(bl);
            if (n2 == MESSAGE_READ_BUFFER.getId() && bl) {
                object = objectArray[1];
            }
            BinaryProtocol.writeHostTypedValue((BinaryOutput)object2, object, this.context.getGuestToHostReceiver());
            return ((BinaryOutput.ByteArrayBinaryOutput)object2).getArray();
        }
        catch (Throwable throwable) {
            throw ForeignException.forThrowable(throwable, THROWABLE_MARSHALLER);
        }
    }
}

