/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSInputStreamGen;
import com.oracle.truffle.polyglot.enterprise.HSOutputStreamGen;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotObject;
import com.oracle.truffle.polyglot.enterprise.HSProcess;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNICalls;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIClassCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;

final class HSProcessGen {
    HSProcessGen() {
    }

    static HSProcess createNativeToHS(HSPolyglotObject hSPolyglotObject, JNI.JNIEnv jNIEnv) {
        return new StartPoint(hSPolyglotObject, jNIEnv);
    }

    private static final class StartPoint
    extends HSProcess {
        private static final BinaryMarshaller<ProcessHandle> processHandleMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<TimeUnit> timeUnitMarshaller;
        final JNIData jniMethods_;

        StartPoint(HSPolyglotObject hSPolyglotObject, JNI.JNIEnv jNIEnv) {
            super(hSPolyglotObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        @Override
        public void destroy() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.destroyMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public Process destroyForcibly() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.destroyForciblyMethod, jValue);
                return r2.isNonNull() ? HSProcessGen.createNativeToHS(new HSPolyglotObject(jNIEnv, (JNI.JObject)r2), jNIEnv) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public int exitValue() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                return ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.exitValueMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public InputStream getErrorStream() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getErrorStreamMethod, jValue);
                return r2.isNonNull() ? HSInputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, (JNI.JObject)r2), jNIEnv) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public InputStream getInputStream() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getInputStreamMethod, jValue);
                return r2.isNonNull() ? HSInputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, (JNI.JObject)r2), jNIEnv) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public OutputStream getOutputStream() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.getOutputStreamMethod, jValue);
                return r2.isNonNull() ? HSOutputStreamGen.createNativeToHS(new HSPolyglotObject(jNIEnv, (JNI.JObject)r2), jNIEnv) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean isAlive() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isAliveMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public long pid() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                return ForeignException.getJNICalls().callStaticLong(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.pidMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean supportsNormalTermination() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.supportsNormalTerminationMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProcessHandle toHandle() {
            ProcessHandle processHandle;
            block6: {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer = (CCharPointer)StackValue.get(256);
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                JNI.JByteArray jByteArray = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toHandleMethod, jValue);
                int n2 = JNIUtil.GetArrayLength(jNIEnv, jByteArray);
                CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc(n2);
                try {
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray, 0, n2, cCharPointer2);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer2, n2);
                    processHandle = processHandleMarshaller.read(binaryInput);
                    if (cCharPointer2 == cCharPointer) break block6;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer2 != cCharPointer) {
                            UnmanagedMemory.free(cCharPointer2);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer2);
            }
            return processHandle;
        }

        @Override
        public int waitFor() throws InterruptedException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.delegate.getHandle());
                return ForeignException.getJNICalls().callStaticInt(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.waitForMethod2, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean waitFor(long l2, TimeUnit timeUnit) throws InterruptedException {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = timeUnitMarshaller.inferSize(timeUnit);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        timeUnitMarshaller.write((BinaryOutput)object, timeUnit);
                        int bl2 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, bl2);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, bl2, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(3, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.delegate.getHandle());
                    object.addressOf(1).setLong(l2);
                    object.addressOf(2).setJObject(jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.waitForMethod3, (JNI.JValue)object);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return bl;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            processHandleMarshaller = jNIConfig.lookupMarshaller(ProcessHandle.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            timeUnitMarshaller = jNIConfig.lookupMarshaller(TimeUnit.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod destroyMethod;
            final JNICalls.JNIMethod destroyForciblyMethod;
            final JNICalls.JNIMethod exitValueMethod;
            final JNICalls.JNIMethod getErrorStreamMethod;
            final JNICalls.JNIMethod getInputStreamMethod;
            final JNICalls.JNIMethod getOutputStreamMethod;
            final JNICalls.JNIMethod isAliveMethod;
            final JNICalls.JNIMethod pidMethod;
            final JNICalls.JNIMethod supportsNormalTerminationMethod;
            final JNICalls.JNIMethod toHandleMethod;
            final JNICalls.JNIMethod waitForMethod2;
            final JNICalls.JNIMethod waitForMethod3;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass(jNIEnv, EndPoint.class);
                this.destroyMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "destroy", "(Ljava/lang/Process;)V");
                this.destroyForciblyMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "destroyForcibly", "(Ljava/lang/Process;)Ljava/lang/Process;");
                this.exitValueMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "exitValue", "(Ljava/lang/Process;)I");
                this.getErrorStreamMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getErrorStream", "(Ljava/lang/Process;)Ljava/io/InputStream;");
                this.getInputStreamMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getInputStream", "(Ljava/lang/Process;)Ljava/io/InputStream;");
                this.getOutputStreamMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "getOutputStream", "(Ljava/lang/Process;)Ljava/io/OutputStream;");
                this.isAliveMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "isAlive", "(Ljava/lang/Process;)Z");
                this.pidMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "pid", "(Ljava/lang/Process;)J");
                this.supportsNormalTerminationMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "supportsNormalTermination", "(Ljava/lang/Process;)Z");
                this.toHandleMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "toHandle", "(Ljava/lang/Process;)[B");
                this.waitForMethod2 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "waitFor", "(Ljava/lang/Process;)I");
                this.waitForMethod3 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "waitFor", "(Ljava/lang/Process;J[B)Z");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<ProcessHandle> processHandleMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<TimeUnit> timeUnitMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void destroy(Process process) {
            try {
                process.destroy();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static Process destroyForcibly(Process process) {
            try {
                Process process2 = process.destroyForcibly();
                return process2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static int exitValue(Process process) {
            try {
                int n2 = process.exitValue();
                return n2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static InputStream getErrorStream(Process process) {
            try {
                InputStream inputStream = process.getErrorStream();
                return inputStream;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static InputStream getInputStream(Process process) {
            try {
                InputStream inputStream = process.getInputStream();
                return inputStream;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static OutputStream getOutputStream(Process process) {
            try {
                OutputStream outputStream = process.getOutputStream();
                return outputStream;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isAlive(Process process) {
            try {
                boolean bl = process.isAlive();
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static long pid(Process process) {
            try {
                long l2 = process.pid();
                return l2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean supportsNormalTermination(Process process) {
            try {
                boolean bl = process.supportsNormalTermination();
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] toHandle(Process process) {
            try {
                ProcessHandle processHandle = process.toHandle();
                int n2 = processHandleMarshaller.inferSize(processHandle);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create(n2);
                processHandleMarshaller.write(byteArrayBinaryOutput, processHandle);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static int waitFor(Process process) {
            try {
                int n2 = process.waitFor();
                return n2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean waitFor(Process process, long l2, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                TimeUnit timeUnit = timeUnitMarshaller.read(binaryInput);
                boolean bl = process.waitFor(l2, timeUnit);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            processHandleMarshaller = jNIConfig.lookupMarshaller(ProcessHandle.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            timeUnitMarshaller = jNIConfig.lookupMarshaller(TimeUnit.class, new Class[0]);
        }
    }
}

