/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSMessageEndpoint;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNICalls;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIClassCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.io.MessageEndpoint;

final class HSMessageEndpointGen {
    HSMessageEndpointGen() {
    }

    static HSMessageEndpoint createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSMessageEndpoint {
        private static final BinaryMarshaller<ByteBuffer> byteBufferMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendBinary(ByteBuffer byteBuffer) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = byteBufferMarshaller.inferSize(byteBuffer);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        byteBufferMarshaller.write((BinaryOutput)object, byteBuffer);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(2, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.sendBinaryMethod, (JNI.JValue)object);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free(cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void sendClose() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.sendCloseMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendPing(ByteBuffer byteBuffer) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = byteBufferMarshaller.inferSize(byteBuffer);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        byteBufferMarshaller.write((BinaryOutput)object, byteBuffer);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(2, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.sendPingMethod, (JNI.JValue)object);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free(cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendPong(ByteBuffer byteBuffer) throws IOException {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(256);
                int n3 = byteBufferMarshaller.inferSize(byteBuffer);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n2, false);){
                        byteBufferMarshaller.write((BinaryOutput)object, byteBuffer);
                        int n4 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, n4);
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n4, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(2, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.sendPongMethod, (JNI.JValue)object);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free(cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void sendText(String string) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(JNIUtil.createHSString(jNIEnv, string));
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.sendTextMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            byteBufferMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod sendBinaryMethod;
            final JNICalls.JNIMethod sendCloseMethod;
            final JNICalls.JNIMethod sendPingMethod;
            final JNICalls.JNIMethod sendPongMethod;
            final JNICalls.JNIMethod sendTextMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass(jNIEnv, EndPoint.class);
                this.sendBinaryMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "sendBinary", "(Lorg/graalvm/polyglot/io/MessageEndpoint;[B)V");
                this.sendCloseMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "sendClose", "(Lorg/graalvm/polyglot/io/MessageEndpoint;)V");
                this.sendPingMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "sendPing", "(Lorg/graalvm/polyglot/io/MessageEndpoint;[B)V");
                this.sendPongMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "sendPong", "(Lorg/graalvm/polyglot/io/MessageEndpoint;[B)V");
                this.sendTextMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "sendText", "(Lorg/graalvm/polyglot/io/MessageEndpoint;Ljava/lang/String;)V");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<ByteBuffer> byteBufferMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void sendBinary(MessageEndpoint messageEndpoint, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                ByteBuffer byteBuffer = byteBufferMarshaller.read(binaryInput);
                messageEndpoint.sendBinary(byteBuffer);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void sendClose(MessageEndpoint messageEndpoint) {
            try {
                messageEndpoint.sendClose();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void sendPing(MessageEndpoint messageEndpoint, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                ByteBuffer byteBuffer = byteBufferMarshaller.read(binaryInput);
                messageEndpoint.sendPing(byteBuffer);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void sendPong(MessageEndpoint messageEndpoint, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                ByteBuffer byteBuffer = byteBufferMarshaller.read(binaryInput);
                messageEndpoint.sendPong(byteBuffer);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void sendText(MessageEndpoint messageEndpoint, String string) {
            try {
                messageEndpoint.sendText(string);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            byteBufferMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

