/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.instrumentation.JSTaggedExecutionNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import java.util.Set;

@NodeInfo(shortName="switch")
public final class SwitchNode
extends StatementNode
implements ResumableNode.WithObjectState {
    @Node.Children
    private final JavaScriptNode[] declarations;
    @Node.Children
    private final JavaScriptNode[] caseExpressions;
    @Node.Children
    private final JavaScriptNode[] statements;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] jumptable;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final CountingConditionProfile[] conditionProfiles;
    private final boolean ordered;

    private SwitchNode(JavaScriptNode[] declarations, JavaScriptNode[] caseExpressions, int[] jumptable, JavaScriptNode[] statements) {
        assert (caseExpressions.length == jumptable.length - 1);
        this.declarations = declarations;
        this.caseExpressions = caseExpressions;
        this.statements = statements;
        this.jumptable = jumptable;
        this.ordered = SwitchNode.isMonotonicallyIncreasing(jumptable);
        this.conditionProfiles = SwitchNode.createConditionProfiles(caseExpressions.length);
    }

    private static boolean isMonotonicallyIncreasing(int[] table) {
        for (int i2 = 0; i2 < table.length - 1; ++i2) {
            int start = table[i2];
            int end = table[i2 + 1];
            if (start <= end) continue;
            return false;
        }
        return true;
    }

    private static CountingConditionProfile[] createConditionProfiles(int length) {
        CountingConditionProfile[] a2 = new CountingConditionProfile[length];
        for (int i2 = 0; i2 < length; ++i2) {
            a2[i2] = CountingConditionProfile.create();
        }
        return a2;
    }

    public static SwitchNode create(JavaScriptNode[] declarations, JavaScriptNode[] caseExpressions, int[] jumptable, JavaScriptNode[] statements) {
        return new SwitchNode(declarations, caseExpressions, jumptable, statements);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ControlFlowRootTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowRootTag.Type.Conditional.name());
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.ControlFlowRootTag.class) && this.needsMaterialization()) {
            int i2;
            JavaScriptNode[] newCaseExpressions = new JavaScriptNode[this.caseExpressions.length];
            boolean wasChanged = false;
            for (int i3 = 0; i3 < this.caseExpressions.length; ++i3) {
                InstrumentableNode materialized = this.caseExpressions[i3].materializeInstrumentableNodes(materializedTags);
                newCaseExpressions[i3] = JSTaggedExecutionNode.createForInput((JavaScriptNode)materialized, JSTags.ControlFlowBranchTag.class, JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowBranchTag.Type.Condition.name()), materializedTags);
                if (newCaseExpressions[i3] == this.caseExpressions[i3]) continue;
                wasChanged = true;
            }
            JavaScriptNode[] newStatements = new JavaScriptNode[this.statements.length];
            for (i2 = 0; i2 < this.statements.length; ++i2) {
                InstrumentableNode materialized = this.statements[i2].materializeInstrumentableNodes(materializedTags);
                newStatements[i2] = JSTaggedExecutionNode.createFor((JavaScriptNode)materialized, JSTags.ControlFlowBlockTag.class, materializedTags);
                if (newStatements[i2] == this.statements[i2]) continue;
                wasChanged = true;
            }
            if (!wasChanged) {
                return this;
            }
            for (i2 = 0; i2 < this.caseExpressions.length; ++i2) {
                if (newCaseExpressions[i2] != this.caseExpressions[i2]) continue;
                newCaseExpressions[i2] = SwitchNode.cloneUninitialized(this.caseExpressions[i2], materializedTags);
            }
            for (i2 = 0; i2 < this.statements.length; ++i2) {
                if (newStatements[i2] != this.statements[i2]) continue;
                newStatements[i2] = SwitchNode.cloneUninitialized(this.statements[i2], materializedTags);
            }
            SwitchNode materialized = SwitchNode.create(SwitchNode.cloneUninitialized(this.declarations, materializedTags), newCaseExpressions, this.jumptable, newStatements);
            SwitchNode.transferSourceSectionAndTags(this, materialized);
            return materialized;
        }
        return this;
    }

    private boolean needsMaterialization() {
        int i2;
        boolean needsMaterialization = false;
        for (i2 = 0; i2 < this.caseExpressions.length && !needsMaterialization; ++i2) {
            if (JSNodeUtil.isTaggedNode(this.caseExpressions[i2])) continue;
            needsMaterialization = true;
        }
        for (i2 = 0; i2 < this.statements.length && !needsMaterialization; ++i2) {
            if (JSNodeUtil.isTaggedNode(this.statements[i2])) continue;
            needsMaterialization = true;
        }
        return needsMaterialization;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.executeDeclarations(frame);
        if (this.ordered) {
            return this.executeOrdered(frame);
        }
        return this.executeDefault(frame);
    }

    @ExplodeLoop
    private void executeDeclarations(VirtualFrame frame) {
        for (int i2 = 0; i2 < this.declarations.length; ++i2) {
            this.declarations[i2].execute(frame);
        }
    }

    private Object executeDefault(VirtualFrame frame) {
        int statementStartIndex = this.identifyTargetCase(frame, 0, -1);
        return this.executeStatements(frame, statementStartIndex);
    }

    @Override
    public Object resume(VirtualFrame frame, int stateSlot) {
        Object resumptionResult;
        int statementIndex;
        int caseIndex;
        Object maybeState = this.getState(frame, stateSlot);
        if (maybeState instanceof SwitchResumptionRecord) {
            this.resetState(frame, stateSlot);
            SwitchResumptionRecord state = (SwitchResumptionRecord)maybeState;
            caseIndex = state.caseIndex;
            statementIndex = state.statementIndex;
            resumptionResult = state.result;
        } else {
            caseIndex = 0;
            statementIndex = 0;
            resumptionResult = EMPTY;
            this.executeDeclarations(frame);
        }
        if (caseIndex >= 0) {
            statementIndex = this.identifyTargetCase(frame, caseIndex, stateSlot);
        }
        return this.executeStatements(frame, statementIndex, resumptionResult, stateSlot);
    }

    @ExplodeLoop
    private int identifyTargetCase(VirtualFrame frame, int firstCase, int stateSlot) {
        int i2;
        try {
            for (i2 = 0; !(i2 >= this.caseExpressions.length || i2 >= firstCase && SwitchNode.executeConditionAsBoolean(frame, this.caseExpressions[i2])); ++i2) {
            }
            int statementStartIndex = this.jumptable[i2];
            CompilerAsserts.partialEvaluationConstant(statementStartIndex);
            return statementStartIndex;
        }
        catch (YieldException e2) {
            this.setState(frame, stateSlot, new SwitchResumptionRecord(i2, -1, null));
            throw e2;
        }
    }

    private Object executeStatements(VirtualFrame frame, int statementStartIndex) {
        return this.executeStatements(frame, statementStartIndex, EMPTY, -1);
    }

    @ExplodeLoop
    private Object executeStatements(VirtualFrame frame, int statementStartIndex, Object initialResult, int stateSlot) {
        int statementIndex;
        Object result = initialResult;
        try {
            for (statementIndex = 0; statementIndex < this.statements.length; ++statementIndex) {
                if (statementIndex < statementStartIndex) continue;
                result = this.statements[statementIndex].execute(frame);
            }
            return result;
        }
        catch (YieldException e2) {
            this.setState(frame, stateSlot, new SwitchResumptionRecord(-1, statementIndex, result));
            throw e2;
        }
    }

    @ExplodeLoop
    private Object executeOrdered(VirtualFrame frame) {
        int statementStartIndex;
        int jumptableIdx;
        JavaScriptNode[] caseExpressionsLocal = this.caseExpressions;
        JavaScriptNode[] statementsLocal = this.statements;
        int[] jumptableLocal = this.jumptable;
        CountingConditionProfile[] conditionProfilesLocal = this.conditionProfiles;
        boolean caseFound = false;
        Object result = EMPTY;
        for (jumptableIdx = 0; jumptableIdx < caseExpressionsLocal.length; ++jumptableIdx) {
            if (caseFound || SwitchNode.executeConditionAsBoolean(frame, caseExpressionsLocal[jumptableIdx])) {
                caseFound = true;
            }
            statementStartIndex = jumptableLocal[jumptableIdx];
            int statementEndIndex = jumptableLocal[jumptableIdx + 1];
            CompilerAsserts.partialEvaluationConstant(statementStartIndex);
            CompilerAsserts.partialEvaluationConstant(statementEndIndex);
            if (statementStartIndex == statementEndIndex || !conditionProfilesLocal[jumptableIdx].profile(caseFound)) continue;
            for (int statementIndex = statementStartIndex; statementIndex < statementEndIndex; ++statementIndex) {
                result = statementsLocal[statementIndex].execute(frame);
            }
        }
        statementStartIndex = jumptableLocal[jumptableIdx];
        CompilerAsserts.partialEvaluationConstant(statementStartIndex);
        for (int statementIndex = statementStartIndex; statementIndex < statementsLocal.length; ++statementIndex) {
            result = statementsLocal[statementIndex].execute(frame);
        }
        return result;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return SwitchNode.create(SwitchNode.cloneUninitialized(this.declarations, materializedTags), SwitchNode.cloneUninitialized(this.caseExpressions, materializedTags), this.jumptable, SwitchNode.cloneUninitialized(this.statements, materializedTags));
    }

    private static class SwitchResumptionRecord {
        private final Object result;
        private final int caseIndex;
        private final int statementIndex;

        SwitchResumptionRecord(int resumptionCaseIndex, int statementIndex, Object result) {
            this.result = result;
            this.caseIndex = resumptionCaseIndex;
            this.statementIndex = statementIndex;
        }
    }
}

