/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainDatePrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.temporal.UnsupportedValueOfNodeGen;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNode;
import com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import com.oracle.truffle.js.nodes.temporal.GetDifferenceSettingsNode;
import com.oracle.truffle.js.nodes.temporal.IsPartialTemporalObjectNode;
import com.oracle.truffle.js.nodes.temporal.RoundRelativeDurationNode;
import com.oracle.truffle.js.nodes.temporal.SnapshotOwnPropertiesNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddDateNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarGetterNode;
import com.oracle.truffle.js.nodes.temporal.TemporalDifferenceDateNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalMonthDayFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarSlotValueNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneSlotValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;
import java.util.List;

public class TemporalPlainDatePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainDatePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainDatePrototypeBuiltins();

    protected TemporalPlainDatePrototypeBuiltins() {
        super(JSTemporalPlainDate.PROTOTYPE_NAME, TemporalPlainDatePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainDatePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateCalendarGetterNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateGetterNodeGen.create(context, builtin, builtinEnum, TemporalPlainDatePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 17: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateAddSubNodeGen.create(context, builtin, 1, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 18: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateAddSubNodeGen.create(context, builtin, -1, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 19: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateWithNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 20: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateWithCalendarNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 21: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateUntilSinceNodeGen.create(context, builtin, 1, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 22: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateUntilSinceNodeGen.create(context, builtin, -1, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 23: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateEqualsNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 24: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToPlainDateTimeNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 14: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToPlainYearMonthNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 15: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToPlainMonthDayNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 25: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToZonedDateTimeNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 16: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateGetISOFieldsNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 26: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToStringNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 27: 
            case 28: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToLocaleStringNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 29: {
                return UnsupportedValueOfNodeGen.create(context, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainDatePrototype implements BuiltinEnum<TemporalPlainDatePrototype>
    {
        calendarId(0),
        year(0),
        month(0),
        monthCode(0),
        day(0),
        dayOfYear(0),
        dayOfWeek(0),
        weekOfYear(0),
        yearOfWeek(0),
        daysInWeek(0),
        daysInMonth(0),
        daysInYear(0),
        monthsInYear(0),
        inLeapYear(0),
        toPlainYearMonth(0),
        toPlainMonthDay(0),
        getISOFields(0),
        add(1),
        subtract(1),
        with(1),
        withCalendar(1),
        until(1),
        since(1),
        equals(1),
        toPlainDateTime(0),
        toZonedDateTime(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0);

        private final int length;

        private TemporalPlainDatePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(calendarId, new TemporalPlainDatePrototype[]{year, month, monthCode, day, dayOfYear, dayOfWeek, weekOfYear, yearOfWeek, daysInWeek, daysInMonth, daysInYear, monthsInYear, inLeapYear}).contains(this);
        }
    }

    public static abstract class JSTemporalPlainDateCalendarGetterNode
    extends JSBuiltinNode {
        protected JSTemporalPlainDateCalendarGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static TruffleString calendarId(JSTemporalPlainDateObject temporalDate, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            return toCalendarIdentifier.executeString(temporalDate.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalPlainDate(temporalDate)"})
        protected static TruffleString invalidReceiver(Object temporalDate) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateGetterNode
    extends JSBuiltinNode {
        protected final TemporalPlainDatePrototype property;

        protected JSTemporalPlainDateGetterNode(JSContext context, JSBuiltin builtin, TemporalPlainDatePrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected final Object dateGetter(JSTemporalPlainDateObject temporalDT, @Cached TemporalCalendarGetterNode calendarGetterNode) {
            switch (this.property.ordinal()) {
                case 1: {
                    return TemporalUtil.calendarYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 2: {
                    return TemporalUtil.calendarMonth(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 4: {
                    return TemporalUtil.calendarDay(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 6: {
                    return TemporalUtil.calendarDayOfWeek(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 5: {
                    return TemporalUtil.calendarDayOfYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 3: {
                    return TemporalUtil.calendarMonthCode(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 7: {
                    return TemporalUtil.calendarWeekOfYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 8: {
                    return TemporalUtil.calendarYearOfWeek(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 9: {
                    return TemporalUtil.calendarDaysInWeek(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 10: {
                    return TemporalUtil.calendarDaysInMonth(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 11: {
                    return TemporalUtil.calendarDaysInYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 12: {
                    return TemporalUtil.calendarMonthsInYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 13: {
                    return TemporalUtil.calendarInLeapYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalPlainDateAddSubNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected final JSTemporalPlainDateObject addDate(JSTemporalPlainDateObject date, Object temporalDurationLike, Object optParam, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached(value="createDateAdd()") CalendarMethodsRecordLookupNode lookupDateAdd, @Cached TemporalAddDateNode addDateNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            JSRealm realm = this.getRealm();
            if (this.sign < 0) {
                duration = JSTemporalDuration.createNegatedTemporalDuration(this.getContext(), realm, duration);
            }
            Object calendar = date.getCalendar();
            Object dateAddMethod = lookupDateAdd.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateAdd(calendar, dateAddMethod);
            return addDateNode.execute(calendarRec, date, duration, options);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainDateObject invalidReceiver(Object thisObj, Object temporalDurationLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateWith
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateWith(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final JSTemporalPlainDateObject with(JSTemporalPlainDateObject temporalDate, Object temporalDateLike, Object options, @Cached IsPartialTemporalObjectNode isPartialTemporalObjectNode, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached(value="createDateFromFields()") CalendarMethodsRecordLookupNode lookupDateFromFields, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createMergeFields()") CalendarMethodsRecordLookupNode lookupMergeFields, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            if (!isPartialTemporalObjectNode.execute(temporalDateLike)) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorPartialTemporalObjectExpected();
            }
            JSObject resolvedOptions = snapshotOwnProperties.snapshot(this.getOptionsObject(options, this, errorBranch, optionUndefined), Null.instance);
            Object calendarSlotValue = temporalDate.getCalendar();
            Object dateFromFieldsMethod = lookupDateFromFields.execute(calendarSlotValue);
            Object fieldsMethod = lookupFields.execute(calendarSlotValue);
            Object mergeFieldsMethod = lookupMergeFields.execute(calendarSlotValue);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateFromFieldsAndFieldsAndMergeFields(calendarSlotValue, dateFromFieldsMethod, fieldsMethod, mergeFieldsMethod);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listDMMCY);
            JSDynamicObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), temporalDate, fieldNames, TemporalUtil.listEmpty);
            JSObject partialDate = TemporalUtil.prepareTemporalFields(this.getContext(), temporalDateLike, fieldNames, null);
            fields = TemporalUtil.calendarMergeFields(this.getContext(), this.getRealm(), calendarRec, fields, partialDate, this, errorBranch);
            fields = TemporalUtil.prepareTemporalFields(this.getContext(), fields, fieldNames, TemporalUtil.listEmpty);
            return dateFromFieldsNode.execute(calendarRec, fields, resolvedOptions);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainDateObject invalidReceiver(Object thisObj, Object temporalDateLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateWithCalendar
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateWithCalendar(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final JSTemporalPlainDateObject withCalendar(JSTemporalPlainDateObject date, Object calendarParam, @Cached ToTemporalCalendarSlotValueNode toCalendarSlotValue, @Cached InlinedBranchProfile errorBranch) {
            Object calendar = toCalendarSlotValue.execute(calendarParam);
            return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), date.getYear(), date.getMonth(), date.getDay(), calendar, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainDateObject invalidReceiver(Object thisObj, Object calendarParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalPlainDateUntilSinceNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected JSTemporalDurationObject differenceTemporalPlainDate(JSTemporalPlainDateObject temporalDate, Object otherObj, Object options, @Bind(value="this") Node node, @Cached(value="createDateAdd()") CalendarMethodsRecordLookupNode lookupDateAdd, @Cached(value="createDateUntil()") CalendarMethodsRecordLookupNode lookupDateUntil, @Cached TemporalDifferenceDateNode differenceDate, @Cached ToTemporalDateNode toTemporalDate, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached RoundRelativeDurationNode roundRelativeDuration, @Cached GetDifferenceSettingsNode getDifferenceSettings, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            boolean roundingGranularityIsNoop;
            JSTemporalPlainDateObject other = toTemporalDate.execute(otherObj);
            if (!TemporalUtil.calendarEquals(temporalDate.getCalendar(), other.getCalendar(), toCalendarIdentifier)) {
                errorBranch.enter(node);
                throw TemporalErrors.createRangeErrorIdenticalCalendarExpected();
            }
            JSObject resolvedOptions = snapshotOwnProperties.snapshot(this.getOptionsObject(options, node, errorBranch, optionUndefined), Null.instance);
            GetDifferenceSettingsNode.GetDifferenceSettingsResult settings = getDifferenceSettings.execute(this.sign, resolvedOptions, TemporalUtil.unitMappingDateOrAuto, TemporalUtil.unitMappingDate, TemporalUtil.Unit.DAY, TemporalUtil.Unit.DAY);
            Object dateAddMethod = lookupDateAdd.execute(temporalDate.getCalendar());
            Object dateUntilMethod = lookupDateUntil.execute(temporalDate.getCalendar());
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateAddDateUntil(temporalDate.getCalendar(), dateAddMethod, dateUntilMethod);
            JSRuntime.createDataPropertyOrThrow(resolvedOptions, TemporalConstants.LARGEST_UNIT, settings.largestUnit().toTruffleString());
            JSTemporalDurationObject result = differenceDate.execute(calendarRec, temporalDate, other, settings.largestUnit(), resolvedOptions);
            NormalizedDurationRecord duration = TemporalUtil.createNormalizedDurationRecord(result.getYears(), result.getMonths(), result.getWeeks(), result.getDays(), TemporalUtil.zeroTimeDuration());
            boolean bl = roundingGranularityIsNoop = settings.smallestUnit() == TemporalUtil.Unit.DAY && settings.roundingIncrement() == 1;
            if (!roundingGranularityIsNoop) {
                BigInt destEpochNs = TemporalUtil.getUTCEpochNanoseconds(other.getYear(), other.getMonth(), other.getDay(), 0, 0, 0, 0, 0, 0);
                ISODateTimeRecord dateTime = new ISODateTimeRecord(temporalDate.getYear(), temporalDate.getMonth(), temporalDate.getDay(), 0, 0, 0, 0, 0, 0);
                JSTemporalDurationRecord roundedDuration = roundRelativeDuration.execute(duration, destEpochNs, dateTime, calendarRec, null, settings.largestUnit(), settings.roundingIncrement(), settings.smallestUnit(), settings.roundingMode()).duration();
                duration = new NormalizedDurationRecord(roundedDuration.getYears(), roundedDuration.getMonths(), roundedDuration.getWeeks(), roundedDuration.getDays(), BigInt.ZERO);
            }
            return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), (double)this.sign * duration.years(), (double)this.sign * duration.months(), (double)this.sign * duration.weeks(), (double)this.sign * duration.days(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalDurationObject invalidReceiver(Object thisObj, Object otherObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateEquals
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateEquals(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean equals(JSTemporalPlainDateObject temporalDate, Object otherParam, @Cached ToTemporalDateNode toTemporalDate, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            JSTemporalPlainDateObject other = toTemporalDate.execute(otherParam);
            if (temporalDate.getYear() != other.getYear()) {
                return false;
            }
            if (temporalDate.getMonth() != other.getMonth()) {
                return false;
            }
            if (temporalDate.getDay() != other.getDay()) {
                return false;
            }
            return TemporalUtil.calendarEquals(temporalDate.getCalendar(), other.getCalendar(), toCalendarIdentifier);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static boolean invalidReceiver(Object thisObj, Object otherParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToPlainDateTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToPlainDateTime(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final JSTemporalPlainDateTimeObject toPlainDateTime(JSTemporalPlainDateObject date, Object temporalTimeObj, @Cached ToTemporalTimeNode toTemporalTime, @Cached InlinedBranchProfile errorBranch) {
            if (temporalTimeObj == Undefined.instance) {
                return JSTemporalPlainDateTime.create(this.getContext(), this.getRealm(), date.getYear(), date.getMonth(), date.getDay(), 0, 0, 0, 0, 0, 0, date.getCalendar(), this, errorBranch);
            }
            JSTemporalPlainTimeObject time = toTemporalTime.execute(temporalTimeObj, null);
            return JSTemporalPlainDateTime.create(this.getContext(), this.getRealm(), date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSecond(), time.getMillisecond(), time.getMicrosecond(), time.getNanosecond(), date.getCalendar(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainDateTimeObject invalidReceiver(Object thisObj, Object temporalTimeObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToPlainYearMonth
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToPlainYearMonth(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final JSTemporalPlainYearMonthObject toPlainYearMonth(JSTemporalPlainDateObject temporalDate, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createYearMonthFromFields()") CalendarMethodsRecordLookupNode lookupYearMonthFromFields, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode) {
            Object calendarSlotValue = temporalDate.getCalendar();
            Object fieldsMethod = lookupFields.execute(calendarSlotValue);
            Object yearMonthFromFieldsMethod = lookupYearMonthFromFields.execute(calendarSlotValue);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forFieldsAndYearMonthFromFields(calendarSlotValue, fieldsMethod, yearMonthFromFieldsMethod);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), temporalDate, fieldNames, TemporalUtil.listEmpty);
            return yearMonthFromFieldsNode.execute(calendarRec, fields, Undefined.instance);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainYearMonthObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToPlainMonthDay
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToPlainMonthDay(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final JSTemporalPlainMonthDayObject toPlainMonthDay(JSTemporalPlainDateObject temporalDate, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createMonthDayFromFields()") CalendarMethodsRecordLookupNode lookupMonthDayFromFields, @Cached TemporalMonthDayFromFieldsNode monthDayFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode) {
            Object calendarSlotValue = temporalDate.getCalendar();
            Object fieldsMethod = lookupFields.execute(calendarSlotValue);
            Object monthDayFromFieldsMethod = lookupMonthDayFromFields.execute(calendarSlotValue);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forFieldsAndMonthDayFromFields(calendarSlotValue, fieldsMethod, monthDayFromFieldsMethod);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listDMC);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), temporalDate, fieldNames, TemporalUtil.listEmpty);
            return monthDayFromFieldsNode.execute(calendarRec, fields, Undefined.instance);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainMonthDayObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToZonedDateTimeNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToZonedDateTimeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final JSTemporalZonedDateTimeObject toZonedDateTime(JSTemporalPlainDateObject td, Object item, @Cached InlinedConditionProfile timeZoneIsUndefined, @Cached InlinedConditionProfile timeIsUndefined, @Cached ToTemporalTimeNode toTemporalTime, @Cached ToTemporalTimeZoneSlotValueNode toTimeZoneSlotValue, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord, @Cached InlinedBranchProfile errorBranch) {
            JSTemporalPlainDateTimeObject temporalDateTime;
            Object temporalTime;
            Object timeZone;
            if (this.isObject(item)) {
                JSDynamicObject itemObj = TemporalUtil.toJSDynamicObject(item, this, errorBranch);
                Object timeZoneLike = JSObject.get(itemObj, TemporalConstants.TIME_ZONE);
                if (timeZoneIsUndefined.profile(this, timeZoneLike == Undefined.instance)) {
                    timeZone = toTimeZoneSlotValue.execute(item);
                    temporalTime = Undefined.instance;
                } else {
                    timeZone = toTimeZoneSlotValue.execute(timeZoneLike);
                    temporalTime = JSObject.get(itemObj, TemporalConstants.PLAIN_TIME);
                }
            } else {
                timeZone = toTimeZoneSlotValue.execute(item);
                temporalTime = Undefined.instance;
            }
            JSRealm realm = this.getRealm();
            if (timeIsUndefined.profile(this, temporalTime == Undefined.instance)) {
                temporalDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, td.getYear(), td.getMonth(), td.getDay(), 0, 0, 0, 0, 0, 0, td.getCalendar(), this, errorBranch);
            } else {
                JSTemporalPlainTimeObject tt = toTemporalTime.execute(temporalTime, null);
                temporalDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, td.getYear(), td.getMonth(), td.getDay(), tt.getHour(), tt.getMinute(), tt.getSecond(), tt.getMillisecond(), tt.getMicrosecond(), tt.getNanosecond(), td.getCalendar(), this, errorBranch);
            }
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSTemporalInstantObject instant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, temporalDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, instant.getNanoseconds(), timeZone, td.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalZonedDateTimeObject invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateGetISOFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateGetISOFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final JSObject getISOFields(JSTemporalPlainDateObject dt) {
            JSObject obj = JSOrdinary.create(this.getContext(), this.getRealm());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.CALENDAR, dt.getCalendar());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_DAY, dt.getDay());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MONTH, dt.getMonth());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_YEAR, dt.getYear());
            return obj;
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalPlainDateObject date, Object optionsParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.ShowCalendar showCalendar = TemporalUtil.toShowCalendarOption(options, getOptionNode, equalNode);
            return JSTemporalPlainDate.temporalDateToString(date, showCalendar);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static TruffleString invalidReceiver(Object thisObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static TruffleString toLocaleString(JSTemporalPlainDateObject date) {
            return JSTemporalPlainDate.temporalDateToString(date, TemporalUtil.ShowCalendar.AUTO);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static TruffleString invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }
}

