/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.host.HostMethodScope;
import java.math.BigInteger;

final class HostUtil {
    private HostUtil() {
    }

    @HostCompilerDirectives.InliningCutoff
    static Object convertLossLess(Object value, Class<?> requestedType, InteropLibrary interop) {
        try {
            if (interop.isNumber(value)) {
                if (requestedType == Byte.TYPE || requestedType == Byte.class) {
                    return interop.asByte(value);
                }
                if (requestedType == Short.TYPE || requestedType == Short.class) {
                    return interop.asShort(value);
                }
                if (requestedType == Integer.TYPE || requestedType == Integer.class) {
                    return interop.asInt(value);
                }
                if (requestedType == Long.TYPE || requestedType == Long.class) {
                    return interop.asLong(value);
                }
                if (requestedType == Float.TYPE || requestedType == Float.class) {
                    return Float.valueOf(interop.asFloat(value));
                }
                if (requestedType == Double.TYPE || requestedType == Double.class) {
                    return interop.asDouble(value);
                }
                if (requestedType == BigInteger.class) {
                    return interop.asBigInteger(value);
                }
                if (requestedType == Number.class) {
                    return HostUtil.convertToNumber(value, interop);
                }
            } else if (interop.isBoolean(value)) {
                if (requestedType == Boolean.TYPE || requestedType == Boolean.class) {
                    return interop.asBoolean(value);
                }
            } else if (interop.isString(value)) {
                if (requestedType == Character.TYPE || requestedType == Character.class) {
                    String str = interop.asString(value);
                    if (str.length() == 1) {
                        return Character.valueOf(str.charAt(0));
                    }
                } else if (requestedType == String.class || requestedType == CharSequence.class) {
                    return interop.asString(value);
                }
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        return null;
    }

    @HostCompilerDirectives.InliningCutoff
    static Object convertToNumber(Object value, InteropLibrary interop) {
        try {
            if (value instanceof HostMethodScope.ScopedObject) {
                HostMethodScope.ScopedObject s2 = (HostMethodScope.ScopedObject)value;
                Object delegate = s2.delegate;
                if (delegate instanceof Number) {
                    return delegate;
                }
            }
            if (value instanceof Number) {
                return value;
            }
            if (interop.fitsInByte(value)) {
                return interop.asByte(value);
            }
            if (interop.fitsInShort(value)) {
                return interop.asShort(value);
            }
            if (interop.fitsInInt(value)) {
                return interop.asInt(value);
            }
            if (interop.fitsInLong(value)) {
                return interop.asLong(value);
            }
            if (interop.fitsInFloat(value)) {
                return Float.valueOf(interop.asFloat(value));
            }
            if (interop.fitsInDouble(value)) {
                return interop.asDouble(value);
            }
            if (interop.fitsInBigInteger(value)) {
                return interop.asBigInteger(value);
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        return null;
    }

    @HostCompilerDirectives.InliningCutoff
    static Object convertLossy(Object value, Class<?> targetType, InteropLibrary interop) {
        if ((targetType == Character.TYPE || targetType == Character.class) && interop.fitsInInt(value)) {
            try {
                int v2 = interop.asInt(value);
                if (v2 >= 0 && v2 < 65536) {
                    return Character.valueOf((char)v2);
                }
            }
            catch (UnsupportedMessageException e2) {
                CompilerDirectives.shouldNotReachHere(e2);
            }
        }
        return null;
    }
}

