/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.util;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.api.capability.ISpellData;
import com.mrbysco.spelled.api.capability.SpellDataCapability;
import com.mrbysco.spelled.api.keywords.IKeyword;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.config.SpelledConfig;
import com.mrbysco.spelled.entity.SpellEntity;
import com.mrbysco.spelled.registry.SpelledRegistry;
import com.mrbysco.spelled.registry.keyword.TypeKeyword;
import com.mrbysco.spelled.util.LevelHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ServerChatEvent;

public class SpellUtil {
    public static Component manualCastSpell(ServerPlayer player, String spell, Component comp) {
        ServerChatEvent event = new ServerChatEvent(player, spell, comp);
        SpellUtil.castSpell(event);
        if (event.isCanceled()) {
            return null;
        }
        return event.getMessage();
    }

    public static void castSpell(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        SpelledAPI.getSpellDataCap((Player)player).ifPresent(data -> {
            KeywordRegistry registry = KeywordRegistry.instance();
            String message = event.getRawText().toLowerCase(Locale.ROOT);
            String[] wordArray = message.split("\\s+");
            List<String> words = Arrays.asList(wordArray);
            boolean validSpellFormation = SpellUtil.isValidSpellFormation(player, words);
            if (words.size() >= 2 && validSpellFormation) {
                if (SpellUtil.canCastSpell(player, words)) {
                    if (SpellUtil.isOnCooldown(player)) {
                        event.setCanceled(true);
                        return;
                    }
                    IKeyword lastKeyword = registry.getKeywordFromName(words.get(words.size() - 1));
                    ServerLevel level = player.m_284548_();
                    if (lastKeyword instanceof TypeKeyword) {
                        TypeKeyword typeKeyword = (TypeKeyword)lastKeyword;
                        SpellEntity spell = SpellUtil.constructEntity(player, typeKeyword.getType());
                        StringBuilder castText = new StringBuilder();
                        MutableComponent descriptionComponent = Component.m_237113_((String)"");
                        int cooldown = -1;
                        for (int i = 0; i < words.size() - 1; ++i) {
                            IKeyword keyword = registry.getKeywordFromName(words.get(i));
                            if (keyword == null) continue;
                            cooldown += keyword.getSlots();
                            castText.append(keyword.getKeyword()).append(" ");
                            descriptionComponent.m_7220_(keyword.getDescription()).m_7220_((Component)Component.m_237113_((String)" "));
                            int previous = i - 1;
                            if (previous >= 0 && previous < words.size() - 1) {
                                keyword.cast((Level)level, player, spell, registry.getKeywordFromName(words.get(previous)));
                                continue;
                            }
                            keyword.cast((Level)level, player, spell, null);
                        }
                        cooldown = Mth.m_14045_((int)cooldown, (int)1, (int)Integer.MAX_VALUE);
                        castText.append(lastKeyword.getKeyword());
                        MutableComponent castComponent = Component.m_237113_((String)castText.toString());
                        descriptionComponent.m_7220_(typeKeyword.getDescription());
                        descriptionComponent.m_130940_(ChatFormatting.GOLD);
                        castComponent.m_6270_(event.getMessage().m_7383_().m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)descriptionComponent))).m_130940_(ChatFormatting.GOLD);
                        MutableComponent finalMessage = Component.m_237110_((String)"spelled.spell.cast", (Object[])new Object[]{player.m_5446_(), castComponent});
                        if (spell != null) {
                            if (!player.m_150110_().f_35937_) {
                                SpelledAPI.setCooldown((Player)player, cooldown);
                                SpelledAPI.syncCap(player);
                            }
                            if (typeKeyword.getType() != TypeKeyword.Type.SELF) {
                                SpellUtil.shootSpell(player, spell);
                                level.m_7967_((Entity)spell);
                            } else {
                                spell.handleEntityHit((Entity)player);
                                spell.m_146870_();
                            }
                        }
                        if ((Integer)SpelledConfig.COMMON.proximity.get() > 0) {
                            event.setCanceled(true);
                            List playerEntities = level.m_6907_();
                            for (ServerPlayer nearbyPlayer : playerEntities) {
                                if (!nearbyPlayer.m_20148_().equals(player.m_20148_()) && (nearbyPlayer.m_9236_().m_46472_() != level.m_46472_() || !(player.m_20280_((Entity)nearbyPlayer) <= (double)((Integer)SpelledConfig.COMMON.proximity.get()).intValue()))) continue;
                                nearbyPlayer.m_240418_((Component)finalMessage, true);
                            }
                        } else {
                            event.setMessage((Component)finalMessage);
                        }
                    }
                } else {
                    event.setCanceled(true);
                }
            }
        });
    }

    public static boolean isValidSpellFormation(ServerPlayer player, List<String> words) {
        ISpellData data = (ISpellData)SpelledAPI.getSpellDataCap((Player)player).orElse((Object)new SpellDataCapability());
        KeywordRegistry registry = KeywordRegistry.instance();
        for (String word : words) {
            if (!registry.containsKey(word)) {
                return false;
            }
            if (data.knowsKeyword(word)) continue;
            return false;
        }
        return true;
    }

    public static boolean canCastSpell(ServerPlayer player, List<String> words) {
        ISpellData data = (ISpellData)SpelledAPI.getSpellDataCap((Player)player).orElse((Object)new SpellDataCapability());
        KeywordRegistry registry = KeywordRegistry.instance();
        if (player.m_150110_().f_35937_) {
            return true;
        }
        int currentLevel = data.getLevel();
        if (currentLevel == 0) {
            MutableComponent finalMessage = Component.m_237110_((String)"spelled.spell.no_levels", (Object[])new Object[]{player.m_5446_()}).m_130940_(ChatFormatting.RED);
            player.m_213846_((Component)finalMessage);
            return false;
        }
        int maxLevelWord = 0;
        for (String word : words) {
            IKeyword keyword = registry.getKeywordFromName(word);
            if (keyword == null || keyword.getLevel() <= maxLevelWord) continue;
            maxLevelWord = keyword.getLevel();
        }
        if (maxLevelWord > currentLevel) {
            MutableComponent errorMessage = Component.m_237110_((String)"spelled.spell.insufficient_level", (Object[])new Object[]{player.m_5446_(), maxLevelWord, currentLevel}).m_130940_(ChatFormatting.RED);
            player.m_213846_((Component)errorMessage);
            return false;
        }
        int maxWordCount = LevelHelper.getAllowedWordCount(currentLevel);
        if (maxWordCount > 0 && words.size() <= maxWordCount) {
            return true;
        }
        MutableComponent errorMessage = Component.m_237110_((String)"spelled.spell.too_many_words", (Object[])new Object[]{player.m_5446_(), maxWordCount}).m_130940_(ChatFormatting.RED);
        player.m_213846_((Component)errorMessage);
        return false;
    }

    public static boolean isOnCooldown(ServerPlayer player) {
        ISpellData data = (ISpellData)SpelledAPI.getSpellDataCap((Player)player).orElse((Object)new SpellDataCapability());
        int cooldown = data.getCastCooldown();
        if (cooldown > 0) {
            MutableComponent finalMessage = Component.m_237110_((String)"spelled.spell.cooldown", (Object[])new Object[]{player.m_5446_(), cooldown});
            player.m_213846_((Component)finalMessage);
            return true;
        }
        return false;
    }

    public static SpellEntity constructEntity(ServerPlayer player, @Nonnull TypeKeyword.Type type) {
        SpellEntity spell = new SpellEntity((LivingEntity)player, player.m_9236_());
        spell.setSpellType(type.getId());
        return spell;
    }

    public static void shootSpell(ServerPlayer player, SpellEntity spell) {
        spell.m_5602_((Entity)player);
        spell.m_6034_(player.m_20185_(), player.m_20188_() - (double)0.1f, player.m_20189_());
        if (spell.getSpellType() == 1) {
            spell.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 4.0f, 0.0f);
        } else {
            spell.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.0f, 0.0f);
        }
        player.m_9236_().m_5594_((Player)null, player.m_20183_(), (SoundEvent)SpelledRegistry.SHOOT_SPELL.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (player.m_9236_().f_46441_.m_188501_() * 0.4f + 1.2f) + 0.5f);
    }
}

