/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RayTraceHelper {
    private static final Predicate<Entity> defaultFilter = e -> EntitySelector.f_20402_.test(e) && EntitySelector.f_20408_.test(e);

    public static <E extends Entity> HitResult getLookingAt(Class<E> clazz, Entity mainEntity, double distance, Predicate<E> entityPredicate) {
        Predicate<Entity> finalFilter = e -> e != mainEntity && defaultFilter.test((Entity)e) && e.m_6087_() && entityPredicate.test(e);
        HitResult position = null;
        if (mainEntity.m_9236_() != null) {
            Vec3 look = mainEntity.m_20154_().m_82490_(distance);
            Vec3 from = mainEntity.m_20182_().m_82520_(0.0, (double)mainEntity.m_20192_(), 0.0);
            Vec3 to = from.m_82549_(look);
            position = RayTraceHelper.rayTraceBlocksAndEntities(clazz, mainEntity, from, to, finalFilter);
        }
        return position;
    }

    public static BlockHitResult rayTraceBlocks(Entity entity, Vec3 from, Vec3 to) {
        ClipContext context = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        return entity.m_20193_().m_45547_(context);
    }

    public static <E extends Entity> EntityHitResult rayTraceEntities(Class<E> clazz, Level level, Vec3 from, Vec3 to, Vec3 aaExpansion, float aaGrowth, float entityExpansion, Predicate<E> filter) {
        Predicate<Entity> predicate = input -> defaultFilter.test((Entity)input) && filter.test(input);
        Entity nearest = null;
        double distance = 0.0;
        AABB bb = new AABB(BlockPos.m_274446_((Position)from), BlockPos.m_274446_((Position)to)).m_82363_(aaExpansion.f_82479_, aaExpansion.f_82480_, aaExpansion.f_82481_).m_82400_((double)aaGrowth);
        List entities = level.m_6443_(clazz, bb, predicate);
        for (Entity entity : entities) {
            double dist;
            AABB entityBB = entity.m_20191_().m_82400_((double)entityExpansion);
            Optional intercept = entityBB.m_82371_(from, to);
            if (!intercept.isPresent() || !((dist = from.m_82554_((Vec3)intercept.get())) < distance) && distance != 0.0) continue;
            nearest = entity;
            distance = dist;
        }
        if (nearest != null) {
            return new EntityHitResult(nearest);
        }
        return null;
    }

    private static <E extends Entity> HitResult rayTraceBlocksAndEntities(Class<E> clazz, Entity mainEntity, Vec3 from, Vec3 to, Predicate<E> entityFilter) {
        double entityDist;
        BlockHitResult block = RayTraceHelper.rayTraceBlocks(mainEntity, from, to);
        if (block.m_6662_() == HitResult.Type.BLOCK) {
            to = block.m_82450_();
        }
        EntityHitResult entity = RayTraceHelper.rayTraceEntities(clazz, mainEntity.m_20193_(), from, to, Vec3.f_82478_, 0.5f, 0.5f, entityFilter);
        if (block.m_6662_() == HitResult.Type.MISS) {
            return entity;
        }
        if (entity == null) {
            return block;
        }
        double blockDist = block.m_82450_().m_82554_(from);
        if (blockDist < (entityDist = entity.m_82450_().m_82554_(from))) {
            return block;
        }
        return entity;
    }
}

