/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.registry.behavior;

import com.mrbysco.spelled.api.behavior.BaseBehavior;
import com.mrbysco.spelled.entity.SpellEntity;
import com.mrbysco.spelled.util.LootHelper;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class HarvestBehavior
extends BaseBehavior {
    public HarvestBehavior() {
        super("harvest");
    }

    @Override
    public void onBlockHit(@Nonnull SpellEntity spell, BlockPos pos, BlockPos offPos) {
        boolean canBreak;
        Level level = spell.m_9236_();
        BlockState hitState = level.m_8055_(pos);
        float hardness = hitState.m_60800_((BlockGetter)level, pos);
        float power = 1.0f + (float)spell.getPower();
        Entity entity = spell.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            v0 = hitState.canHarvestBlock((BlockGetter)level, pos, player);
        } else {
            v0 = canBreak = false;
        }
        if (!level.f_46443_ && canBreak && hardness <= power && hitState.m_60734_().m_7325_() <= 1200.0f) {
            if (spell.isSilky()) {
                level.m_8055_(pos).m_287290_(LootHelper.silkContextBuilder((ServerLevel)level, pos, spell)).forEach(i -> level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), i)));
                level.m_46961_(pos, false);
            } else {
                level.m_46961_(pos, true);
            }
        }
    }

    @Override
    public void onEntityHit(@Nonnull SpellEntity spell, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (EquipmentSlot slotType : EquipmentSlot.values()) {
                ItemStack stack = livingEntity.m_6844_(slotType);
                if (!livingEntity.m_217043_().m_188499_() || stack.m_41619_()) continue;
                int power = 1 + spell.getPower();
                stack.m_41622_(power, livingEntity, playerIn -> playerIn.m_21166_(slotType));
                break;
            }
        }
    }
}

