/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.registry;

import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.block.LevelingAltarBlock;
import com.mrbysco.spelled.blockentity.LevelingAltarBlockEntity;
import com.mrbysco.spelled.entity.SpellEntity;
import com.mrbysco.spelled.item.CreativeTomeItem;
import com.mrbysco.spelled.item.SpellbookItem;
import com.mrbysco.spelled.item.TomeItem;
import com.mrbysco.spelled.menu.AltarMenu;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SpelledRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"spelled");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"spelled");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"spelled");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"spelled");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"spelled");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"spelled");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"spelled");
    public static final RegistryObject<SoundEvent> SHOOT_SPELL = SOUND_EVENTS.register("shoot.spell", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("spelled", "shoot.spell")));
    public static final RegistryObject<Block> LEVELING_ALTAR = BLOCKS.register("leveling_altar", () -> new LevelingAltarBlock(BlockBehaviour.Properties.m_284310_().m_60978_(2.5f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Item> LEVELING_ALTAR_ITEM = ITEMS.register("leveling_altar", () -> new BlockItem((Block)LEVELING_ALTAR.get(), SpelledRegistry.itemBuilder()));
    public static final RegistryObject<Item> KNOWLEDGE_TOME = ITEMS.register("ancient_knowledge_tome", () -> new TomeItem(SpelledRegistry.itemBuilder()));
    public static final RegistryObject<Item> CREATIVE_TOME = ITEMS.register("creative_tome", () -> new CreativeTomeItem(SpelledRegistry.itemBuilder()));
    public static final RegistryObject<Item> SPELL_BOOK = ITEMS.register("spell_book", () -> new SpellbookItem(SpelledRegistry.itemBuilder().m_41487_(1)));
    public static final RegistryObject<BlockEntityType<LevelingAltarBlockEntity>> LEVELING_ALTAR_TILE = BLOCK_ENTITY_TYPES.register("leveling_altar_tile", () -> BlockEntityType.Builder.m_155273_(LevelingAltarBlockEntity::new, (Block[])new Block[]{(Block)LEVELING_ALTAR.get()}).m_58966_(null));
    public static final RegistryObject<MenuType<AltarMenu>> ALTAR_CONTAINER = MENU_TYPES.register("leveling_altar", () -> IForgeMenuType.create((windowId, inv, data) -> new AltarMenu(windowId, inv)));
    public static final RegistryObject<EntityType<SpellEntity>> SPELL = ENTITY_TYPES.register("spell", () -> SpelledRegistry.register("spell", EntityType.Builder.m_20704_(SpellEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(20).setCustomClientFactory(SpellEntity::new)));
    public static final RegistryObject<CreativeModeTab> SPELLED_TAB = CREATIVE_MODE_TABS.register("tab", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)LEVELING_ALTAR_ITEM.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.spelled.tab")).m_257501_((displayParameters, output) -> {
        List<ItemStack> stacks = ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
        output.m_246601_(stacks);
        for (String adjective : KeywordRegistry.instance().getAdjectives()) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("spelled:tomeUnlock", adjective);
            ItemStack stack = new ItemStack((ItemLike)KNOWLEDGE_TOME.get(), 1, nbt);
            stack.m_41751_(nbt);
            output.m_246342_(stack);
        }
    }).m_257652_());

    public static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder) {
        return builder.m_20712_(id);
    }

    private static Item.Properties itemBuilder() {
        return new Item.Properties();
    }
}

