/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.packets;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.api.capability.ISpellData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SpellDataSyncMessage {
    private final CompoundTag data;
    private final UUID playerUUID;

    public SpellDataSyncMessage(ISpellData data, UUID playerUUID) {
        this.data = (CompoundTag)data.serializeNBT();
        this.playerUUID = playerUUID;
    }

    private SpellDataSyncMessage(FriendlyByteBuf buf) {
        this.data = buf.m_130260_();
        this.playerUUID = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.data);
        buf.m_130077_(this.playerUUID);
    }

    public static SpellDataSyncMessage decode(FriendlyByteBuf packetBuffer) {
        return new SpellDataSyncMessage(packetBuffer);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            Player player;
            if (ctx.getDirection().getReceptionSide().isClient() && (player = Minecraft.m_91087_().f_91073_.m_46003_(this.playerUUID)) != null) {
                player.getCapability(SpelledAPI.SPELL_DATA_CAP).ifPresent(sanityCap -> sanityCap.deserializeNBT((Tag)this.data));
            }
        });
        ctx.setPacketHandled(true);
    }
}

