/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.packets;

import com.mrbysco.spelled.item.SpellbookItem;
import com.mrbysco.spelled.registry.SpelledRegistry;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class SignSpellPacket {
    private final ItemStack book;
    private final boolean signing;
    private final int slot;

    public SignSpellPacket(ItemStack stack, boolean signing, int slot) {
        this.book = stack.m_41777_();
        this.signing = signing;
        this.slot = slot;
    }

    private SignSpellPacket(FriendlyByteBuf buf) {
        this.book = buf.m_130267_();
        this.signing = buf.readBoolean();
        this.slot = buf.m_130242_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.book);
        buf.writeBoolean(this.signing);
        buf.m_130130_(this.slot);
    }

    public static SignSpellPacket decode(FriendlyByteBuf packetBuffer) {
        return new SignSpellPacket(packetBuffer);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isServer()) {
                CompoundTag compoundnbt;
                ServerPlayer player = ctx.getSender();
                if (this.book.m_41720_() == SpelledRegistry.SPELL_BOOK.get() && SpellbookItem.makeSureTagIsValid((Player)player, compoundnbt = this.book.m_41783_()) && (Inventory.m_36045_((int)this.slot) || this.slot == 40)) {
                    if (this.signing) {
                        this.signBook(player, compoundnbt.m_128461_("title"), compoundnbt.m_128461_("spell"), this.slot);
                    } else {
                        this.updateBookContents(player, compoundnbt.m_128461_("spell"), this.slot);
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    private void updateBookContents(ServerPlayer player, String spell, int slot) {
        ItemStack stack = player.m_150109_().m_8020_(slot);
        if (stack.m_41720_() == SpelledRegistry.SPELL_BOOK.get()) {
            stack.m_41700_("spell", (Tag)StringTag.m_129297_((String)spell));
        }
    }

    private void signBook(ServerPlayer player, String title, String spell, int slot) {
        ItemStack itemstack = player.m_150109_().m_8020_(slot);
        if (itemstack.m_41720_() == SpelledRegistry.SPELL_BOOK.get()) {
            ItemStack stack = new ItemStack((ItemLike)SpelledRegistry.SPELL_BOOK.get());
            CompoundTag compoundnbt = itemstack.m_41783_();
            if (compoundnbt != null) {
                stack.m_41751_(compoundnbt.m_6426_());
            }
            stack.m_41700_("author", (Tag)StringTag.m_129297_((String)player.m_7755_().getString()));
            stack.m_41700_("title", (Tag)StringTag.m_129297_((String)title));
            stack.m_41700_("spell", (Tag)StringTag.m_129297_((String)spell));
            stack.m_41700_("sealed", (Tag)ByteTag.m_128273_((boolean)true));
            player.m_150109_().m_6836_(slot, stack);
        }
    }
}

