/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.menu;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.config.ConfigCache;
import com.mrbysco.spelled.config.SpelledConfig;
import com.mrbysco.spelled.menu.AltarSlot;
import com.mrbysco.spelled.registry.SpelledRegistry;
import com.mrbysco.spelled.util.LevelHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class AltarMenu
extends AbstractContainerMenu {
    private final Container tableInventory = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            AltarMenu.this.m_6199_((Container)this);
        }
    };
    private final ContainerLevelAccess worldPosCallable;
    public final int[] currentLevel = new int[1];
    public final int[] levelCosts;
    public final int[] itemAmountCosts;
    public final Item[] itemCosts;

    public AltarMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.f_39287_, 0);
    }

    public AltarMenu(int id, Inventory playerInventory, ContainerLevelAccess worldPosCallable, int currentLevel) {
        super((MenuType)SpelledRegistry.ALTAR_CONTAINER.get(), id);
        this.levelCosts = new int[((Integer)SpelledConfig.COMMON.maxLevel.get()).intValue()];
        this.itemAmountCosts = new int[((Integer)SpelledConfig.COMMON.maxLevel.get()).intValue()];
        this.itemCosts = new Item[((Integer)SpelledConfig.COMMON.maxLevel.get()).intValue()];
        this.worldPosCallable = worldPosCallable;
        this.currentLevel[0] = currentLevel;
        this.m_38895_(DataSlot.m_39406_((int[])this.currentLevel, (int)0));
        for (int level = 0; level < (Integer)SpelledConfig.COMMON.maxLevel.get(); ++level) {
            this.levelCosts[level] = LevelHelper.getXPCost(level + 1);
            ConfigCache.ItemCost cost = LevelHelper.getItemCost(level + 1);
            this.itemAmountCosts[level] = cost.getCost();
            this.itemCosts[level] = cost.getItem();
            this.m_38895_(DataSlot.m_39406_((int[])this.levelCosts, (int)level));
            this.m_38895_(DataSlot.m_39406_((int[])this.itemAmountCosts, (int)level));
        }
        if (((Boolean)SpelledConfig.COMMON.requireItems.get()).booleanValue()) {
            this.m_38897_(new AltarSlot(playerInventory.f_35978_, this.tableInventory, 0, 80, 56));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public int getCostStackCount() {
        ItemStack itemstack = this.tableInventory.m_8020_(0);
        return itemstack.m_41619_() ? 0 : itemstack.m_41613_();
    }

    private boolean hasXP(Player playerIn, int level) {
        int XPCost = this.levelCosts[level];
        return ((Boolean)SpelledConfig.COMMON.individualLevels.get()).booleanValue() ? playerIn.f_36078_ >= XPCost : playerIn.f_36079_ >= XPCost;
    }

    public int getCurrentLevel() {
        return this.currentLevel[0];
    }

    public int getCurrentLevelCost() {
        int currentLevel = this.getCurrentLevel();
        if (currentLevel < this.levelCosts.length) {
            return this.levelCosts[currentLevel];
        }
        return -1;
    }

    public int getItemCostAmount() {
        int currentLevel = this.getCurrentLevel();
        if (currentLevel < this.itemAmountCosts.length) {
            return this.itemAmountCosts[currentLevel];
        }
        return -1;
    }

    public Item getItemCost() {
        int currentLevel = this.getCurrentLevel();
        if (currentLevel < this.itemCosts.length) {
            return this.itemCosts[currentLevel];
        }
        return Items.f_41852_;
    }

    public boolean m_6366_(Player playerIn, int id) {
        int level = this.currentLevel[0];
        int newLevel = level + 1;
        int XPCost = this.levelCosts[level];
        if (level >= (Integer)SpelledConfig.COMMON.maxLevel.get() || !this.hasXP(playerIn, level) && !playerIn.m_150110_().f_35937_) {
            if (!this.hasXP(playerIn, level)) {
                LevelHelper.levelUpFailXP(playerIn);
            }
            return false;
        }
        if (((Boolean)SpelledConfig.COMMON.requireItems.get()).booleanValue()) {
            ItemStack stack = this.tableInventory.m_8020_(0);
            ConfigCache.ItemCost itemCost = LevelHelper.getItemCost(newLevel);
            if (stack.m_41619_() || stack.m_41720_() != itemCost.getItem() && stack.m_41613_() < itemCost.getCost()) {
                LevelHelper.levelUpFailItems(playerIn);
                return false;
            }
            this.worldPosCallable.m_39292_((p_217003_6_, p_217003_7_) -> {
                this.useLevels(playerIn, XPCost);
                if (!playerIn.m_150110_().f_35937_) {
                    stack.m_41774_(itemCost.getCost());
                    if (stack.m_41619_()) {
                        this.tableInventory.m_6836_(0, ItemStack.f_41583_);
                    }
                }
                this.tableInventory.m_6596_();
                this.m_6199_(this.tableInventory);
                p_217003_6_.m_5594_((Player)null, p_217003_7_, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, p_217003_6_.f_46441_.m_188501_() * 0.1f + 0.9f);
                SpelledAPI.forceSetLevel((Player)((ServerPlayer)playerIn), newLevel);
                SpelledAPI.syncCap((ServerPlayer)playerIn);
                this.currentLevel[0] = newLevel;
            });
            return true;
        }
        this.useLevels(playerIn, XPCost);
        SpelledAPI.forceSetLevel((Player)((ServerPlayer)playerIn), newLevel);
        SpelledAPI.syncCap((ServerPlayer)playerIn);
        this.currentLevel[0] = newLevel;
        return true;
    }

    public void useLevels(Player playerIn, int XPCost) {
        if (((Boolean)SpelledConfig.COMMON.individualLevels.get()).booleanValue()) {
            playerIn.m_6749_(-XPCost);
        } else {
            playerIn.m_6756_(-XPCost);
        }
        if (playerIn.f_36078_ < 0) {
            playerIn.f_36078_ = 0;
            playerIn.f_36080_ = 0.0f;
            playerIn.f_36079_ = 0;
        }
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.worldPosCallable.m_39292_((level, pos) -> this.m_150411_(playerIn, this.tableInventory));
    }

    public boolean m_6875_(Player playerIn) {
        return AltarMenu.m_38889_((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)((Block)SpelledRegistry.LEVELING_ALTAR.get()));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0 ? !this.m_38903_(itemstack1, 2, 37, true) : (index == 1 ? !this.m_38903_(itemstack1, 2, 37, true) : !this.m_38903_(itemstack1, 0, 1, true))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }
}

