/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.item;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.api.capability.ISpellData;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.config.SpelledConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;

public class TomeItem
extends Item {
    public TomeItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        if (!level.f_46443_) {
            ItemStack itemstack = playerIn.m_21120_(handIn);
            if (itemstack.m_41782_() && itemstack.m_41783_() != null && itemstack.m_41783_().m_128441_("spelled:tomeUnlock")) {
                CompoundTag tag = itemstack.m_41783_();
                LazyOptional<ISpellData> cap = SpelledAPI.getSpellDataCap(playerIn);
                ISpellData data = (ISpellData)cap.orElseGet(null);
                if (cap.isPresent()) {
                    String word = tag.m_128461_("spelled:tomeUnlock");
                    if (!data.knowsKeyword(word)) {
                        playerIn.m_6672_(handIn);
                        SpelledAPI.unlockKeyword((Player)((ServerPlayer)playerIn), word);
                        SpelledAPI.syncCap((ServerPlayer)playerIn);
                        playerIn.m_5661_((Component)Component.m_237115_((String)"spelled.tome.success"), true);
                        return InteractionResultHolder.m_19096_((Object)itemstack);
                    }
                    playerIn.m_5661_((Component)Component.m_237115_((String)"spelled.tome.fail"), true);
                    return InteractionResultHolder.m_19100_((Object)itemstack);
                }
            } else {
                CompoundTag tag = new CompoundTag();
                String adjective = KeywordRegistry.instance().getRandomAdjective();
                if (!adjective.isEmpty()) {
                    tag.m_128359_("spelled:tomeUnlock", KeywordRegistry.instance().getRandomAdjective());
                    itemstack.m_41751_(tag);
                }
            }
        }
        return super.m_7203_(level, playerIn, handIn);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        if (!((Boolean)SpelledConfig.COMMON.hideKnowledgeTomeInfo.get()).booleanValue()) {
            if (stack.m_41782_() && stack.m_41783_().m_128441_("spelled:tomeUnlock")) {
                CompoundTag tag = stack.m_41783_();
                tooltip.add((Component)Component.m_237110_((String)"spelled.tome.description", (Object[])new Object[]{Component.m_237113_((String)tag.m_128461_("spelled:tomeUnlock")).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.YELLOW));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"spelled.tome.description.invalid").m_130940_(ChatFormatting.RED));
            }
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }
}

