/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.item;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.api.keywords.IKeyword;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.client.ClientHelper;
import com.mrbysco.spelled.client.gui.book.AdjectiveEntry;
import com.mrbysco.spelled.util.SpellUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class SpellbookItem
extends Item {
    public SpellbookItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41782_() && stack.m_41783_().m_128471_("sealed")) {
            if (!level.f_46443_) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                String message = stack.m_41783_().m_128461_("spell");
                String regExp = "^[a-zA-Z\\s]*$";
                if (!message.isEmpty() && message.matches("^[a-zA-Z\\s]*$")) {
                    MutableComponent component = Component.m_237110_((String)"chat.type.text", (Object[])new Object[]{serverPlayer.m_5446_(), ForgeHooks.newChatWithLinks((String)message)});
                    if ((component = SpellUtil.manualCastSpell(serverPlayer, message, (Component)component)) == null) {
                        return InteractionResultHolder.m_19100_((Object)stack);
                    }
                    serverPlayer.m_20194_().m_6846_().m_240416_((Component)component, true);
                }
            }
        } else if (level.f_46443_) {
            ArrayList<AdjectiveEntry> adjectives = new ArrayList<AdjectiveEntry>();
            SpelledAPI.getUnlocks(player).forEach(adjective -> {
                IKeyword word;
                if (!adjective.isEmpty() && (word = KeywordRegistry.instance().getKeywordFromName((String)adjective)) != null) {
                    adjectives.add(new AdjectiveEntry(word, word.getKeyword(), word.getDescription(), word.getSlots()));
                }
            });
            if (adjectives.isEmpty()) {
                player.m_213846_((Component)Component.m_237115_((String)"spelled.spell_book.insufficient"));
            } else {
                KeywordRegistry.instance().getTypes().forEach(adjective -> {
                    IKeyword word = KeywordRegistry.instance().getKeywordFromName((String)adjective);
                    adjectives.add(new AdjectiveEntry(word, word.getKeyword(), word.getDescription(), word.getSlots()));
                });
                ClientHelper.openSpellBookScreen(adjectives, hand, player);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public static boolean makeSureTagIsValid(Player player, @Nullable CompoundTag nbt) {
        if (!SpellbookItem.makeSureSpellIsValid(player, nbt)) {
            return false;
        }
        if (!nbt.m_128425_("title", 8)) {
            return false;
        }
        String s = nbt.m_128461_("title");
        return s.length() <= 32 && nbt.m_128425_("author", 8);
    }

    public static boolean makeSureSpellIsValid(Player player, @Nullable CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_("spell")) {
            String currentSpell = nbt.m_128461_("spell");
            String[] words = currentSpell.split(" ");
            List<String> wordList = Arrays.asList(words);
            wordList = wordList.subList(0, wordList.size() - 1);
            for (String word : wordList) {
                if (SpelledAPI.isUnlocked(player, word)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag compoundnbt;
        String s;
        if (stack.m_41782_() && !StringUtil.m_14408_((String)(s = (compoundnbt = stack.m_41783_()).m_128461_("title")))) {
            return Component.m_237113_((String)s);
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> textComponents, TooltipFlag flag) {
        CompoundTag tag;
        String s;
        if (stack.m_41782_() && !StringUtil.m_14408_((String)(s = (tag = stack.m_41783_()).m_128461_("author")))) {
            textComponents.add((Component)Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{s}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_("sealed");
    }
}

