/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.handler;

import com.mrbysco.spelled.api.keywords.IKeyword;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.config.SpelledConfig;
import com.mrbysco.spelled.registry.SpelledRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class LootHandler {
    private static final String hasBookTag = "spelled::hasBook";

    @SubscribeEvent
    public void firstJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Item guideBook;
        CompoundTag playerData;
        Player player = event.getEntity();
        if (!player.m_9236_().f_46443_ && ((Boolean)SpelledConfig.COMMON.startWithBook.get()).booleanValue() && !(playerData = player.getPersistentData()).m_128471_(hasBookTag) && (guideBook = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("patchouli", "guide_book"))) != null) {
            ItemStack guideStack = new ItemStack((ItemLike)guideBook);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("patchouli:book", "spelled:knowledge_tome");
            guideStack.m_41751_(tag);
            player.m_150109_().m_36054_(guideStack);
            playerData.m_128379_(hasBookTag, true);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "stronghold_library": 
                case "jungle_temple": 
                case "underwater_ruin_big": 
                case "end_city_treasure": 
                case "buried_treasure": 
                case "woodland_mansion": 
                case "bastion_treasure": 
                case "village_cartographer": {
                    event.getTable().addPool(LootHandler.getInjectPool());
                    break;
                }
            }
        }
    }

    public static LootPool getInjectPool() {
        LootPool.Builder builder = LootPool.m_79043_();
        KeywordRegistry registry = KeywordRegistry.instance();
        if (registry.getAdjectives().isEmpty()) {
            registry.initializeKeywords();
        }
        for (String adjective : registry.getAdjectives()) {
            builder.m_79076_(LootHandler.injectTome(adjective));
        }
        builder.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(1));
        builder.m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).name("spelled_inject");
        return builder.m_79082_();
    }

    private static LootPoolEntryContainer.Builder injectTome(String adjective) {
        ItemStack stack = new ItemStack((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get(), 1);
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("spelled:tomeUnlock", adjective);
        stack.m_41751_(tag);
        LootPoolSingletonContainer.Builder entry = ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get())).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)tag)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.2f))).m_79707_(1);
        return entry;
    }

    @SubscribeEvent
    public void onWandererTradesEvent(WandererTradesEvent event) {
        KeywordRegistry registry = KeywordRegistry.instance();
        if (registry.getAdjectives().isEmpty()) {
            registry.initializeKeywords();
        }
        ItemStack stack = new ItemStack((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get());
        for (String adjective : registry.getAdjectives()) {
            IKeyword keyword = registry.getKeywordFromName(adjective);
            if (keyword == null) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("spelled:tomeUnlock", adjective);
            event.getRareTrades().add(new ItemsForEmeraldsTrade(stack, keyword.getLevel() + 2, 1, tag, 1, keyword.getLevel()));
        }
    }

    public static class ItemsForEmeraldsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack outputStack;
        private final int outputAmount;
        private final CompoundTag outputTag;
        private final int priceAmount;
        private final int maxUses;
        private final int givenExp;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(ItemStack outputStack, int priceAmount, int outputAmount, CompoundTag outputTag, int maxUses, int givenExp) {
            this(outputStack, priceAmount, outputAmount, outputTag, maxUses, givenExp, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack outputStack, int priceAmount, int outputAmount, CompoundTag outputTag, int maxUses, int givenExp, float priceMultiplier) {
            this.priceAmount = priceAmount;
            this.outputStack = outputStack;
            this.outputAmount = outputAmount;
            this.outputTag = outputTag;
            this.maxUses = maxUses;
            this.givenExp = givenExp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            ItemStack stack = new ItemStack((ItemLike)this.outputStack.m_41720_(), this.outputAmount);
            stack.m_41751_(this.outputTag);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.priceAmount), stack, this.maxUses, this.givenExp, this.priceMultiplier);
        }
    }
}

