/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.generator.data;

import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import xyz.brassgoggledcoders.patchouliprovider.BookBuilder;
import xyz.brassgoggledcoders.patchouliprovider.CategoryBuilder;
import xyz.brassgoggledcoders.patchouliprovider.EntryBuilder;
import xyz.brassgoggledcoders.patchouliprovider.PatchouliBookProvider;
import xyz.brassgoggledcoders.patchouliprovider.page.CraftingPageBuilder;

public class SpelledPatchouliProvider
extends PatchouliBookProvider {
    public SpelledPatchouliProvider(PackOutput packOutput) {
        super(packOutput, "spelled", "en_us");
    }

    protected void addBooks(Consumer<BookBuilder> consumer) {
        BookBuilder bookBuilder = ((CraftingPageBuilder)this.createBookBuilder("knowledge_tome", "item.spelled.book.name", "info.spelled.book.landing").setSubtitle("info.spelled.book.subtitle").setAdvancementsTab("spelled:root").setCreativeTab("spelled").setModel("spelled:knowledge_tome").setBookTexture("spelled:textures/gui/tome.png").setShowProgress(false).setI18n(true).setFillerTexture("spelled:textures/gui/page_filler.png").setUseResourcePack(true).addMacro("$(item)", "$(#94fcf5)").addMacro("$(thing)", "$(#94fcf5)").addCategory("leveling", "info.spelled.book.leveling.name", "info.spelled.book.leveling.desc", "spelled:leveling_altar").addEntry("leveling/leveling", "info.spelled.book.leveling.entry.name", "spelled:leveling_altar").addTextPage("info.spelled.book.leveling_info.text").build().addCraftingPage(new ResourceLocation("spelled", "leveling_altar")).setText("info.spelled.book.leveling_recipe.text")).build().build().build().addCategory("types", "info.spelled.book.types.name", "info.spelled.book.types.desc", "spelled:ancient_knowledge_tome").addEntry("types/self", "info.spelled.book.types.self.name", "spelled:ancient_knowledge_tome").addTextPage("info.spelled.book.types.self.text").build().addTextPage("info.spelled.book.types.self.text2").build().build().addEntry("types/ball", "info.spelled.book.types.ball.name", "spelled:ancient_knowledge_tome").addTextPage("info.spelled.book.types.ball.text").build().addTextPage("info.spelled.book.types.ball.text2").build().build().addEntry("types/projectilis", "info.spelled.book.types.projectilis.name", "spelled:ancient_knowledge_tome").addTextPage("info.spelled.book.types.projectilis.text").build().addTextPage("info.spelled.book.types.projectilis.text2").build().build().build();
        bookBuilder = this.addColors(bookBuilder);
        bookBuilder = this.addSizes(bookBuilder);
        bookBuilder = this.addDescriptions(bookBuilder);
        bookBuilder.build(consumer);
    }

    public BookBuilder addColors(BookBuilder builder) {
        CategoryBuilder colorCategory = builder.addCategory("colors", "info.spelled.book.colors.name", "info.spelled.book.colors.desc", "spelled:ancient_knowledge_tome").setSecret(Boolean.valueOf(true));
        colorCategory.addEntry("colors/lore", "info.spelled.book.colors.lore.name", "spelled:ancient_knowledge_tome").setSecret(true).setAdvancement("spelled:color_lore").addTextPage("info.spelled.book.colors.lore.text").build().addTextPage("info.spelled.book.colors.lore.text2").build().build();
        for (String color : KeywordRegistry.instance().getColors()) {
            colorCategory.addEntry("colors/" + color, String.format("info.spelled.book.colors.%s.name", color), "spelled:ancient_knowledge_tome").setSecret(true).setAdvancement("spelled:adjective_" + color).addTextPage(String.format("info.spelled.book.colors.%s.text", color)).build().build();
        }
        builder = colorCategory.build();
        return builder;
    }

    public BookBuilder addSizes(BookBuilder builder) {
        String[] sizes;
        CategoryBuilder sizeCategory = builder.addCategory("size", "info.spelled.book.size.name", "info.spelled.book.size.desc", "spelled:ancient_knowledge_tome").setSecret(Boolean.valueOf(true));
        for (String size : sizes = new String[]{"parvus", "magnum", "grandis", "immanis"}) {
            EntryBuilder sizeEntry = sizeCategory.addEntry("size/" + size, String.format("info.spelled.book.size.%s.name", size), "spelled:ancient_knowledge_tome").setSecret(true).setAdvancement("spelled:adjective_" + size).addTextPage(String.format("info.spelled.book.size.%s.text", size)).build();
            if (!size.equals("magnum")) {
                sizeEntry.addTextPage(String.format("info.spelled.book.size.%s.text2", size)).build().build();
            }
            sizeCategory = sizeEntry.build();
        }
        builder = sizeCategory.build();
        return builder;
    }

    public BookBuilder addDescriptions(BookBuilder builder) {
        String[] descriptions;
        CategoryBuilder descriptionCategory = builder.addCategory("descriptions", "info.spelled.book.descriptive.name", "info.spelled.book.descriptive.desc", "spelled:ancient_knowledge_tome").setSecret(Boolean.valueOf(true));
        for (String descriptive : descriptions = new String[]{"liquidus", "nix", "frigus", "dissiliunt", "sanitatem", "nocere", "praesidium", "fractionis", "propellentibus", "ignis", "vis", "sericum", "maturis"}) {
            EntryBuilder descriptiveEntry = descriptionCategory.addEntry("descriptive/" + descriptive, String.format("info.spelled.book.descriptive.%s.name", descriptive), "spelled:ancient_knowledge_tome").setSecret(true).setAdvancement("spelled:adjective_" + descriptive).addTextPage(String.format("info.spelled.book.descriptive.%s.text", descriptive)).build();
            if (!descriptive.equals("frigus")) {
                descriptiveEntry.addTextPage(String.format("info.spelled.book.descriptive.%s.text2", descriptive)).build();
            }
            descriptionCategory = descriptiveEntry.build();
        }
        builder = descriptionCategory.build();
        return builder;
    }
}

