/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.generator.data;

import com.mrbysco.spelled.registry.SpelledRegistry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;

public class SpelledAdvancements
extends ForgeAdvancementProvider {
    private static final List<ForgeAdvancementProvider.AdvancementGenerator> subproviders = List.of(new SpelledAdvancementGenerator());

    public SpelledAdvancements(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(packOutput, registries, existingFileHelper, subproviders);
    }

    public static class SpelledAdvancementGenerator
    implements ForgeAdvancementProvider.AdvancementGenerator {
        public Advancement root;
        public Advancement color_lore;
        public Advancement ater;
        public Advancement aureus;
        public Advancement caeruleus;
        public Advancement viridis;
        public Advancement aqua;
        public Advancement rubrum;
        public Advancement roseus;
        public Advancement flavus;
        public Advancement albus;
        public Advancement parvus;
        public Advancement magnum;
        public Advancement grandis;
        public Advancement immanis;
        public Advancement liquidus;
        public Advancement nix;
        public Advancement frigus;
        public Advancement dissiliunt;
        public Advancement sanitatem;
        public Advancement nocere;
        public Advancement praesidium;
        public Advancement fractionis;
        public Advancement propellentibus;
        public Advancement ignis;
        public Advancement vis;
        public Advancement sericum;
        public Advancement maturis;

        public void generate(HolderLookup.Provider registries, Consumer<Advancement> consumer, ExistingFileHelper existingFileHelper) {
            this.root = Advancement.Builder.m_138353_().m_138371_((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get(), (Component)Component.m_237115_((String)"advancement.spelled.root"), (Component)Component.m_237115_((String)"advancement.spelled.root.desc"), new ResourceLocation("minecraft:textures/block/bookshelf.png"), FrameType.TASK, true, false, false).m_138386_("air", (CriterionTriggerInstance)EnterBlockTrigger.TriggerInstance.m_31297_((Block)Blocks.f_50016_)).m_138389_(consumer, "spelled:root");
            this.color_lore = Advancement.Builder.m_138353_().m_138371_((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get(), (Component)Component.m_237115_((String)"advancement.spelled.color_lore"), (Component)Component.m_237115_((String)"advancement.spelled.color_lore.desc"), null, FrameType.TASK, false, false, false).m_138398_(this.root).m_138386_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, "spelled:color_lore");
            this.ater = this.generateAdjectiveAdvancement("ater", this.color_lore, consumer);
            this.aureus = this.generateAdjectiveAdvancement("aureus", this.ater, consumer);
            this.caeruleus = this.generateAdjectiveAdvancement("caeruleus", this.aureus, consumer);
            this.viridis = this.generateAdjectiveAdvancement("viridis", this.caeruleus, consumer);
            this.aqua = this.generateAdjectiveAdvancement("aqua", this.viridis, consumer);
            this.rubrum = this.generateAdjectiveAdvancement("rubrum", this.aqua, consumer);
            this.roseus = this.generateAdjectiveAdvancement("roseus", this.rubrum, consumer);
            this.flavus = this.generateAdjectiveAdvancement("flavus", this.roseus, consumer);
            this.albus = this.generateAdjectiveAdvancement("albus", this.flavus, consumer);
            this.parvus = this.generateAdjectiveAdvancement("parvus", this.root, consumer);
            this.magnum = this.generateAdjectiveAdvancement("magnum", this.parvus, consumer);
            this.grandis = this.generateAdjectiveAdvancement("grandis", this.magnum, consumer);
            this.immanis = this.generateAdjectiveAdvancement("immanis", this.grandis, consumer);
            this.liquidus = this.generateAdjectiveAdvancement("liquidus", this.root, consumer);
            this.nix = this.generateAdjectiveAdvancement("nix", this.liquidus, consumer);
            this.frigus = this.generateAdjectiveAdvancement("frigus", this.nix, consumer);
            this.dissiliunt = this.generateAdjectiveAdvancement("dissiliunt", this.frigus, consumer);
            this.sanitatem = this.generateAdjectiveAdvancement("sanitatem", this.dissiliunt, consumer);
            this.nocere = this.generateAdjectiveAdvancement("nocere", this.sanitatem, consumer);
            this.praesidium = this.generateAdjectiveAdvancement("praesidium", this.nocere, consumer);
            this.fractionis = this.generateAdjectiveAdvancement("fractionis", this.praesidium, consumer);
            this.propellentibus = this.generateAdjectiveAdvancement("propellentibus", this.fractionis, consumer);
            this.ignis = this.generateAdjectiveAdvancement("ignis", this.propellentibus, consumer);
            this.vis = this.generateAdjectiveAdvancement("vis", this.fractionis, consumer);
            this.sericum = this.generateAdjectiveAdvancement("sericum", this.vis, consumer);
            this.maturis = this.generateAdjectiveAdvancement("maturis", this.praesidium, consumer);
        }

        private Advancement generateAdjectiveAdvancement(String adjective, Advancement parent, Consumer<Advancement> consumer) {
            return Advancement.Builder.m_138353_().m_138371_((ItemLike)SpelledRegistry.KNOWLEDGE_TOME.get(), (Component)Component.m_237115_((String)String.format("advancement.spelled.%s", adjective)), (Component)Component.m_237115_((String)String.format("advancement.spelled.%s.desc", adjective)), null, FrameType.TASK, false, false, false).m_138398_(parent).m_138386_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138389_(consumer, "spelled:adjective_" + adjective);
        }
    }
}

