/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.generator;

import com.mrbysco.spelled.generator.assets.SpelledLanguageProvider;
import com.mrbysco.spelled.generator.data.SpelledAdvancements;
import com.mrbysco.spelled.generator.data.SpelledDamageTypeProvider;
import com.mrbysco.spelled.generator.data.SpelledLootProvider;
import com.mrbysco.spelled.generator.data.SpelledPatchouliProvider;
import com.mrbysco.spelled.generator.data.SpelledRecipes;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpelledDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new SpelledLootProvider(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new SpelledRecipes(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new SpelledAdvancements(packOutput, lookupProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new SpelledPatchouliProvider(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(SpelledDataGen::getProvider), Set.of("spelled")));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeServer(), (DataProvider)new SpelledLanguageProvider(packOutput));
        }
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_268580_, SpelledDamageTypeProvider::bootstrap);
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }
}

