/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.entity;

import com.mrbysco.spelled.api.behavior.BehaviorRegistry;
import com.mrbysco.spelled.api.behavior.ISpellBehavior;
import com.mrbysco.spelled.entity.AbstractSpellEntity;
import com.mrbysco.spelled.registry.SpelledRegistry;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.PlayMessages;

public class SpellEntity
extends AbstractSpellEntity {
    public SpellEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SpellEntity(LivingEntity shooter, Level level) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)SpelledRegistry.SPELL.get()), shooter, level);
    }

    public SpellEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends AbstractHurtingProjectile>)((EntityType)SpelledRegistry.SPELL.get()), level);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_(this.m_5967_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0, 0.0, 0.0);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult entityResult) {
        super.m_5790_(entityResult);
        Entity hitEntity = entityResult.m_82443_();
        this.handleEntityHit(hitEntity);
    }

    public void handleEntityHit(Entity hitEntity) {
        List<Entity> rangedEntities = this.getRangedEntities(hitEntity);
        HashMap<String, ISpellBehavior> behaviors = BehaviorRegistry.instance().getBehaviors();
        for (int i = 0; i < this.getSpellOrder().m_128440_(); ++i) {
            String action = this.getSpellOrder().m_128461_(String.valueOf(i));
            ISpellBehavior behavior = behaviors.get(action);
            if (behavior == null) continue;
            if (behavior.appliedMultiple()) {
                for (Entity entity : rangedEntities) {
                    behavior.onEntityHit(this, entity);
                }
                continue;
            }
            behavior.onEntityHit(this, hitEntity);
        }
    }

    protected void m_8060_(BlockHitResult blockResult) {
        super.m_8060_(blockResult);
        BlockPos pos = blockResult.m_82425_();
        List<BlockPos> multiplePos = this.getSizedPos(pos);
        HashMap<String, ISpellBehavior> behaviors = BehaviorRegistry.instance().getBehaviors();
        for (int i = 0; i < this.getSpellOrder().m_128440_(); ++i) {
            String action = this.getSpellOrder().m_128461_(String.valueOf(i));
            ISpellBehavior behavior = behaviors.get(action);
            if (behavior == null) continue;
            if (behavior.appliedMultiple()) {
                for (BlockPos boxPos : multiplePos) {
                    behavior.onBlockHit(this, boxPos, boxPos.m_121945_(blockResult.m_82434_()));
                }
                continue;
            }
            behavior.onBlockHit(this, pos, pos.m_121945_(blockResult.m_82434_()));
        }
    }
}

