/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.entity;

import com.mrbysco.spelled.registry.SpelledRegistry;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractSpellEntity
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<CompoundTag> SPELL_ORDER = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Integer> SPELL_TYPE = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<OptionalInt> COLOR = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private static final EntityDataAccessor<Boolean> FIERY = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LAVA = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WATER = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> COLD = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SNOW = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SMOKY = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INKY = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SILKY = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SIZE_MULTIPLIER = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> POWER = SynchedEntityData.m_135353_(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AbstractSpellEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public AbstractSpellEntity(EntityType<? extends AbstractHurtingProjectile> entityType, LivingEntity shooter, Level level) {
        super((EntityType)SpelledRegistry.SPELL.get(), level);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_ORDER, (Object)new CompoundTag());
        this.f_19804_.m_135372_(SPELL_TYPE, (Object)0);
        this.f_19804_.m_135372_(COLOR, (Object)OptionalInt.empty());
        this.f_19804_.m_135372_(FIERY, (Object)false);
        this.f_19804_.m_135372_(LAVA, (Object)false);
        this.f_19804_.m_135372_(WATER, (Object)false);
        this.f_19804_.m_135372_(COLD, (Object)false);
        this.f_19804_.m_135372_(SNOW, (Object)false);
        this.f_19804_.m_135372_(SMOKY, (Object)false);
        this.f_19804_.m_135372_(INKY, (Object)false);
        this.f_19804_.m_135372_(SILKY, (Object)false);
        this.f_19804_.m_135372_(SIZE_MULTIPLIER, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(POWER, (Object)0);
    }

    public void setSpellOrder(CompoundTag order) {
        this.m_20088_().m_135381_(SPELL_ORDER, (Object)order);
    }

    public void insertAction(String action) {
        CompoundTag order;
        order.m_128359_((order = this.getSpellOrder()).m_128456_() ? String.valueOf(0) : String.valueOf(order.m_128440_()), action);
        this.setSpellOrder(order);
    }

    public CompoundTag getSpellOrder() {
        return (CompoundTag)this.m_20088_().m_135370_(SPELL_ORDER);
    }

    public void setSpellType(int type) {
        this.m_20088_().m_135381_(SPELL_TYPE, (Object)type);
    }

    public int getSpellType() {
        return (Integer)this.m_20088_().m_135370_(SPELL_TYPE);
    }

    public void setColor(int color) {
        this.m_20088_().m_135381_(COLOR, (Object)OptionalInt.of(color));
    }

    public OptionalInt getColor() {
        return (OptionalInt)this.m_20088_().m_135370_(COLOR);
    }

    public boolean hasColor() {
        return ((OptionalInt)this.m_20088_().m_135370_(COLOR)).isPresent();
    }

    public void setFiery(boolean fiery) {
        this.m_20088_().m_135381_(FIERY, (Object)fiery);
    }

    public boolean isFiery() {
        return (Boolean)this.m_20088_().m_135370_(FIERY);
    }

    public void setLava(boolean lava) {
        this.m_20088_().m_135381_(LAVA, (Object)lava);
    }

    public boolean isLava() {
        return (Boolean)this.m_20088_().m_135370_(LAVA);
    }

    public void setWater(boolean water) {
        this.m_20088_().m_135381_(WATER, (Object)water);
    }

    public boolean isWater() {
        return (Boolean)this.m_20088_().m_135370_(WATER);
    }

    public void setCold(boolean cold) {
        this.m_20088_().m_135381_(COLD, (Object)cold);
    }

    public boolean isCold() {
        return (Boolean)this.m_20088_().m_135370_(COLD);
    }

    public void setSnow(boolean snow) {
        this.m_20088_().m_135381_(SNOW, (Object)snow);
    }

    public boolean isSnow() {
        return (Boolean)this.m_20088_().m_135370_(SNOW);
    }

    public void setSmoky(boolean smoky) {
        this.m_20088_().m_135381_(SMOKY, (Object)smoky);
    }

    public boolean isSmoky() {
        return (Boolean)this.m_20088_().m_135370_(SMOKY);
    }

    public void setInky(boolean inky) {
        this.m_20088_().m_135381_(INKY, (Object)inky);
    }

    public boolean isInky() {
        return (Boolean)this.m_20088_().m_135370_(INKY);
    }

    public void setSilky(boolean snow) {
        this.m_20088_().m_135381_(SILKY, (Object)snow);
    }

    public boolean isSilky() {
        return (Boolean)this.m_20088_().m_135370_(SILKY);
    }

    public void setSizeMultiplier(float sizeMultiplier) {
        this.m_20088_().m_135381_(SIZE_MULTIPLIER, (Object)Float.valueOf(sizeMultiplier));
        this.m_20090_();
        this.m_6210_();
    }

    public float getSizeMultiplier() {
        return ((Float)this.m_20088_().m_135370_(SIZE_MULTIPLIER)).floatValue();
    }

    public float getSizeMultiplier(float max) {
        float sizeMultiplier = this.getSizeMultiplier();
        return sizeMultiplier <= max ? sizeMultiplier : max;
    }

    public void setPower(int power) {
        this.m_20088_().m_135381_(POWER, (Object)power);
    }

    public int getPower() {
        return (Integer)this.m_20088_().m_135370_(POWER);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (SIZE_MULTIPLIER.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(this.getSizeMultiplier(8.0f));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("SpellOrder", 10)) {
            this.setSpellOrder(compound.m_128469_("SpellOrder"));
        }
        if (compound.m_128441_("colorPresent")) {
            this.setColor(compound.m_128451_("Color"));
        }
        this.setFiery(compound.m_128471_("Fiery"));
        this.setLava(compound.m_128471_("Lava"));
        this.setWater(compound.m_128471_("Water"));
        this.setCold(compound.m_128471_("Cold"));
        this.setSnow(compound.m_128471_("Snow"));
        this.setSmoky(compound.m_128471_("Smoky"));
        this.setInky(compound.m_128471_("Inky"));
        this.setSilky(compound.m_128471_("Silky"));
        this.setSizeMultiplier(compound.m_128457_("SizeMultiplier"));
        this.setPower(compound.m_128451_("PowerAdditive"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (!this.getSpellOrder().m_128456_()) {
            compound.m_128365_("SpellOrder", (Tag)this.getSpellOrder());
        }
        compound.m_128379_("colorPresent", this.hasColor());
        if (this.hasColor()) {
            compound.m_128405_("Color", this.getColor().getAsInt());
        }
        compound.m_128379_("Fiery", this.isFiery());
        compound.m_128379_("Lava", this.isLava());
        compound.m_128379_("Water", this.isWater());
        compound.m_128379_("Cold", this.isCold());
        compound.m_128379_("Snow", this.isSnow());
        compound.m_128379_("Smoky", this.isSmoky());
        compound.m_128379_("Inky", this.isInky());
        compound.m_128379_("Silky", this.isSilky());
        compound.m_128350_("SizeMultiplier", this.getSizeMultiplier());
        compound.m_128405_("PowerAdditive", this.getPower());
    }

    protected boolean m_5931_() {
        return this.isFiery();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected ParticleOptions m_5967_() {
        if (this.isLava() && (this.isCold() || this.isSnow() || this.isWater())) {
            return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_());
        }
        if (this.isWater() || this.isFiery() && this.isSnow()) {
            return ParticleTypes.f_123803_;
        }
        if (this.isSmoky()) {
            return ParticleTypes.f_123762_;
        }
        if (this.isInky()) {
            return ParticleTypes.f_123765_;
        }
        if (this.isFiery()) {
            return ParticleTypes.f_123744_;
        }
        if (this.isSnow()) {
            return ParticleTypes.f_123754_;
        }
        return ParticleTypes.f_123771_;
    }

    public float m_213856_() {
        return this.isFiery() || this.isLava() ? 1.0f : 0.5f;
    }

    public void m_8119_() {
        if (this.f_19797_ > 200) {
            this.m_146870_();
        }
        if (this.isCold() || this.isWater()) {
            HitResult result;
            Entity entity = this.m_19749_();
            if ((this.m_9236_().f_46443_ || (entity == null || entity.m_6084_()) && this.m_9236_().m_46805_(this.m_20183_())) && (result = this.rayTraceWater(x$0 -> this.m_5603_((Entity)x$0))).m_6662_() != HitResult.Type.MISS) {
                this.m_6532_(result);
            }
        }
        Vec3 vector3d = this.m_20184_();
        this.m_37283_();
        this.m_20256_(vector3d.m_82490_((double)0.99f));
        if (!this.m_20068_()) {
            Vec3 vector3d1 = this.m_20184_();
            this.m_20334_(vector3d1.f_82479_, vector3d1.f_82480_ - (double)0.02f, vector3d1.f_82481_);
        }
        super.m_8119_();
    }

    public HitResult rayTraceWater(Predicate<Entity> entityPredicate) {
        EntityHitResult result;
        Vec3 vector3d2;
        Vec3 position;
        Vec3 deltaMovement = this.m_20184_();
        Level level = this.m_9236_();
        BlockHitResult raytraceresult = level.m_45547_(new ClipContext(position = this.m_20182_(), vector3d2 = position.m_82549_(deltaMovement), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vector3d2 = raytraceresult.m_82450_();
        }
        if ((result = ProjectileUtil.m_37304_((Level)level, (Entity)this, (Vec3)position, (Vec3)vector3d2, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), entityPredicate)) != null) {
            raytraceresult = result;
        }
        return raytraceresult;
    }

    public void explode() {
        boolean flag = !this.isSnow() && !this.isWater() && this.isFiery();
        int size = (int)Math.ceil(1.0f * this.getSizeMultiplier(16.0f));
        this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)size, flag, flag ? Level.ExplosionInteraction.NONE : Level.ExplosionInteraction.BLOCK);
    }

    public List<BlockPos> getSizedPos(BlockPos pos) {
        if (this.getSizeMultiplier() > 1.0f) {
            int offset = Math.round(this.getSizeMultiplier(16.0f) * 0.5f);
            List<BlockPos> positionList = BlockPos.m_121990_((BlockPos)pos.m_7918_(-offset, -offset, -offset), (BlockPos)pos.m_7918_(offset, offset, offset)).map(BlockPos::m_7949_).collect(Collectors.toList());
            return positionList;
        }
        return Collections.singletonList(pos);
    }

    public List<Entity> getRangedEntities(Entity hitEntity) {
        if (this.getSizeMultiplier() > 1.0f) {
            double offset = this.getSizeMultiplier(16.0f);
            AABB hitbox = new AABB(hitEntity.m_20185_() - 0.5, hitEntity.m_20186_() - 0.5, hitEntity.m_20189_() - 0.5, hitEntity.m_20185_() + 0.5, hitEntity.m_20186_() + 0.5, hitEntity.m_20189_() + 0.5).m_82363_(-offset, -offset, -offset).m_82363_(offset, offset, offset);
            return this.m_9236_().m_6249_((Entity)this, hitbox, Entity::m_6084_);
        }
        return Collections.singletonList(hitEntity);
    }
}

