/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.config.SpelledConfig;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SpelledCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.m_82127_((String)"spelled");
        ArrayList<String> adjectives = KeywordRegistry.instance().getAdjectives();
        adjectives.add("all");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"level").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"get").executes(SpelledCommands::getLevel))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(SpelledCommands::setLevel)))))).then(Commands.m_82127_((String)"knowledge").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"word", (ArgumentType)StringArgumentType.string()).suggests((cs, builder) -> SharedSuggestionProvider.m_82970_(SpelledCommands.getAdjectivesPlusAll(), (SuggestionsBuilder)builder)).executes(SpelledCommands::unlockWord)))).then(Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"word", (ArgumentType)StringArgumentType.string()).suggests((cs, builder) -> SharedSuggestionProvider.m_82970_(SpelledCommands.getAdjectivesPlusAll(), (SuggestionsBuilder)builder)).executes(SpelledCommands::lockWord)))).then(Commands.m_82127_((String)"reset").executes(SpelledCommands::resetWords))));
        dispatcher.register(root);
    }

    protected static ArrayList<String> getAdjectivesPlusAll() {
        ArrayList<String> adjectives = new ArrayList<String>(KeywordRegistry.instance().getAdjectives());
        adjectives.add("all");
        return adjectives;
    }

    private static int getLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            int level = SpelledAPI.getLevel((Player)player);
            if (level < 0) continue;
            MutableComponent levelText = Component.m_237113_((String)String.valueOf(level)).m_130940_(ChatFormatting.GOLD);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> SpelledCommands.lambda$getLevel$3(player, (Component)levelText), false);
        }
        return 0;
    }

    private static int setLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        if (level >= 0 && level <= (Integer)SpelledConfig.COMMON.maxLevel.get()) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
                SpelledAPI.forceSetLevel((Player)player, level);
                SpelledAPI.syncCap(player);
                MutableComponent levelText = Component.m_237113_((String)String.valueOf(level)).m_130940_(ChatFormatting.GOLD);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> SpelledCommands.lambda$setLevel$4(player, (Component)levelText), true);
            }
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"spelled.commands.level.set.invalid", (Object[])new Object[]{level, SpelledConfig.COMMON.maxLevel.get()}).m_130940_(ChatFormatting.RED), true);
        }
        return 0;
    }

    private static int unlockWord(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String word = StringArgumentType.getString(ctx, (String)"word").toLowerCase(Locale.ROOT);
        if (!word.isEmpty()) {
            if (word.equals("all")) {
                for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
                    ArrayList<String> adjectives = KeywordRegistry.instance().getAdjectives();
                    for (String adjective : adjectives) {
                        SpelledAPI.unlockKeyword((Player)player, adjective);
                    }
                    SpelledAPI.syncCap(player);
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"spelled.commands.knowledge.unlock.all", (Object[])new Object[]{player.m_5446_()}), true);
                }
            } else if (KeywordRegistry.instance().containsKey(word)) {
                for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
                    SpelledAPI.unlockKeyword((Player)player, word);
                    SpelledAPI.syncCap(player);
                    MutableComponent wordComponent = Component.m_237113_((String)word).m_130940_(ChatFormatting.GOLD);
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> SpelledCommands.lambda$unlockWord$7((Component)wordComponent, player), true);
                }
            }
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"spelled.commands.knowledge.unlock.invalid", (Object[])new Object[]{word}).m_130940_(ChatFormatting.RED), true);
        }
        return 0;
    }

    private static int lockWord(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String word = StringArgumentType.getString(ctx, (String)"word").toLowerCase(Locale.ROOT);
        if (!word.isEmpty()) {
            if (word.equals("all")) {
                for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
                    SpelledAPI.resetUnlocks((Player)player);
                    SpelledAPI.syncCap(player);
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"spelled.commands.knowledge.reset.message", (Object[])new Object[]{player.m_5446_()}), true);
                }
            } else if (KeywordRegistry.instance().containsKey(word)) {
                for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
                    SpelledAPI.lockKeyword((Player)player, word);
                    SpelledAPI.syncCap(player);
                    MutableComponent wordComponent = Component.m_237113_((String)word).m_130940_(ChatFormatting.GOLD);
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> SpelledCommands.lambda$lockWord$10((Component)wordComponent, player), true);
                }
            }
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"spelled.commands.knowledge.lock.invalid", (Object[])new Object[]{word}).m_130940_(ChatFormatting.RED), true);
        }
        return 0;
    }

    private static int resetWords(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            SpelledAPI.resetUnlocks((Player)player);
            SpelledAPI.syncCap(player);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"spelled.commands.knowledge.reset.message", (Object[])new Object[]{player.m_5446_()}), true);
        }
        return 0;
    }

    private static /* synthetic */ Component lambda$lockWord$10(Component wordComponent, ServerPlayer player) {
        return Component.m_237110_((String)"spelled.commands.knowledge.lock.message", (Object[])new Object[]{wordComponent, player.m_5446_()});
    }

    private static /* synthetic */ Component lambda$unlockWord$7(Component wordComponent, ServerPlayer player) {
        return Component.m_237110_((String)"spelled.commands.knowledge.unlock.message", (Object[])new Object[]{wordComponent, player.m_5446_()});
    }

    private static /* synthetic */ Component lambda$setLevel$4(ServerPlayer player, Component levelText) {
        return Component.m_237110_((String)"spelled.commands.level.set.message", (Object[])new Object[]{player.m_5446_(), levelText});
    }

    private static /* synthetic */ Component lambda$getLevel$3(ServerPlayer player, Component levelText) {
        return Component.m_237110_((String)"spelled.commands.level.get.message", (Object[])new Object[]{player.m_5446_(), levelText});
    }
}

