/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrbysco.spelled.entity.SpellEntity;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SpellRenderer
extends EntityRenderer<SpellEntity> {
    private static final ResourceLocation PROJECTILE_TEXTURE = new ResourceLocation("spelled", "textures/item/projectile.png");
    private static final ResourceLocation BALL_TEXTURE = new ResourceLocation("spelled", "textures/item/ball.png");
    private static final ResourceLocation LAVA_TEXTURE = new ResourceLocation("spelled", "textures/item/lava_ball.png");
    private static final ResourceLocation WATER_TEXTURE = new ResourceLocation("spelled", "textures/item/water_ball.png");
    private static final RenderType renderType = RenderType.m_110458_((ResourceLocation)BALL_TEXTURE);
    private static Color color = null;

    public SpellRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected int getBlockLightLevel(SpellEntity entityIn, BlockPos partialTicks) {
        return 15;
    }

    public void render(SpellEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.m_85836_();
        this.preRenderCallback(entityIn, poseStack, partialTicks);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose last = poseStack.m_85850_();
        Matrix4f pose = last.m_252922_();
        Matrix3f normal = last.m_252943_();
        VertexConsumer buffer = bufferIn.m_6299_(renderType);
        SpellRenderer.vertex(buffer, pose, normal, packedLightIn, 0.0f, 0, 0, 1);
        SpellRenderer.vertex(buffer, pose, normal, packedLightIn, 1.0f, 0, 1, 1);
        SpellRenderer.vertex(buffer, pose, normal, packedLightIn, 1.0f, 1, 1, 0);
        SpellRenderer.vertex(buffer, pose, normal, packedLightIn, 0.0f, 1, 0, 0);
        poseStack.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    private static void vertex(VertexConsumer vertexBuilder, Matrix4f pose, Matrix3f normal, int packedLightIn, float p_229045_4_, int p_229045_5_, int p_229045_6_, int p_229045_7_) {
        vertexBuilder.m_252986_(pose, p_229045_4_ - 0.5f, (float)p_229045_5_ - 0.25f, 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_((float)p_229045_6_, (float)p_229045_7_).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    protected void preRenderCallback(SpellEntity entityIn, PoseStack poseStack, float partialTickTime) {
        float sizeMultiplier;
        if (color == null) {
            color = new Color(255, 255, 255, 255);
        }
        if (entityIn.hasColor() && !color.equals(new Color(entityIn.getColor().getAsInt()))) {
            color = new Color(entityIn.getColor().getAsInt());
        }
        if ((sizeMultiplier = entityIn.getSizeMultiplier() / 2.0f) > 8.0f) {
            sizeMultiplier = 8.0f;
        }
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        poseStack.m_85837_(0.0, (double)0.001f, 0.0);
        float f3 = 1.0f;
        poseStack.m_85841_(f3 * sizeMultiplier, f3 * sizeMultiplier, f3 * sizeMultiplier);
    }

    public ResourceLocation getTextureLocation(SpellEntity entity) {
        if (entity.isWater()) {
            return WATER_TEXTURE;
        }
        if (entity.isLava()) {
            return LAVA_TEXTURE;
        }
        if (entity.getSpellType() == 1) {
            return PROJECTILE_TEXTURE;
        }
        return BALL_TEXTURE;
    }
}

