/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.client.gui.book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.spelled.client.gui.book.AdjectiveEntry;
import com.mrbysco.spelled.client.gui.book.AdjectiveListWidget;
import com.mrbysco.spelled.packets.PacketHandler;
import com.mrbysco.spelled.packets.SignSpellPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.StringUtils;

public class SpellBookScreen
extends Screen {
    private static final ResourceLocation STATS_ICON_LOCATION = new ResourceLocation("textures/gui/container/stats_icons.png");
    private static final Component EDIT_TITLE_LABEL = Component.m_237115_((String)"spelled.book.editTitle");
    private static final Component FINALIZE_WARNING_LABEL = Component.m_237115_((String)"spelled.book.finalizeWarning");
    private static final FormattedCharSequence GRAY_CURSOR = FormattedCharSequence.m_13714_((String)"_", (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY));
    private static final FormattedCharSequence WHITE_CURSOR = FormattedCharSequence.m_13714_((String)"_", (Style)Style.f_131099_.m_131140_(ChatFormatting.WHITE));
    private static final int PADDING = 6;
    private final List<String> selectedAdjectives = new ArrayList<String>();
    private String typeWord = "";
    private AdjectiveListWidget adjectiveWidget;
    private AdjectiveListWidget.ListEntry focused = null;
    private final List<AdjectiveEntry> unsortedAdjectives;
    private List<AdjectiveEntry> adjectives;
    private Button insertButton;
    private Button removeButton;
    private Button signButton;
    private Button finalizeButton;
    private Button cancelButton;
    private String title = "";
    private final TextFieldHelper titleEdit = new TextFieldHelper(() -> this.title, message -> {
        this.title = message;
    }, this::getClipboard, this::setClipboard, message -> message.length() < 32);
    private final int buttonMargin = 1;
    private final int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private EditBox search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;
    private final Player owner;
    private final InteractionHand hand;
    private final ItemStack stack;
    private boolean isSigning;
    private boolean isModified;
    private int frameTick;
    private final Component ownerText;

    public SpellBookScreen(List<AdjectiveEntry> entries, Player player, InteractionHand hand) {
        super((Component)Component.m_237115_((String)"spelled.spell_book.screen"));
        this.hand = hand;
        this.owner = player;
        this.stack = player.m_21120_(hand);
        ArrayList<AdjectiveEntry> sortedEntries = new ArrayList<AdjectiveEntry>(entries);
        Collections.sort(sortedEntries);
        this.unsortedAdjectives = Collections.unmodifiableList(sortedEntries);
        this.adjectives = Collections.unmodifiableList(entries);
        this.ownerText = Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{player.m_7755_()}).m_130940_(ChatFormatting.GRAY);
        if (this.stack.m_41782_()) {
            String currentSpell = this.stack.m_41783_().m_128461_("spell");
            String[] words = currentSpell.split(" ");
            List<String> wordList = Arrays.asList(words);
            String type = wordList.get(wordList.size() - 1);
            wordList = wordList.subList(0, wordList.size() - 1);
            this.selectedAdjectives.addAll(wordList);
            this.typeWord = type;
        }
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        int centerWidth = this.f_96543_ / 2;
        int listWidth = 0;
        for (AdjectiveEntry adjectiveEntry : this.adjectives) {
            listWidth = Math.max(listWidth, this.getFont().m_92895_(adjectiveEntry.getAdjectiveName()) + 10);
        }
        int structureWidth = this.f_96543_ - (listWidth += (listWidth = Math.max(Math.min(listWidth, this.f_96543_ / 3), 200)) % this.numButtons != 0 ? this.numButtons - listWidth % this.numButtons : 0) - 18;
        int closeButtonWidth = Math.min(structureWidth, 200);
        int y = this.f_96544_ - 20 - 6;
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> {
            if (this.isSigning) {
                this.isSigning = false;
            } else {
                this.m_7379_();
            }
            this.updateButtonVisibility();
        }).m_252987_(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20).m_253136_());
        this.insertButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"spelled.screen.selection.select"), button -> {
            if (this.focused != null) {
                if (this.focused.isType()) {
                    this.typeWord = this.focused.getAdjectiveName();
                } else {
                    this.selectedAdjectives.add(this.focused.getAdjectiveName());
                }
            }
        }).m_252987_(centerWidth - closeButtonWidth / 2 + 6, y -= 24, closeButtonWidth, 20).m_253136_());
        this.removeButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"spelled.screen.selection.remove"), button -> {
            if (this.selectedAdjectives.size() == 1) {
                this.selectedAdjectives.clear();
            } else if (!this.selectedAdjectives.isEmpty()) {
                this.selectedAdjectives.remove(this.selectedAdjectives.size() - 1);
            }
        }).m_252987_(centerWidth - closeButtonWidth / 2 + 6, y -= 24, closeButtonWidth, 20).m_253136_());
        this.search = new EditBox(this.getFont(), centerWidth - listWidth / 2 + 6 + 1, y -= 20, listWidth - 2, 14, (Component)Component.m_237115_((String)"spelled.screen.search"));
        int fullButtonHeight = 32;
        Objects.requireNonNull(this.getFont());
        this.adjectiveWidget = new AdjectiveListWidget(this, this.f_96543_, fullButtonHeight, (y -= 30) - 9 - 6);
        this.adjectiveWidget.m_93507_(0);
        this.m_7787_((GuiEventListener)this.search);
        this.m_7787_((GuiEventListener)this.adjectiveWidget);
        this.m_264313_((GuiEventListener)this.search);
        int width = listWidth / this.numButtons;
        int x = centerWidth + 6 - width;
        SortType.A_TO_Z.button = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)SortType.A_TO_Z.getButtonText(), button -> this.resortAdjectives(SortType.A_TO_Z)).m_252987_(x, 6, width - 1, 20).m_253136_());
        SortType.Z_TO_A.button = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)SortType.Z_TO_A.getButtonText(), button -> this.resortAdjectives(SortType.Z_TO_A)).m_252987_(x += width + 1, 6, width - 1, 20).m_253136_());
        this.signButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"spelled.book.finalizeButton"), button -> {
            this.isSigning = true;
            this.updateButtonVisibility();
        }).m_252987_(this.f_96543_ - 66, 6, 60, 20).m_253136_());
        this.finalizeButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"book.signButton"), button -> {
            if (this.isSigning) {
                this.saveChanges(true);
                this.f_96541_.m_91152_((Screen)null);
            }
        }).m_252987_(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20).m_253136_());
        this.updateButtonVisibility();
        this.resortAdjectives(SortType.A_TO_Z);
        this.updateCache();
    }

    private Component getFinalizeTooltip() {
        boolean flag = this.selectedAdjectives.isEmpty();
        boolean flag2 = this.typeWord.isEmpty();
        if (flag || flag2) {
            StringBuilder builder = new StringBuilder();
            if (flag) {
                builder.append(I18n.m_118938_((String)"spelled.screen.missing_adjectives", (Object[])new Object[0])).append(" ");
            }
            if (flag2) {
                builder.append(I18n.m_118938_((String)"spelled.screen.missing_type", (Object[])new Object[0]));
            }
            String errorMessage = builder.toString();
            return Component.m_237113_((String)errorMessage);
        }
        return Component.m_237119_();
    }

    private void updateButtonVisibility() {
        this.signButton.f_93624_ = !this.isSigning;
        this.insertButton.f_93624_ = !this.isSigning;
        this.removeButton.f_93624_ = !this.isSigning;
        this.finalizeButton.f_93624_ = this.isSigning;
        this.finalizeButton.f_93623_ = !this.title.trim().isEmpty();
        SortType.A_TO_Z.button.f_93624_ = !this.isSigning;
        SortType.Z_TO_A.button.f_93624_ = !this.isSigning;
    }

    public void m_86600_() {
        this.signButton.m_257544_(Tooltip.m_257550_((Component)this.getFinalizeTooltip()));
        super.m_86600_();
        ++this.frameTick;
        if (!this.isSigning) {
            this.signButton.f_93623_ = !this.selectedAdjectives.isEmpty() && !this.typeWord.isEmpty();
            this.search.m_94120_();
            this.adjectiveWidget.m_6987_((AbstractSelectionList.Entry)this.focused);
            if (!this.search.m_94155_().equals(this.lastFilterText)) {
                this.reloadAdjectives();
                this.sorted = false;
            }
            if (!this.sorted) {
                this.reloadAdjectives();
                if (this.sortType == SortType.A_TO_Z) {
                    Collections.sort(this.adjectives);
                } else if (this.sortType == SortType.Z_TO_A) {
                    this.adjectives.sort(Collections.reverseOrder());
                }
                this.adjectiveWidget.refreshList();
                if (this.focused != null) {
                    this.focused = this.adjectiveWidget.m_6702_().stream().filter(e -> e == this.focused).findFirst().orElse(null);
                    this.updateCache();
                }
                this.sorted = true;
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isSigning) {
            int i = (this.f_96543_ - 192) / 2;
            int j = this.f_96544_ / 2 - 100;
            boolean flag = this.frameTick / 6 % 2 == 0;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.m_13696_((FormattedCharSequence)FormattedCharSequence.m_13714_((String)this.title, (Style)Style.f_131099_), (FormattedCharSequence)(flag ? GRAY_CURSOR : WHITE_CURSOR));
            int k = this.f_96547_.m_92852_((FormattedText)EDIT_TITLE_LABEL);
            guiGraphics.m_280614_(this.f_96547_, EDIT_TITLE_LABEL, i + 36 + (114 - k) / 2, (int)(34.0f + (float)j), 0xFFFFFF, false);
            int l = this.f_96547_.m_92724_(formattedCharSequence);
            guiGraphics.drawString(this.f_96547_, formattedCharSequence, (float)(i + 36 + (114 - l) / 2), 50.0f + (float)j, 0xFFFFFF, false);
            int i1 = this.f_96547_.m_92852_((FormattedText)this.ownerText);
            guiGraphics.m_280614_(this.f_96547_, this.ownerText, i + 36 + (114 - i1) / 2, (int)(60.0f + (float)j), 0xFFFFFF, false);
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)FINALIZE_WARNING_LABEL, i + 36, 82 + j, 114, 0xFFFFFF);
        } else {
            this.adjectiveWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            MutableComponent text = Component.m_237115_((String)"spelled.screen.search");
            int n = this.f_96543_ / 2 + 6;
            int n2 = this.search.m_252907_();
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280653_(this.f_96547_, (Component)text, n, n2 - 9 - 2, 0xFFFFFF);
            this.search.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            guiGraphics.m_280614_(this.f_96547_, this.m_96636_(), 5, 5, 0xFFFFFF, false);
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 100.0f);
            RenderSystem.enableDepthTest();
            int itemX = this.f_96543_ / 2 - 2;
            int itemY = this.f_96544_ - 130;
            guiGraphics.m_280163_(STATS_ICON_LOCATION, itemX - 1, itemY - 1, 0.0f, 0.0f, 18, 18, 128, 128);
            guiGraphics.m_280480_(this.stack, itemX, itemY);
            guiGraphics.m_280302_(this.f_96547_, this.stack, itemX, itemY, null);
            RenderSystem.disableDepthTest();
            poseStack.m_85849_();
            if (this.isHovering(itemX - 16, itemY, itemX + 16, itemY + 24, mouseX, mouseY)) {
                boolean flag = this.selectedAdjectives.isEmpty();
                boolean flag2 = this.typeWord.isEmpty();
                StringBuilder builder = new StringBuilder();
                if (this.selectedAdjectives.isEmpty()) {
                    builder.append(I18n.m_118938_((String)"spelled.screen.missing_adjectives", (Object[])new Object[0])).append(" ");
                } else {
                    this.selectedAdjectives.forEach(adjective -> builder.append((String)adjective).append(" "));
                }
                MutableComponent component = Component.m_237113_((String)builder.toString());
                StringBuilder builder2 = new StringBuilder();
                if (this.typeWord.isEmpty()) {
                    builder2.append(I18n.m_118938_((String)"spelled.screen.missing_type", (Object[])new Object[0]));
                } else {
                    builder2.append(this.typeWord);
                }
                MutableComponent component2 = Component.m_237113_((String)builder2.toString());
                if (flag) {
                    component.m_130940_(ChatFormatting.RED);
                }
                if (flag2) {
                    component2.m_130940_(ChatFormatting.RED);
                }
                MutableComponent finalComponent = component.m_7220_((Component)component2);
                guiGraphics.m_280557_(this.f_96547_, (Component)finalComponent, mouseX, mouseY);
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected boolean isHovering(int x, int y, int x2, int y2, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX < (double)x2 && mouseY >= (double)y && mouseY <= (double)y2;
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildAdjectiveList(Consumer<T> ListViewConsumer, Function<AdjectiveEntry, T> newEntry) {
        this.adjectives.forEach(mod -> ListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((AdjectiveEntry)mod)));
    }

    private void reloadAdjectives() {
        this.lastFilterText = this.search.m_94155_();
        this.adjectives = this.unsortedAdjectives.stream().filter(word -> {
            boolean flag = StringUtils.toLowerCase((String)word.getAdjectiveName()).contains(StringUtils.toLowerCase((String)this.lastFilterText));
            boolean flag2 = StringUtils.toLowerCase((String)word.getAdjectiveDescription().getString()).contains(StringUtils.toLowerCase((String)this.lastFilterText));
            return flag || flag2;
        }).collect(Collectors.toList());
    }

    private void resortAdjectives(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.f_93623_ = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void setFocused(AdjectiveListWidget.ListEntry entry) {
        this.focused = entry == this.focused ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        this.insertButton.f_93623_ = this.focused != null;
    }

    public void m_6574_(Minecraft mc, int newWidth, int newHeight) {
        super.m_6574_(mc, newHeight, newHeight);
        String s = this.search.m_94155_();
        SortType sort = this.sortType;
        AdjectiveListWidget.ListEntry focused = this.focused;
        this.m_6575_(mc, newWidth, newHeight);
        this.search.m_94144_(s);
        this.focused = focused;
        if (!this.search.m_94155_().isEmpty()) {
            this.reloadAdjectives();
        }
        if (sort != SortType.NORMAL) {
            this.resortAdjectives(sort);
        }
        this.updateCache();
    }

    public void m_7379_() {
        super.m_7379_();
        this.f_96541_.m_91152_(null);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.m_91152_((Screen)null);
            return true;
        }
        if (this.isSigning) {
            return this.titleKeyPressed(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char keyCode, int modifiers) {
        if (super.m_5534_(keyCode, modifiers)) {
            return true;
        }
        if (this.isSigning) {
            boolean flag = this.titleEdit.m_95143_(keyCode);
            if (flag) {
                this.updateButtonVisibility();
                this.isModified = true;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean titleKeyPressed(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 257: 
            case 335: {
                if (!this.title.isEmpty()) {
                    this.saveChanges(true);
                    this.f_96541_.m_91152_((Screen)null);
                }
                return true;
            }
            case 259: {
                this.titleEdit.m_95189_(-1);
                this.updateButtonVisibility();
                this.isModified = true;
                return true;
            }
        }
        return false;
    }

    private void saveChanges(boolean finalize) {
        if (this.isModified) {
            StringBuilder builder = new StringBuilder();
            if (!this.selectedAdjectives.isEmpty()) {
                this.selectedAdjectives.forEach(adjective -> builder.append((String)adjective).append(" "));
            }
            builder.append(this.typeWord);
            this.stack.m_41700_("spell", (Tag)StringTag.m_129297_((String)builder.toString()));
            if (finalize) {
                this.stack.m_41700_("author", (Tag)StringTag.m_129297_((String)this.owner.m_36316_().getName()));
                this.stack.m_41700_("title", (Tag)StringTag.m_129297_((String)this.title.trim()));
            }
            int i = this.hand == InteractionHand.MAIN_HAND ? this.owner.m_150109_().f_35977_ : 40;
            PacketHandler.CHANNEL.sendToServer((Object)new SignSpellPacket(this.stack, finalize, i));
        }
    }

    private void setClipboard(String clipboard) {
        if (this.f_96541_ != null) {
            TextFieldHelper.m_95155_((Minecraft)this.f_96541_, (String)clipboard);
        }
    }

    private String getClipboard() {
        return this.f_96541_ != null ? TextFieldHelper.m_95169_((Minecraft)this.f_96541_) : "";
    }

    public void m_7861_() {
        super.m_7861_();
    }

    private static enum SortType {
        NORMAL,
        A_TO_Z,
        Z_TO_A;

        Button button;

        Component getButtonText() {
            return Component.m_237115_((String)("spelled.screen.search." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

