/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.block;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.blockentity.LevelingAltarBlockEntity;
import com.mrbysco.spelled.menu.AltarMenu;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LevelingAltarBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape FALLBACK = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)8.08182, (double)0.75, (double)7.423660000000002, (double)15.08182, (double)12.75, (double)8.423660000000002), Block.m_49796_((double)13.33182, (double)12.0, (double)7.173660000000002, (double)15.33182, (double)13.0, (double)8.673660000000002), Block.m_49796_((double)14.33182, (double)1.5, (double)7.173660000000002, (double)15.33182, (double)2.5, (double)8.673660000000002), Block.m_49796_((double)14.33182, (double)11.0, (double)7.173660000000002, (double)15.33182, (double)12.0, (double)8.673660000000002), Block.m_49796_((double)13.33182, (double)0.5, (double)7.173660000000002, (double)15.33182, (double)1.5, (double)8.673660000000002), Block.m_49796_((double)7.0, (double)0.5, (double)7.500000000000002, (double)9.0, (double)13.0, (double)8.500000000000002), Block.m_49796_((double)0.68804, (double)0.5, (double)7.273510000000002, (double)2.68804, (double)1.5, (double)8.773510000000002), Block.m_49796_((double)0.68804, (double)1.5, (double)7.273510000000002, (double)1.68804, (double)2.5, (double)8.773510000000002), Block.m_49796_((double)0.68804, (double)11.0, (double)7.273510000000002, (double)1.68804, (double)12.0, (double)8.773510000000002), Block.m_49796_((double)0.68804, (double)12.0, (double)7.273510000000002, (double)2.68804, (double)13.0, (double)8.773510000000002), Block.m_49796_((double)0.93804, (double)0.75, (double)7.523510000000002, (double)7.93804, (double)12.75, (double)8.523510000000002), Block.m_49796_((double)7.75, (double)1.5, (double)7.250000000000002, (double)8.25, (double)12.0, (double)7.500000000000002)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_2 = Stream.of(Block.m_49796_((double)7.492089999999999, (double)0.75, (double)0.9899700000000013, (double)8.49209, (double)12.75, (double)7.989970000000001), Block.m_49796_((double)7.242089999999999, (double)12.0, (double)0.7399700000000013, (double)8.74209, (double)13.0, (double)2.7399700000000013), Block.m_49796_((double)7.242089999999999, (double)1.5, (double)0.7399700000000013, (double)8.74209, (double)2.5, (double)1.7399700000000013), Block.m_49796_((double)7.242089999999999, (double)11.0, (double)0.7399700000000013, (double)8.74209, (double)12.0, (double)1.7399700000000013), Block.m_49796_((double)7.242089999999999, (double)0.5, (double)0.7399700000000013, (double)8.74209, (double)1.5, (double)2.7399700000000013), Block.m_49796_((double)7.568429999999999, (double)0.5, (double)7.071790000000002, (double)8.56843, (double)13.0, (double)9.071790000000002), Block.m_49796_((double)7.341939999999999, (double)0.5, (double)13.383750000000001, (double)8.84194, (double)1.5, (double)15.383750000000001), Block.m_49796_((double)7.341939999999999, (double)1.5, (double)14.383750000000001, (double)8.84194, (double)2.5, (double)15.383750000000001), Block.m_49796_((double)7.341939999999999, (double)11.0, (double)14.383750000000001, (double)8.84194, (double)12.0, (double)15.383750000000001), Block.m_49796_((double)7.341939999999999, (double)12.0, (double)13.383750000000001, (double)8.84194, (double)13.0, (double)15.383750000000001), Block.m_49796_((double)7.591939999999999, (double)0.75, (double)8.133750000000001, (double)8.59194, (double)12.75, (double)15.133750000000001), Block.m_49796_((double)7.318429999999999, (double)1.5, (double)7.821790000000002, (double)7.568429999999999, (double)12.0, (double)8.321790000000002)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public LevelingAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        if (SHAPE != null && SHAPE_2 != null) {
            return direction.m_122434_() == Direction.Axis.X ? SHAPE_2 : SHAPE;
        }
        return FALLBACK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        super.m_214162_(stateIn, level, pos, rand);
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (rand.m_188503_(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    BlockPos blockpos = pos.m_7918_(i, k, j);
                    if (!(level.m_8055_(blockpos).getEnchantPowerBonus((LevelReader)level, blockpos) > 0.0f)) continue;
                    if (!level.m_46859_(pos.m_7918_(i / 2, 0, j / 2))) continue block1;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5, (double)((float)i + rand.m_188501_()) - 0.5, (double)((float)k - rand.m_188501_() - 1.0f), (double)((float)j + rand.m_188501_()) - 0.5);
                }
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LevelingAltarBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(state.m_60750_(level, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LevelingAltarBlockEntity) {
            Component itextcomponent = ((Nameable)blockEntity).m_5446_();
            return new SimpleMenuProvider((id, inventory, player) -> {
                int playerLevel = level.f_46443_ ? 0 : SpelledAPI.getLevel((Player)((ServerPlayer)player));
                return new AltarMenu(id, inventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos), playerLevel);
            }, itextcomponent);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof LevelingAltarBlockEntity) {
            ((LevelingAltarBlockEntity)blockEntity).setCustomName(stack.m_41786_());
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, WATERLOGGED});
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.empty();
    }

    public boolean m_6044_(BlockGetter p_54766_, BlockPos p_54767_, BlockState p_54768_, Fluid p_54769_) {
        return false;
    }

    public boolean m_7361_(LevelAccessor p_54770_, BlockPos p_54771_, BlockState p_54772_, FluidState p_54773_) {
        return false;
    }
}

