/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.api.capability;

import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.api.capability.ISpellData;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class SpellDataCapability
implements ISpellData {
    private int level = 0;
    private CompoundTag unlockedKeywords = this.getDefaultUnlocks();
    private int castCooldown = 0;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public CompoundTag getUnlocked() {
        return this.unlockedKeywords;
    }

    @Override
    public void setUnlocked(CompoundTag nbt) {
        this.unlockedKeywords = nbt;
    }

    @Override
    public boolean knowsKeyword(String keyword) {
        return this.unlockedKeywords.m_128441_(keyword);
    }

    @Override
    public void unlockKeyword(String keyword) {
        this.unlockedKeywords.m_128379_(keyword.toLowerCase(Locale.ROOT), true);
    }

    @Override
    public void lockKeyword(String keyword) {
        KeywordRegistry registry = KeywordRegistry.instance();
        if (!registry.getTypes().contains(keyword)) {
            this.unlockedKeywords.m_128473_(keyword.toLowerCase(Locale.ROOT));
        }
    }

    @Override
    public int getCastCooldown() {
        return this.castCooldown;
    }

    @Override
    public void setCastCooldown(int cooldown) {
        this.castCooldown = cooldown;
    }

    @Override
    public void resetUnlocks() {
        this.unlockedKeywords = this.getDefaultUnlocks();
    }

    private CompoundTag getDefaultUnlocks() {
        KeywordRegistry registry = KeywordRegistry.instance();
        CompoundTag tag = new CompoundTag();
        registry.getTypes().forEach(type -> tag.m_128379_(type, true));
        return tag;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("CharacterLevel", this.getLevel());
        tag.m_128365_("CharacterUnlocks", (Tag)this.getUnlocked());
        tag.m_128405_("characterCooldown", this.getCastCooldown());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        int level = tag.m_128451_("CharacterLevel");
        CompoundTag characterUnlocks = tag.m_128469_("CharacterUnlocks");
        int castCooldown = tag.m_128451_("characterCooldown");
        this.setLevel(level);
        this.setUnlocked(characterUnlocks);
        this.setCastCooldown(castCooldown);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return SpelledAPI.SPELL_DATA_CAP.orEmpty(cap, LazyOptional.of(() -> this));
    }
}

