/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.mrbysco.spelled.api.behavior.BehaviorRegistry;
import com.mrbysco.spelled.api.capability.ISpellData;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import com.mrbysco.spelled.chat.SpellCastHandler;
import com.mrbysco.spelled.client.ClientHandler;
import com.mrbysco.spelled.commands.SpelledCommands;
import com.mrbysco.spelled.config.SpelledConfig;
import com.mrbysco.spelled.handler.CapabilityHandler;
import com.mrbysco.spelled.handler.LootHandler;
import com.mrbysco.spelled.handler.SpellHandler;
import com.mrbysco.spelled.packets.PacketHandler;
import com.mrbysco.spelled.registry.ReloadManager;
import com.mrbysco.spelled.registry.SpelledRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="spelled")
public class Spelled {
    public static final Logger LOGGER = LogUtils.getLogger();

    public Spelled() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SpelledConfig.commonSpec);
        eventBus.register(SpelledConfig.class);
        SpelledRegistry.BLOCKS.register(eventBus);
        SpelledRegistry.BLOCK_ENTITY_TYPES.register(eventBus);
        SpelledRegistry.MENU_TYPES.register(eventBus);
        SpelledRegistry.ITEMS.register(eventBus);
        SpelledRegistry.CREATIVE_MODE_TABS.register(eventBus);
        SpelledRegistry.ENTITY_TYPES.register(eventBus);
        SpelledRegistry.SOUND_EVENTS.register(eventBus);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::onCapabilityRegister);
        MinecraftForge.EVENT_BUS.register((Object)new ReloadManager());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SpellCastHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LootHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SpellHandler());
        MinecraftForge.EVENT_BUS.addListener(this::onCommandRegister);
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            eventBus.addListener(ClientHandler::onClientSetupEvent);
            eventBus.addListener(ClientHandler::registerEntityRenders);
            MinecraftForge.EVENT_BUS.addListener(ClientHandler::loginEvent);
        });
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.registerPackets();
    }

    public void onCapabilityRegister(RegisterCapabilitiesEvent event) {
        event.register(ISpellData.class);
    }

    public void onCommandRegister(RegisterCommandsEvent event) {
        SpelledCommands.initializeCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void serverStart(ServerStartingEvent event) {
        KeywordRegistry.instance().initializeKeywords();
        BehaviorRegistry.instance().initializeBehaviors();
    }
}

