/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.framework.message;

import com.mrcrayfish.configured.impl.framework.handler.FrameworkClientHandler;
import com.mrcrayfish.configured.impl.framework.handler.FrameworkServerHandler;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class MessageFramework {

    public record Response(byte[] data) {
        public static final ResourceLocation ID = new ResourceLocation("configured", "response_framework_config");

        public static void encode(Response message, FriendlyByteBuf buf) {
            buf.m_130087_(message.data());
        }

        public static Response decode(FriendlyByteBuf buf) {
            return new Response(buf.m_130052_());
        }

        public static void handle(Response message, Consumer<Runnable> executor, Consumer<Component> disconnect) {
            executor.accept(() -> FrameworkClientHandler.handleResponse(message, disconnect));
        }
    }

    public record Request(ResourceLocation id) {
        public static final ResourceLocation ID = new ResourceLocation("configured", "request_framework_config");

        public static void encode(Request message, FriendlyByteBuf buf) {
            buf.m_130085_(message.id());
        }

        public static Request decode(FriendlyByteBuf buf) {
            return new Request(buf.m_130281_());
        }

        public static void handle(Request message, Consumer<Runnable> executor, @Nullable Player player, Consumer<Component> disconnect) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                executor.accept(() -> FrameworkServerHandler.handleRequestConfig(serverPlayer, message, disconnect));
            }
        }
    }

    public record Sync(ResourceLocation id, byte[] data) {
        public static final ResourceLocation ID = new ResourceLocation("configured", "sync_framework_config");

        public static void encode(Sync message, FriendlyByteBuf buffer) {
            buffer.m_130085_(message.id);
            buffer.m_130087_(message.data);
        }

        public static Sync decode(FriendlyByteBuf buffer) {
            return new Sync(buffer.m_130281_(), buffer.m_130052_());
        }

        public static void handle(Sync message, Consumer<Runnable> executor, @Nullable Player player, Consumer<Component> disconnect) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                executor.accept(() -> FrameworkServerHandler.handleServerSync(serverPlayer, message, disconnect));
            }
        }
    }
}

