/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.io.sentry;

import java.io.Closeable;
import java.io.IOException;
import net.creeperhost.polylib.io.sentry.IHub;
import net.creeperhost.polylib.io.sentry.Integration;
import net.creeperhost.polylib.io.sentry.SentryLevel;
import net.creeperhost.polylib.io.sentry.SentryOptions;
import net.creeperhost.polylib.io.sentry.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ShutdownHookIntegration
implements Integration,
Closeable {
    @NotNull
    private final Runtime runtime;
    @Nullable
    private Thread thread;

    @TestOnly
    public ShutdownHookIntegration(@NotNull Runtime runtime) {
        this.runtime = Objects.requireNonNull(runtime, "Runtime is required");
    }

    public ShutdownHookIntegration() {
        this(Runtime.getRuntime());
    }

    @Override
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull(hub, "Hub is required");
        Objects.requireNonNull(options, "SentryOptions is required");
        if (options.isEnableShutdownHook()) {
            this.thread = new Thread(() -> hub.flush(options.getFlushTimeoutMillis()));
            this.runtime.addShutdownHook(this.thread);
            options.getLogger().log(SentryLevel.DEBUG, "ShutdownHookIntegration installed.", new Object[0]);
        } else {
            options.getLogger().log(SentryLevel.INFO, "enableShutdownHook is disabled.", new Object[0]);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.thread != null) {
            this.runtime.removeShutdownHook(this.thread);
        }
    }

    @VisibleForTesting
    @Nullable
    Thread getHook() {
        return this.thread;
    }
}

